/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.integration.runtime.sb.jmx;

import io.syndesis.integration.runtime.jmx.CamelContextMetadataMBean;
import io.syndesis.integration.runtime.sb.logging.IntegrationLoggingConfiguration;
import org.apache.camel.CamelContext;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.CamelContextConfiguration;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@ConditionalOnClass(value={CamelAutoConfiguration.class})
@ConditionalOnProperty(prefix="syndesis.integration.runtime.metadata", name={"enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={IntegrationLoggingConfiguration.class})
public class IntegrationMetadataAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntegrationMetadataAutoConfiguration.class);

    @Bean
    public CamelContextConfiguration integrationContextMetadataConfiguration() {
        return new CamelContextConfiguration(){

            public void beforeApplicationStart(CamelContext camelContext) {
                try {
                    camelContext.addService((Object)new CamelContextMetadataMBean());
                    LOGGER.info("Added Syndesis MBean Service");
                }
                catch (Exception e) {
                    ObjectHelper.wrapRuntimeCamelException((Throwable)e);
                }
            }

            public void afterApplicationStart(CamelContext camelContext) {
            }
        };
    }
}

