/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.integration.runtime.sb.logging;

import io.syndesis.integration.runtime.ActivityTrackingPolicyFactory;
import io.syndesis.integration.runtime.logging.ActivityTracker;
import io.syndesis.integration.runtime.logging.ActivityTrackingInterceptStrategy;
import io.syndesis.integration.runtime.logging.BodyLogger;
import io.syndesis.integration.runtime.logging.FlowActivityTrackingPolicyFactory;
import io.syndesis.integration.runtime.logging.IntegrationActivityTrackingPolicyFactory;
import io.syndesis.integration.runtime.sb.logging.IntegrationLoggingCamelContextConfiguration;
import io.syndesis.integration.runtime.sb.logging.IntegrationLoggingConfiguration;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.CamelContextConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@ConditionalOnClass(value={CamelAutoConfiguration.class})
@ConditionalOnProperty(prefix="syndesis.integration.runtime.logging", name={"enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={IntegrationLoggingConfiguration.class})
public class IntegrationLoggingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ActivityTracker.class})
    public ActivityTracker activityTracker() {
        return new ActivityTracker.SysOut();
    }

    @Bean
    public CamelContextConfiguration integrationLoggingContextConfiguration(ActivityTracker activityTracker) {
        return new IntegrationLoggingCamelContextConfiguration(activityTracker);
    }

    @Bean
    @ConditionalOnMissingBean(value={BodyLogger.class})
    public BodyLogger bodyLogger() {
        return new BodyLogger.Default();
    }

    @Bean
    public InterceptStrategy integrationLoggingInterceptStrategy(ActivityTracker activityTracker) {
        return new ActivityTrackingInterceptStrategy(activityTracker);
    }

    @Bean
    public ActivityTrackingPolicyFactory integrationActivityTrackingPolicyFactory(ActivityTracker activityTracker) {
        return new IntegrationActivityTrackingPolicyFactory(activityTracker);
    }

    @Bean
    public ActivityTrackingPolicyFactory flowActivityTrackingPolicyFactory(ActivityTracker activityTracker) {
        return new FlowActivityTrackingPolicyFactory(activityTracker);
    }
}

