/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.integration.runtime.sb.tracing;

import io.opentracing.Tracer;
import io.syndesis.integration.runtime.ActivityTrackingPolicyFactory;
import io.syndesis.integration.runtime.sb.tracing.TracingCamelContextConfiguration;
import io.syndesis.integration.runtime.sb.tracing.TracingConfiguration;
import io.syndesis.integration.runtime.tracing.TracingActivityTrackingPolicyFactory;
import io.syndesis.integration.runtime.tracing.TracingInterceptStrategy;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.CamelContextConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@ConditionalOnClass(value={CamelAutoConfiguration.class})
@ConditionalOnProperty(prefix="syndesis.integration.runtime.tracing", name={"enabled"}, matchIfMissing=false)
@EnableConfigurationProperties(value={TracingConfiguration.class})
public class TracingAutoConfiguration {
    @Bean
    public CamelContextConfiguration integrationLoggingContextConfiguration(Tracer tracer) {
        return new TracingCamelContextConfiguration(tracer);
    }

    @Bean
    public InterceptStrategy integrationLoggingInterceptStrategy(Tracer tracer) {
        return new TracingInterceptStrategy(tracer);
    }

    @Bean
    public ActivityTrackingPolicyFactory activityTrackingPolicyFactory(Tracer tracer) {
        return new TracingActivityTrackingPolicyFactory(tracer);
    }
}

