/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.connector.salesforce;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.camel.component.connector.DefaultConnectorComponent;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.utils.JsonUtils;

public class SalesforceUpdateSObjectComponent
extends DefaultConnectorComponent {
    public SalesforceUpdateSObjectComponent() {
        super("salesforce-update-sobject", SalesforceUpdateSObjectComponent.class.getName());
        this.setBeforeProducer(exchange -> {
            ObjectMapper mapper = JsonUtils.createObjectMapper();
            JsonNode node = mapper.readTree((String)exchange.getIn().getBody(String.class));
            JsonNode sObjectId = node.get("Id");
            if (sObjectId == null) {
                exchange.setException((Throwable)new SalesforceException("Missing field Id", 404));
            } else {
                exchange.getIn().setHeader("sObjectId", (Object)sObjectId.asText());
            }
            SalesforceUpdateSObjectComponent.clearBaseFields((ObjectNode)node);
            exchange.getIn().setBody((Object)mapper.writeValueAsString((Object)node));
        });
    }

    private static void clearBaseFields(ObjectNode node) {
        node.remove("attributes");
        node.remove("Id");
        node.remove("IsDeleted");
        node.remove("CreatedDate");
        node.remove("CreatedById");
        node.remove("LastModifiedDate");
        node.remove("LastModifiedById");
        node.remove("SystemModstamp");
        node.remove("LastActivityDate");
    }
}

