/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator;

import io.syndesis.common.model.WithResourceId;
import io.syndesis.common.model.api.APISummary;
import io.syndesis.common.model.connection.Connector;
import io.syndesis.common.model.connection.ConnectorSettings;
import io.syndesis.common.model.connection.ConnectorTemplate;
import io.syndesis.common.util.KeyGenerator;
import io.syndesis.server.api.generator.util.IconGenerator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class ConnectorGenerator {
    public abstract Connector generate(ConnectorTemplate var1, ConnectorSettings var2);

    public abstract APISummary info(ConnectorTemplate var1, ConnectorSettings var2);

    protected final Connector baseConnectorFrom(ConnectorTemplate connectorTemplate, ConnectorSettings connectorSettings) {
        Set properties = connectorTemplate.getProperties().keySet();
        Map<String, String> configuredProperties = connectorSettings.getConfiguredProperties().entrySet().stream().filter(e -> properties.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        String name = Optional.ofNullable(connectorSettings.getName()).orElseGet(() -> this.determineConnectorName(connectorTemplate, connectorSettings));
        String description = Optional.ofNullable(connectorSettings.getDescription()).orElseGet(() -> this.determineConnectorDescription(connectorTemplate, connectorSettings));
        Optional connectorGroup = connectorTemplate.getConnectorGroup();
        String icon = connectorSettings.getIcon() != null ? connectorSettings.getIcon() : IconGenerator.generate((String)connectorTemplate.getId().get(), name);
        return new Connector.Builder().id(KeyGenerator.createKey()).name(name).description(description).icon(icon).configuredProperties(configuredProperties).connectorGroup(connectorGroup).connectorGroupId(connectorGroup.map(WithResourceId::getId).orElse(Optional.empty())).build();
    }

    protected String determineConnectorDescription(ConnectorTemplate connectorTemplate, ConnectorSettings connectorSettings) {
        return "unspecified";
    }

    protected String determineConnectorName(ConnectorTemplate connectorTemplate, ConnectorSettings connectorSettings) {
        return "unspecified";
    }
}

