/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.swagger;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.models.Info;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.RefParameter;
import io.swagger.models.parameters.SerializableParameter;
import io.syndesis.common.model.DataShape;
import io.syndesis.common.model.DataShapeKinds;
import io.syndesis.common.model.action.Action;
import io.syndesis.common.model.action.ActionsSummary;
import io.syndesis.common.model.action.ConnectorAction;
import io.syndesis.common.model.action.ConnectorDescriptor;
import io.syndesis.common.model.api.APISummary;
import io.syndesis.common.model.connection.ConfigurationProperty;
import io.syndesis.common.model.connection.Connector;
import io.syndesis.common.model.connection.ConnectorSettings;
import io.syndesis.common.model.connection.ConnectorTemplate;
import io.syndesis.server.api.generator.APIValidationContext;
import io.syndesis.server.api.generator.ConnectorGenerator;
import io.syndesis.server.api.generator.swagger.PropertyGenerators;
import io.syndesis.server.api.generator.swagger.SwaggerModelInfo;
import io.syndesis.server.api.generator.swagger.util.JsonSchemaHelper;
import io.syndesis.server.api.generator.swagger.util.OperationDescription;
import io.syndesis.server.api.generator.swagger.util.SwaggerHelper;
import io.syndesis.server.api.generator.util.ActionComparator;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

abstract class BaseSwaggerConnectorGenerator
extends ConnectorGenerator {
    static final DataShape DATA_SHAPE_NONE = new DataShape.Builder().kind(DataShapeKinds.NONE).build();
    static final ConfigurationProperty OPERATION_ID_PROPERTY = new ConfigurationProperty.Builder().kind("property").displayName("Operation ID").group("producer").label("producer").required(Boolean.valueOf(true)).type("hidden").javaType("java.lang.String").deprecated(Boolean.valueOf(false)).secret(Boolean.valueOf(false)).componentProperty(Boolean.valueOf(false)).description("ID of operation to invoke").build();
    static final String URL_EXTENSION = "x-syndesis-swagger-url";

    BaseSwaggerConnectorGenerator() {
    }

    @Override
    public final Connector generate(ConnectorTemplate connectorTemplate, ConnectorSettings connectorSettings) {
        Connector connector = this.basicConnector(connectorTemplate, connectorSettings);
        return this.configureConnector(connectorTemplate, connector, connectorSettings);
    }

    @Override
    public final APISummary info(ConnectorTemplate connectorTemplate, ConnectorSettings connectorSettings) {
        SwaggerModelInfo swaggerInfo = BaseSwaggerConnectorGenerator.parseSpecification(connectorSettings, APIValidationContext.CONSUMED_API);
        Swagger model = swaggerInfo.getModel();
        if (model == null) {
            APISummary.Builder summaryBuilder = new APISummary.Builder().errors(swaggerInfo.getErrors()).warnings(swaggerInfo.getWarnings());
            if (swaggerInfo.getResolvedSpecification() != null) {
                summaryBuilder.putConfiguredProperty("specification", swaggerInfo.getResolvedSpecification());
            }
            return summaryBuilder.build();
        }
        Connector connector = this.basicConnector(connectorTemplate, connectorSettings);
        Map paths = model.getPaths();
        AtomicInteger total = new AtomicInteger(0);
        Map<Object, Object> tagCounts = paths == null ? Collections.emptyMap() : paths.entrySet().stream().flatMap(p -> ((Path)p.getValue()).getOperations().stream()).peek(o -> total.incrementAndGet()).flatMap(o -> SwaggerHelper.sanitizeTags(o.getTags()).distinct()).collect(Collectors.groupingBy(Function.identity(), Collectors.reducing(0, e -> 1, Integer::sum)));
        ActionsSummary actionsSummary = new ActionsSummary.Builder().totalActions(total.intValue()).actionCountByTags(tagCounts).build();
        return new APISummary.Builder().createFrom(connector).actionsSummary(actionsSummary).errors(swaggerInfo.getErrors()).warnings(swaggerInfo.getWarnings()).putConfiguredProperty("specification", swaggerInfo.getResolvedSpecification()).build();
    }

    abstract ConnectorDescriptor.Builder createDescriptor(ObjectNode var1, Swagger var2, Operation var3);

    protected final Connector basicConnector(ConnectorTemplate connectorTemplate, ConnectorSettings connectorSettings) {
        Swagger swagger = BaseSwaggerConnectorGenerator.parseSpecification(connectorSettings, APIValidationContext.NONE).getModel();
        String specification = BaseSwaggerConnectorGenerator.requiredSpecification(connectorSettings);
        if (specification.startsWith("http")) {
            swagger.vendorExtension(URL_EXTENSION, (Object)URI.create(specification));
        }
        Connector baseConnector = this.baseConnectorFrom(connectorTemplate, connectorSettings);
        Connector.Builder builder = new Connector.Builder().createFrom(baseConnector);
        Map alreadyConfiguredProperties = builder.build().getConfiguredProperties();
        connectorTemplate.getConnectorProperties().forEach((propertyName, template) -> {
            Optional<ConfigurationProperty> maybeProperty = PropertyGenerators.createProperty(propertyName, swagger, template);
            maybeProperty.ifPresent(property -> {
                String defaultValue;
                builder.putProperty(propertyName, property);
                if (!alreadyConfiguredProperties.containsKey(propertyName) && (defaultValue = property.getDefaultValue()) != null) {
                    builder.putConfiguredProperty(propertyName, defaultValue);
                }
            });
        });
        return builder.build();
    }

    protected final Connector configureConnector(ConnectorTemplate connectorTemplate, Connector connector, ConnectorSettings connectorSettings) {
        Connector.Builder builder = new Connector.Builder().createFrom(connector);
        SwaggerModelInfo info = BaseSwaggerConnectorGenerator.parseSpecification(connectorSettings, APIValidationContext.NONE);
        Swagger swagger = info.getModel();
        BaseSwaggerConnectorGenerator.addGlobalParameters(builder, swagger);
        Map paths = swagger.getPaths();
        String connectorId = (String)connector.getId().get();
        String connectorGav = connectorTemplate.getCamelConnectorGAV();
        String connectorScheme = connectorTemplate.getCamelConnectorPrefix();
        ArrayList<ConnectorAction> actions = new ArrayList<ConnectorAction>();
        HashMap<String, Integer> operationIdCounts = new HashMap<String, Integer>();
        int idx = 0;
        for (Map.Entry pathEntry : paths.entrySet()) {
            Path path = (Path)pathEntry.getValue();
            Map operationMap = path.getOperationMap();
            for (Map.Entry entry : operationMap.entrySet()) {
                Operation operation = (Operation)entry.getValue();
                String operationId = operation.getOperationId();
                if (operationId == null) {
                    operation.operationId("operation-" + idx++);
                } else {
                    Integer count = operationIdCounts.compute(operationId, (id, currentCount) -> Optional.ofNullable(currentCount).map(c -> {
                        c = c + 1;
                        return c;
                    }).orElse(0));
                    if (count > 0) {
                        operation.operationId(operationId + count);
                    }
                }
                ConnectorDescriptor descriptor = this.createDescriptor(info.getResolvedJsonGraph(), swagger, operation).camelConnectorGAV(connectorGav).camelConnectorPrefix(connectorScheme).connectorId(connectorId).build();
                OperationDescription description = SwaggerHelper.operationDescriptionOf(swagger, operation, (m, p) -> "Send " + m + " request to " + p);
                ConnectorAction action = new ConnectorAction.Builder().id(BaseSwaggerConnectorGenerator.createActionId(connectorId, connectorGav, operation)).name(description.name).description(description.description).pattern(Action.Pattern.To).descriptor(descriptor).tags(SwaggerHelper.sanitizeTags(operation.getTags()).distinct()::iterator).build();
                actions.add(action);
            }
        }
        actions.sort(ActionComparator.INSTANCE);
        builder.addAllActions(actions);
        builder.putConfiguredProperty("specification", SwaggerHelper.minimalSwaggerUsedByComponent(swagger));
        return builder.build();
    }

    @Override
    protected final String determineConnectorDescription(ConnectorTemplate connectorTemplate, ConnectorSettings connectorSettings) {
        Swagger swagger = BaseSwaggerConnectorGenerator.parseSpecification(connectorSettings, APIValidationContext.NONE).getModel();
        Info info = swagger.getInfo();
        if (info == null) {
            return super.determineConnectorDescription(connectorTemplate, connectorSettings);
        }
        String description = info.getDescription();
        if (description == null) {
            return super.determineConnectorDescription(connectorTemplate, connectorSettings);
        }
        return description;
    }

    @Override
    protected final String determineConnectorName(ConnectorTemplate connectorTemplate, ConnectorSettings connectorSettings) {
        SwaggerModelInfo modelInfo = BaseSwaggerConnectorGenerator.parseSpecification(connectorSettings, APIValidationContext.NONE);
        if (!modelInfo.getErrors().isEmpty()) {
            throw new IllegalArgumentException("Given OpenAPI specification contains errors: " + modelInfo);
        }
        Swagger swagger = modelInfo.getModel();
        Info info = swagger.getInfo();
        if (info == null) {
            return super.determineConnectorName(connectorTemplate, connectorSettings);
        }
        String title = info.getTitle();
        if (title == null) {
            return super.determineConnectorName(connectorTemplate, connectorSettings);
        }
        return title;
    }

    static void addGlobalParameters(Connector.Builder builder, Swagger swagger) {
        Map globalParameters = swagger.getParameters();
        if (globalParameters != null) {
            globalParameters.forEach((name, parameter) -> BaseSwaggerConnectorGenerator.createPropertyFromParameter(parameter).ifPresent(property -> builder.putProperty(name, property)));
        }
    }

    static String createActionId(String connectorId, String connectorGav, Operation operation) {
        return connectorGav + ":" + connectorId + ":" + operation.getOperationId();
    }

    static List<ConfigurationProperty.PropertyValue> createEnums(List<String> enums) {
        return enums.stream().map(BaseSwaggerConnectorGenerator::createPropertyValue).collect(Collectors.toList());
    }

    static Optional<ConfigurationProperty> createPropertyFromParameter(Parameter parameter) {
        if (parameter instanceof RefParameter || parameter instanceof BodyParameter) {
            return Optional.empty();
        }
        if (!(parameter instanceof AbstractSerializableParameter)) {
            throw new IllegalArgumentException("Unexpected parameter type received, neither ref, body nor serializable: " + parameter);
        }
        String name = StringUtils.trimToNull((String)parameter.getName());
        String description = StringUtils.trimToNull((String)parameter.getDescription());
        boolean required = parameter.getRequired();
        ConfigurationProperty.Builder propertyBuilder = new ConfigurationProperty.Builder().kind("property").displayName(name).description(description).group("producer").required(Boolean.valueOf(required)).componentProperty(Boolean.valueOf(false)).deprecated(Boolean.valueOf(false)).secret(Boolean.valueOf(false));
        AbstractSerializableParameter serializableParameter = (AbstractSerializableParameter)parameter;
        Object defaultValue = serializableParameter.getDefaultValue();
        if (defaultValue != null) {
            propertyBuilder.defaultValue(String.valueOf(defaultValue));
        }
        String type = serializableParameter.getType();
        propertyBuilder.type(type).javaType(JsonSchemaHelper.javaTypeFor((SerializableParameter)serializableParameter));
        List enums = serializableParameter.getEnum();
        if (enums != null) {
            propertyBuilder.addAllEnum(BaseSwaggerConnectorGenerator.createEnums(enums));
        }
        return Optional.of(propertyBuilder.build());
    }

    static ConfigurationProperty.PropertyValue createPropertyValue(String value) {
        return new ConfigurationProperty.PropertyValue.Builder().label(value).value(value).build();
    }

    static SwaggerModelInfo parseSpecification(ConnectorSettings connectorSettings, APIValidationContext validationContext) {
        String specification = BaseSwaggerConnectorGenerator.requiredSpecification(connectorSettings);
        return SwaggerHelper.parse(specification, validationContext);
    }

    static String requiredSpecification(ConnectorSettings connectorSettings) {
        Map configuredProperties = connectorSettings.getConfiguredProperties();
        String specification = (String)configuredProperties.get("specification");
        if (specification == null) {
            throw new IllegalArgumentException("Configured properties of the given connector template does not include `specification` property");
        }
        return specification;
    }
}

