/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.swagger;

import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.auth.AbstractSecuritySchemeDefinition;
import io.swagger.models.auth.BasicAuthDefinition;
import io.swagger.models.auth.OAuth2Definition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.syndesis.common.model.connection.ConfigurationProperty;
import io.syndesis.server.api.generator.swagger.SupportedAuthenticationTypes;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

enum PropertyGenerators {
    accessToken{

        @Override
        protected BiFunction<Swagger, ConfigurationProperty, Optional<ConfigurationProperty>> propertyValueExtractor() {
            return (x$0, x$1) -> PropertyGenerators.ifHasOAuthSecurityDefinition(x$0, x$1);
        }
    }
    ,
    accessTokenExpiresAt{

        @Override
        protected BiFunction<Swagger, ConfigurationProperty, Optional<ConfigurationProperty>> propertyValueExtractor() {
            return (x$0, x$1) -> PropertyGenerators.ifHasOAuthSecurityDefinition(x$0, x$1);
        }
    }
    ,
    authenticationType{

        @Override
        protected BiFunction<Swagger, ConfigurationProperty, Optional<ConfigurationProperty>> propertyValueExtractor() {
            return (swagger, template) -> {
                Map securityDefinitions = swagger.getSecurityDefinitions();
                if (securityDefinitions == null || securityDefinitions.isEmpty()) {
                    return Optional.of(new ConfigurationProperty.Builder().createFrom(template).defaultValue("none").addEnum(NO_SECURITY).build());
                }
                ConfigurationProperty.PropertyValue[] enums = (ConfigurationProperty.PropertyValue[])securityDefinitions.values().stream().map(SecuritySchemeDefinition::getType).filter(SupportedAuthenticationTypes.SUPPORTED::contains).map(SupportedAuthenticationTypes::valueOf).map(SupportedAuthenticationTypes::asPropertyValue).toArray(ConfigurationProperty.PropertyValue[]::new);
                ConfigurationProperty.Builder authenticationType = new ConfigurationProperty.Builder().createFrom(template).addEnum(enums);
                if (enums.length == 1) {
                    authenticationType.defaultValue(enums[0].getValue());
                }
                return Optional.of(authenticationType.build());
            };
        }
    }
    ,
    authorizationEndpoint{

        @Override
        protected BiFunction<Swagger, ConfigurationProperty, Optional<ConfigurationProperty>> propertyValueExtractor() {
            return (swagger, template) -> PropertyGenerators.oauthProperty(swagger, template, OAuth2Definition::getAuthorizationUrl);
        }
    }
    ,
    authorizeUsingParameters{

        @Override
        protected BiFunction<Swagger, ConfigurationProperty, Optional<ConfigurationProperty>> propertyValueExtractor() {
            return (swagger, template) -> PropertyGenerators.oauthVendorProperty(swagger, template, "x-authorize-using-parameters");
        }
    }
    ,
    basePath{

        @Override
        protected BiFunction<Swagger, ConfigurationProperty, Optional<ConfigurationProperty>> propertyValueExtractor() {
            return PropertyGenerators.withDefaultValue(Swagger::getBasePath);
        }
    }
    ,
    clientId{

        @Override
        protected BiFunction<Swagger, ConfigurationProperty, Optional<ConfigurationProperty>> propertyValueExtractor() {
            return (x$0, x$1) -> PropertyGenerators.ifHasOAuthSecurityDefinition(x$0, x$1);
        }
    }
    ,
    clientSecret{

        @Override
        protected BiFunction<Swagger, ConfigurationProperty, Optional<ConfigurationProperty>> propertyValueExtractor() {
            return (x$0, x$1) -> PropertyGenerators.ifHasOAuthSecurityDefinition(x$0, x$1);
        }
    }
    ,
    host{

        @Override
        protected BiFunction<Swagger, ConfigurationProperty, Optional<ConfigurationProperty>> propertyValueExtractor() {
            return PropertyGenerators.withDefaultValue(PropertyGenerators::determineHost);
        }
    }
    ,
    oauthScopes{

        @Override
        protected BiFunction<Swagger, ConfigurationProperty, Optional<ConfigurationProperty>> propertyValueExtractor() {
            return (swagger, template) -> PropertyGenerators.oauthProperty(swagger, template, d -> d.getScopes().keySet().stream().collect(Collectors.joining(" ")));
        }
    }
    ,
    password{

        @Override
        protected BiFunction<Swagger, ConfigurationProperty, Optional<ConfigurationProperty>> propertyValueExtractor() {
            return (x$0, x$1) -> PropertyGenerators.ifHasBasicSecurityDefinition(x$0, x$1);
        }
    }
    ,
    refreshToken{

        @Override
        protected BiFunction<Swagger, ConfigurationProperty, Optional<ConfigurationProperty>> propertyValueExtractor() {
            return (x$0, x$1) -> PropertyGenerators.ifHasOAuthSecurityDefinition(x$0, x$1);
        }
    }
    ,
    refreshTokenRetryStatuses{

        @Override
        protected BiFunction<Swagger, ConfigurationProperty, Optional<ConfigurationProperty>> propertyValueExtractor() {
            return (swagger, template) -> PropertyGenerators.oauthVendorProperty(swagger, template, "x-refresh-token-retry-statuses");
        }
    }
    ,
    specification{

        @Override
        protected BiFunction<Swagger, ConfigurationProperty, Optional<ConfigurationProperty>> propertyValueExtractor() {
            return (x$0, x$1) -> PropertyGenerators.fromTemplate(x$0, x$1);
        }
    }
    ,
    tokenEndpoint{

        @Override
        protected BiFunction<Swagger, ConfigurationProperty, Optional<ConfigurationProperty>> propertyValueExtractor() {
            return (swagger, template) -> PropertyGenerators.oauthProperty(swagger, template, OAuth2Definition::getTokenUrl);
        }
    }
    ,
    tokenStrategy{

        @Override
        protected BiFunction<Swagger, ConfigurationProperty, Optional<ConfigurationProperty>> propertyValueExtractor() {
            return (swagger, template) -> PropertyGenerators.oauthVendorProperty(swagger, template, "x-token-strategy");
        }
    }
    ,
    username{

        @Override
        protected BiFunction<Swagger, ConfigurationProperty, Optional<ConfigurationProperty>> propertyValueExtractor() {
            return (x$0, x$1) -> PropertyGenerators.ifHasBasicSecurityDefinition(x$0, x$1);
        }
    };

    private static final ConfigurationProperty.PropertyValue NO_SECURITY;

    protected abstract BiFunction<Swagger, ConfigurationProperty, Optional<ConfigurationProperty>> propertyValueExtractor();

    static String createHostUri(String scheme, String host, int port) {
        try {
            if (port == -1) {
                return new URI(scheme, host, null, null).toString();
            }
            return new URI(scheme, null, host, port, null, null, null).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static Optional<ConfigurationProperty> createProperty(String propertyName, Swagger swagger, ConfigurationProperty template) {
        PropertyGenerators propertyGenerator = PropertyGenerators.valueOf(propertyName);
        return propertyGenerator.propertyValueExtractor().apply(swagger, template);
    }

    static String determineHost(Swagger swagger) {
        int portToUse;
        Map vendorExtensions = Optional.ofNullable(swagger.getVendorExtensions()).orElse(Collections.emptyMap());
        URI specificationUrl = (URI)vendorExtensions.get("x-syndesis-swagger-url");
        String schemeToUse = PropertyGenerators.determineSchemeToUse(swagger, specificationUrl);
        if (schemeToUse == null) {
            return null;
        }
        String specificationHost = swagger.getHost();
        boolean specificationWithoutHost = StringUtils.isEmpty((CharSequence)specificationHost);
        if (specificationWithoutHost && specificationUrl == null) {
            return null;
        }
        String hostToUse = specificationWithoutHost && specificationUrl != null ? specificationUrl.getHost() : swagger.getHost();
        int colonIdx = hostToUse.indexOf(58);
        if (colonIdx == -1) {
            portToUse = -1;
        } else {
            portToUse = Integer.parseUnsignedInt(hostToUse.substring(colonIdx + 1));
            hostToUse = hostToUse.substring(0, colonIdx);
        }
        return PropertyGenerators.createHostUri(schemeToUse, hostToUse, portToUse);
    }

    private static String determineSchemeToUse(Swagger swagger, URI specificationUrl) {
        boolean noSchemes;
        List schemes = swagger.getSchemes();
        boolean bl = noSchemes = schemes == null || schemes.isEmpty();
        if (noSchemes && specificationUrl == null) {
            return null;
        }
        String schemeToUse = noSchemes && specificationUrl != null ? specificationUrl.getScheme() : (schemes.contains(Scheme.HTTPS) ? "https" : (String)schemes.stream().filter(s -> s.toValue().startsWith("http")).map(s -> s.toValue()).findFirst().orElse(null));
        return schemeToUse;
    }

    private static Optional<ConfigurationProperty> fromTemplate(Swagger swagger, ConfigurationProperty template) {
        return Optional.of(template);
    }

    private static Optional<ConfigurationProperty> ifHasBasicSecurityDefinition(Swagger swagger, ConfigurationProperty template) {
        return PropertyGenerators.ifHasSecurityDefinition(swagger, template, BasicAuthDefinition.class);
    }

    private static Optional<ConfigurationProperty> ifHasOAuthSecurityDefinition(Swagger swagger, ConfigurationProperty template) {
        return PropertyGenerators.ifHasSecurityDefinition(swagger, template, OAuth2Definition.class);
    }

    private static Optional<ConfigurationProperty> ifHasSecurityDefinition(Swagger swagger, ConfigurationProperty template, Class<? extends AbstractSecuritySchemeDefinition> type) {
        if (PropertyGenerators.securityDefinition(swagger, type).isPresent()) {
            return Optional.of(template);
        }
        return Optional.empty();
    }

    private static Optional<ConfigurationProperty> oauthProperty(Swagger swagger, ConfigurationProperty template, Function<OAuth2Definition, String> defaultValueExtractor) {
        return PropertyGenerators.securityDefinition(swagger, OAuth2Definition.class).map(definition -> new ConfigurationProperty.Builder().createFrom(template).defaultValue((String)defaultValueExtractor.apply((OAuth2Definition)definition)).build());
    }

    private static Optional<ConfigurationProperty> oauthVendorProperty(Swagger swagger, ConfigurationProperty template, String name) {
        return PropertyGenerators.securityDefinition(swagger, OAuth2Definition.class).map(definition -> PropertyGenerators.vendorExtension((SecuritySchemeDefinition)definition, template, name)).orElse(Optional.empty());
    }

    private static <T extends AbstractSecuritySchemeDefinition> Optional<T> securityDefinition(Swagger swagger, Class<T> type) {
        Map securityDefinitions = swagger.getSecurityDefinitions();
        if (securityDefinitions == null) {
            return Optional.empty();
        }
        return securityDefinitions.values().stream().filter(type::isInstance).map(type::cast).findFirst();
    }

    private static Optional<ConfigurationProperty> vendorExtension(SecuritySchemeDefinition definition, ConfigurationProperty template, String name) {
        Map vendorExtensions = definition.getVendorExtensions();
        if (vendorExtensions == null) {
            return Optional.empty();
        }
        Object value = vendorExtensions.get(name);
        if (value == null) {
            return Optional.empty();
        }
        ConfigurationProperty property = new ConfigurationProperty.Builder().createFrom(template).defaultValue(String.valueOf(value)).build();
        return Optional.of(property);
    }

    private static BiFunction<Swagger, ConfigurationProperty, Optional<ConfigurationProperty>> withDefaultValue(Function<Swagger, String> defaultValueExtractor) {
        return (swagger, template) -> Optional.of(new ConfigurationProperty.Builder().createFrom(template).defaultValue((String)defaultValueExtractor.apply((Swagger)swagger)).build());
    }

    static {
        NO_SECURITY = new ConfigurationProperty.PropertyValue.Builder().value("none").label("No Security").build();
    }
}

