/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.swagger;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.models.Swagger;
import io.syndesis.common.model.Violation;
import io.syndesis.common.util.Json;
import io.syndesis.server.api.generator.swagger.ImmutableSwaggerModelInfo;
import io.syndesis.server.api.generator.swagger.util.JsonSchemaHelper;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.immutables.value.Value;

@JsonDeserialize(builder=Builder.class)
@Value.Immutable
public interface SwaggerModelInfo {
    @Value.Default
    default public List<Violation> getErrors() {
        return Collections.emptyList();
    }

    public Swagger getModel();

    @Value.Lazy
    default public ObjectNode getResolvedJsonGraph() {
        try {
            ObjectNode json = (ObjectNode)Json.reader().readTree(this.getResolvedSpecification());
            return JsonSchemaHelper.resolvableNodeForSpecification(json);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to parse OpenAPI document resolved as JSON", e);
        }
    }

    public String getResolvedSpecification();

    @Value.Default
    default public List<Violation> getWarnings() {
        return Collections.emptyList();
    }

    public static class Builder
    extends ImmutableSwaggerModelInfo.Builder {
    }
}

