/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.swagger;

import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.syndesis.common.model.Violation;
import io.syndesis.server.api.generator.APIValidationContext;
import io.syndesis.server.api.generator.swagger.CyclicValidationCheck;
import io.syndesis.server.api.generator.swagger.SwaggerModelInfo;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class SyndesisSwaggerValidationRules
implements Function<SwaggerModelInfo, SwaggerModelInfo> {
    private static final Set<String> SUPPORTED_CONSUMED_AUTH_TYPES = new HashSet<String>(Arrays.asList("basic", "oauth2"));
    private final List<Function<SwaggerModelInfo, SwaggerModelInfo>> rules = new ArrayList<Function<SwaggerModelInfo, SwaggerModelInfo>>();

    private SyndesisSwaggerValidationRules(APIValidationContext context) {
        switch (context) {
            case CONSUMED_API: {
                this.rules.add(SyndesisSwaggerValidationRules::validateResponses);
                this.rules.add(SyndesisSwaggerValidationRules::validateConsumedAuthTypes);
                this.rules.add(SyndesisSwaggerValidationRules::validateScheme);
                this.rules.add(SyndesisSwaggerValidationRules::validateUniqueOperationIds);
                this.rules.add(SyndesisSwaggerValidationRules::validateCyclicReferences);
                this.rules.add(SyndesisSwaggerValidationRules::validateOperationsGiven);
                return;
            }
            case PROVIDED_API: {
                this.rules.add(SyndesisSwaggerValidationRules::validateResponses);
                this.rules.add(SyndesisSwaggerValidationRules::validateProvidedAuthTypes);
                this.rules.add(SyndesisSwaggerValidationRules::validateUniqueOperationIds);
                this.rules.add(SyndesisSwaggerValidationRules::validateNoMissingOperationIds);
                this.rules.add(SyndesisSwaggerValidationRules::validateCyclicReferences);
                this.rules.add(SyndesisSwaggerValidationRules::validateOperationsGiven);
                return;
            }
            case NONE: {
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported validation context " + (Object)((Object)context));
    }

    @Override
    public SwaggerModelInfo apply(SwaggerModelInfo swaggerModelInfo) {
        return this.rules.stream().reduce(Function::compose).map(f -> (SwaggerModelInfo)f.apply(swaggerModelInfo)).orElse(swaggerModelInfo);
    }

    public static SyndesisSwaggerValidationRules get(APIValidationContext context) {
        return new SyndesisSwaggerValidationRules(context);
    }

    static SwaggerModelInfo validateAuthTypesIn(SwaggerModelInfo swaggerModelInfo, Set<String> validAuthTypes) {
        if (swaggerModelInfo.getModel() == null) {
            return swaggerModelInfo;
        }
        SwaggerModelInfo.Builder withWarnings = new SwaggerModelInfo.Builder().createFrom(swaggerModelInfo);
        for (Map.Entry definitionEntry : SyndesisSwaggerValidationRules.notNull(swaggerModelInfo.getModel().getSecurityDefinitions()).entrySet()) {
            String authType = ((SecuritySchemeDefinition)definitionEntry.getValue()).getType();
            if (validAuthTypes.contains(authType)) continue;
            withWarnings.addWarning(new Violation.Builder().property("").error("unsupported-auth").message("Authentication type " + authType + " is currently not supported").build());
        }
        return withWarnings.build();
    }

    static SwaggerModelInfo validateConsumedAuthTypes(SwaggerModelInfo swaggerModelInfo) {
        return SyndesisSwaggerValidationRules.validateAuthTypesIn(swaggerModelInfo, SUPPORTED_CONSUMED_AUTH_TYPES);
    }

    static SwaggerModelInfo validateCyclicReferences(SwaggerModelInfo info) {
        if (CyclicValidationCheck.hasCyclicReferences(info.getModel())) {
            return new SwaggerModelInfo.Builder().createFrom(info).addError(new Violation.Builder().error("cyclic-schema").message("Cyclic references are not suported").build()).build();
        }
        return info;
    }

    static SwaggerModelInfo validateNoMissingOperationIds(SwaggerModelInfo info) {
        Swagger swagger = info.getModel();
        if (swagger == null || swagger.getPaths() == null) {
            return info;
        }
        long countNoOpId = swagger.getPaths().values().stream().flatMap(p -> p.getOperationMap().values().stream()).filter(o -> o.getOperationId() == null).count();
        if (countNoOpId == 0L) {
            return info;
        }
        SwaggerModelInfo.Builder withWarnings = new SwaggerModelInfo.Builder().createFrom(info);
        withWarnings.addWarning(new Violation.Builder().error("missing-operation-ids").message("Some operations (" + countNoOpId + ") have no operationId").build());
        return withWarnings.build();
    }

    static SwaggerModelInfo validateOperationsGiven(SwaggerModelInfo swaggerModelInfo) {
        Swagger swagger = swaggerModelInfo.getModel();
        if (swagger == null) {
            return swaggerModelInfo;
        }
        SwaggerModelInfo.Builder withErrors = new SwaggerModelInfo.Builder().createFrom(swaggerModelInfo);
        Map paths = swagger.getPaths();
        if (paths == null || paths.isEmpty()) {
            withErrors.addError(new Violation.Builder().property("paths").error("missing-paths").message("No paths defined").build());
        } else if (paths.values().stream().allMatch(p -> p.getOperations() == null || p.getOperations().isEmpty())) {
            withErrors.addError(new Violation.Builder().property("").error("missing-operations").message("No operations defined").build());
        }
        return withErrors.build();
    }

    static SwaggerModelInfo validateProvidedAuthTypes(SwaggerModelInfo swaggerModelInfo) {
        return SyndesisSwaggerValidationRules.validateAuthTypesIn(swaggerModelInfo, Collections.emptySet());
    }

    static SwaggerModelInfo validateResponses(SwaggerModelInfo swaggerModelInfo) {
        if (swaggerModelInfo.getModel() == null) {
            return swaggerModelInfo;
        }
        SwaggerModelInfo.Builder withWarnings = new SwaggerModelInfo.Builder().createFrom(swaggerModelInfo);
        for (Map.Entry pathEntry : SyndesisSwaggerValidationRules.notNull(swaggerModelInfo.getModel().getPaths()).entrySet()) {
            for (Map.Entry operationEntry : SyndesisSwaggerValidationRules.notNull(((Path)pathEntry.getValue()).getOperationMap()).entrySet()) {
                for (Parameter parameter : SyndesisSwaggerValidationRules.notNull(((Operation)operationEntry.getValue()).getParameters())) {
                    BodyParameter bodyParameter;
                    Model schema;
                    if (!(parameter instanceof BodyParameter) || !SyndesisSwaggerValidationRules.schemaIsNotSpecified(schema = (bodyParameter = (BodyParameter)parameter).getSchema())) continue;
                    String message = "Operation " + operationEntry.getKey() + " " + (String)pathEntry.getKey() + " does not provide a schema for the body parameter";
                    withWarnings.addWarning(new Violation.Builder().property("").error("missing-parameter-schema").message(message).build());
                }
                for (Map.Entry entry : SyndesisSwaggerValidationRules.notNull(((Operation)operationEntry.getValue()).getResponses()).entrySet()) {
                    if (((String)entry.getKey()).charAt(0) != '2' || ((Response)entry.getValue()).getSchema() != null) continue;
                    String message = "Operation " + operationEntry.getKey() + " " + (String)pathEntry.getKey() + " does not provide a response schema for code " + (String)entry.getKey();
                    withWarnings.addWarning(new Violation.Builder().property("").error("missing-response-schema").message(message).build());
                }
            }
        }
        return withWarnings.build();
    }

    static SwaggerModelInfo validateScheme(SwaggerModelInfo info) {
        Swagger swagger = info.getModel();
        if (swagger == null) {
            return info;
        }
        SwaggerModelInfo.Builder withWarnings = new SwaggerModelInfo.Builder().createFrom(info);
        URI specificationUrl = SyndesisSwaggerValidationRules.specificationUriFrom(swagger);
        List schemes = swagger.getSchemes();
        if (schemes == null || schemes.isEmpty()) {
            if (specificationUrl == null) {
                withWarnings.addWarning(new Violation.Builder().property("/schemes").error("missing-schemes").message("Unable to determine the scheme to use: OpenAPI document does not provide a `schemes` definition and the document was uploaded so the originating URL is lost.").build());
            }
        } else {
            boolean hasHttpSchemes = schemes.stream().filter(s -> s.toValue().startsWith("http")).findFirst().isPresent();
            if (!hasHttpSchemes) {
                withWarnings.addWarning(new Violation.Builder().property("/schemes").error("missing-schemes").message("Unable to determine the scheme to use: no supported scheme found within the OpenAPI document. Schemes given in the document: " + schemes.stream().map(s -> s.toValue()).collect(Collectors.joining(", "))).build());
            }
        }
        return withWarnings.build();
    }

    static SwaggerModelInfo validateUniqueOperationIds(SwaggerModelInfo info) {
        Swagger swagger = info.getModel();
        if (swagger == null || swagger.getPaths() == null) {
            return info;
        }
        Map operationIdCounts = swagger.getPaths().values().stream().flatMap(p -> p.getOperationMap().values().stream()).map(Operation::getOperationId).filter(Objects::nonNull).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        Map<String, Long> nonUnique = operationIdCounts.entrySet().stream().filter(e -> (Long)e.getValue() > 1L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (nonUnique.isEmpty()) {
            return info;
        }
        SwaggerModelInfo.Builder withWarnings = new SwaggerModelInfo.Builder().createFrom(info);
        withWarnings.addWarning(new Violation.Builder().error("non-unique-operation-ids").message("Found operations with non unique operationIds: " + String.join((CharSequence)", ", nonUnique.keySet())).build());
        return withWarnings.build();
    }

    private static <T> List<T> notNull(List<T> value) {
        return value != null ? value : Collections.emptyList();
    }

    private static <K, V> Map<K, V> notNull(Map<K, V> value) {
        return value != null ? value : Collections.emptyMap();
    }

    private static boolean schemaIsNotSpecified(Model schema) {
        if (schema == null) {
            return true;
        }
        if (schema instanceof ArrayModel) {
            return ((ArrayModel)schema).getItems() == null;
        }
        Map properties = schema.getProperties();
        boolean noProperties = properties == null || properties.isEmpty();
        boolean noReference = schema.getReference() == null;
        return noProperties && noReference;
    }

    private static URI specificationUriFrom(Swagger swagger) {
        Map vendorExtensions = Optional.ofNullable(swagger.getVendorExtensions()).orElse(Collections.emptyMap());
        return (URI)vendorExtensions.get("x-syndesis-swagger-url");
    }
}

