/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.swagger;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.models.Operation;
import io.swagger.models.Swagger;
import io.syndesis.common.model.DataShape;
import io.syndesis.server.api.generator.swagger.DataShapeGenerator;
import io.syndesis.server.api.generator.swagger.UnifiedJsonDataShapeGenerator;
import io.syndesis.server.api.generator.swagger.UnifiedXmlDataShapeGenerator;
import java.util.List;

public final class UnifiedDataShapeGenerator
implements DataShapeGenerator {
    private static final String APPLICATION_JSON = "application/json";
    private static final String APPLICATION_XML = "application/xml";
    private static final DataShapeGenerator JSON = new UnifiedJsonDataShapeGenerator();
    private static final DataShapeGenerator XML = new UnifiedXmlDataShapeGenerator();

    @Override
    public DataShape createShapeFromRequest(ObjectNode json, Swagger swagger, Operation operation) {
        if (UnifiedDataShapeGenerator.supports(APPLICATION_JSON, swagger.getConsumes(), operation.getConsumes())) {
            return JSON.createShapeFromRequest(json, swagger, operation);
        }
        if (UnifiedDataShapeGenerator.supports(APPLICATION_XML, swagger.getConsumes(), operation.getConsumes())) {
            return XML.createShapeFromRequest(json, swagger, operation);
        }
        return JSON.createShapeFromRequest(json, swagger, operation);
    }

    @Override
    public DataShape createShapeFromResponse(ObjectNode json, Swagger swagger, Operation operation) {
        if (UnifiedDataShapeGenerator.supports(APPLICATION_JSON, swagger.getProduces(), operation.getProduces())) {
            return JSON.createShapeFromResponse(json, swagger, operation);
        }
        if (UnifiedDataShapeGenerator.supports(APPLICATION_XML, swagger.getProduces(), operation.getProduces())) {
            return XML.createShapeFromResponse(json, swagger, operation);
        }
        return JSON.createShapeFromResponse(json, swagger, operation);
    }

    static boolean supports(String mime, List<String> defaultMimes, List<String> mimes) {
        boolean supports = false;
        if (mimes != null && !mimes.isEmpty()) {
            supports |= mimes.contains(mime);
        }
        if (defaultMimes != null && !defaultMimes.isEmpty()) {
            supports |= defaultMimes.contains(mime);
        }
        return supports;
    }
}

