/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.swagger;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.syndesis.common.model.DataShape;
import io.syndesis.common.model.DataShapeKinds;
import io.syndesis.common.util.Json;
import io.syndesis.server.api.generator.swagger.BaseDataShapeGenerator;
import io.syndesis.server.api.generator.swagger.util.JsonSchemaHelper;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;

public class UnifiedJsonDataShapeGenerator
extends BaseDataShapeGenerator {
    private static final Class<AbstractSerializableParameter<?>> PARAM_CLASS = AbstractSerializableParameter.class;
    private static final List<String> PROPERTIES_TO_REMOVE_ON_MERGE = Arrays.asList("$schema", "title");

    @Override
    public DataShape createShapeFromRequest(ObjectNode json, Swagger swagger, Operation operation) {
        ObjectNode bodySchema = UnifiedJsonDataShapeGenerator.createJsonSchemaForBodyOf(json, operation);
        ObjectNode parametersSchema = UnifiedJsonDataShapeGenerator.createJsonSchemaForParametersOf(operation);
        return UnifiedJsonDataShapeGenerator.unifiedJsonSchema("Request", "API request payload", bodySchema, parametersSchema);
    }

    @Override
    public DataShape createShapeFromResponse(ObjectNode json, Swagger swagger, Operation operation) {
        Optional<Response> maybeResponse = UnifiedJsonDataShapeGenerator.findResponse(operation);
        if (!maybeResponse.isPresent()) {
            return DATA_SHAPE_NONE;
        }
        Response response = maybeResponse.get();
        Model responseSchema = response.getResponseSchema();
        String description = response.getDescription();
        ObjectNode bodySchema = UnifiedJsonDataShapeGenerator.createSchemaFromModel(json, description, responseSchema);
        return UnifiedJsonDataShapeGenerator.unifiedJsonSchema("Response", "API response payload", bodySchema, null);
    }

    private static void addEnumsTo(ObjectNode parameterParameter, AbstractSerializableParameter<?> serializableParameter) {
        if (serializableParameter.getItems() != null) {
            List enums;
            Property items = serializableParameter.getItems();
            try {
                Method method = ClassUtils.getPublicMethod(items.getClass(), (String)"getEnum", (Class[])new Class[0]);
                enums = (List)method.invoke((Object)items, new Object[0]);
            }
            catch (ReflectiveOperationException ignored) {
                enums = Collections.emptyList();
            }
            ObjectNode itemsNode = parameterParameter.putObject("items");
            String itemType = items.getType();
            if (StringUtils.isNotBlank((CharSequence)itemType)) {
                itemsNode.put("type", itemType);
            }
            if (enums != null && !enums.isEmpty()) {
                ArrayNode enumArray = itemsNode.putArray("enum");
                enums.forEach(e -> enumArray.add(String.valueOf(e)));
            }
        } else {
            List enums = serializableParameter.getEnum();
            if (enums != null && !enums.isEmpty()) {
                ArrayNode enumArray = parameterParameter.putArray("enum");
                enums.forEach(arg_0 -> ((ArrayNode)enumArray).add(arg_0));
            }
        }
    }

    private static ObjectNode createJsonSchemaForBodyOf(ObjectNode json, Operation operation) {
        Optional<BodyParameter> maybeRequestBody = UnifiedJsonDataShapeGenerator.findBodyParameter(operation);
        if (!maybeRequestBody.isPresent()) {
            return null;
        }
        BodyParameter requestBody = maybeRequestBody.get();
        Model requestSchema = requestBody.getSchema();
        String name = Optional.ofNullable(requestBody.getName()).orElse(requestBody.getDescription());
        return UnifiedJsonDataShapeGenerator.createSchemaFromModel(json, name, requestSchema);
    }

    private static ObjectNode createJsonSchemaForParametersOf(Operation operation) {
        List operationParameters = operation.getParameters();
        List<AbstractSerializableParameter<?>> serializableParameters = operationParameters.stream().filter(PARAM_CLASS::isInstance).map(PARAM_CLASS::cast).collect(Collectors.toList());
        if (serializableParameters.isEmpty()) {
            return null;
        }
        return UnifiedJsonDataShapeGenerator.createSchemaFor(serializableParameters);
    }

    private static ObjectNode createPropertySchema(String name, Property schema) {
        String title;
        String type;
        ObjectNode jsonSchema = JsonNodeFactory.instance.objectNode();
        String format = schema.getFormat();
        if (JsonSchemaHelper.isKnownFormat(format)) {
            jsonSchema.put("format", format);
        }
        if ((type = schema.getType()) != null) {
            jsonSchema.put("type", type);
        }
        if ((title = schema.getName()) != null) {
            jsonSchema.put("title", title);
        } else {
            jsonSchema.put("title", name);
        }
        String description = schema.getDescription();
        if (description != null) {
            jsonSchema.put("description", description);
        }
        return jsonSchema;
    }

    private static ObjectNode createSchemaFor(List<AbstractSerializableParameter<?>> serializableParameters) {
        ObjectNode schema = JsonSchemaHelper.newJsonObjectSchema();
        ObjectNode properties = schema.putObject("properties");
        ObjectNode parameters = properties.putObject("parameters");
        parameters.put("type", "object");
        ObjectNode parametersProperties = parameters.putObject("properties");
        for (AbstractSerializableParameter<?> serializableParameter : serializableParameters) {
            Object defaultValue;
            String type = serializableParameter.getType();
            String name = StringUtils.trimToNull((String)serializableParameter.getName());
            String description = StringUtils.trimToNull((String)serializableParameter.getDescription());
            if ("file".equals(type)) continue;
            ObjectNode parameterParameter = parametersProperties.putObject(name);
            if (type != null) {
                parameterParameter.put("type", type);
            }
            if (name != null) {
                parameterParameter.put("title", name);
            }
            if (description != null) {
                parameterParameter.put("description", description);
            }
            if ((defaultValue = serializableParameter.getDefault()) != null) {
                parameterParameter.put("default", String.valueOf(defaultValue));
            }
            UnifiedJsonDataShapeGenerator.addEnumsTo(parameterParameter, serializableParameter);
        }
        return schema;
    }

    private static ObjectNode createSchemaFromModel(ObjectNode json, String name, Model schema) {
        if (schema instanceof ArrayModel) {
            Property items = ((ArrayModel)schema).getItems();
            ObjectNode itemSchema = UnifiedJsonDataShapeGenerator.createSchemaFromProperty(json, name, items);
            itemSchema.remove(Arrays.asList("$schema", "title"));
            ObjectNode jsonSchema = JsonNodeFactory.instance.objectNode();
            jsonSchema.put("type", "array");
            jsonSchema.set("items", (JsonNode)itemSchema);
            return jsonSchema;
        }
        if (schema instanceof ModelImpl) {
            return UnifiedJsonDataShapeGenerator.createSchemaFromModelImpl(name, schema);
        }
        String title = UnifiedJsonDataShapeGenerator.determineTitleOf(name, schema);
        return JsonSchemaHelper.resolveSchemaForReference(json, title, schema.getReference());
    }

    private static ObjectNode createSchemaFromModelImpl(String name, Model model) {
        ObjectNode schema = (ObjectNode)Json.convertValue((Object)model, ObjectNode.class);
        JsonSchemaHelper.sanitize((JsonNode)schema);
        String title = UnifiedJsonDataShapeGenerator.determineTitleOf(name, model);
        return JsonSchemaHelper.createJsonSchema(title, schema);
    }

    private static ObjectNode createSchemaFromProperty(ObjectNode json, String name, Property schema) {
        if (schema instanceof MapProperty || schema instanceof ObjectProperty) {
            try {
                String schemaString = Json.writer().writeValueAsString((Object)schema);
                return JsonSchemaHelper.parseJsonSchema(schemaString);
            }
            catch (JsonProcessingException e) {
                throw new IllegalStateException("Unable to serialize/read given JSON specification in response schema: " + schema, e);
            }
        }
        if (schema instanceof RefProperty || schema instanceof ArrayProperty) {
            String reference = JsonSchemaHelper.determineSchemaReference(schema);
            String title = UnifiedJsonDataShapeGenerator.determineTitleOf(name, schema);
            return JsonSchemaHelper.resolveSchemaForReference(json, title, reference);
        }
        return UnifiedJsonDataShapeGenerator.createPropertySchema(name, schema);
    }

    private static String determineTitleOf(String name, Model schema) {
        String title = schema.getTitle();
        if (title != null) {
            return title;
        }
        String description = schema.getDescription();
        if (description != null) {
            return description;
        }
        String reference = schema.getReference();
        if (reference != null) {
            return reference.replaceAll("^.*/", "");
        }
        return name;
    }

    private static String determineTitleOf(String name, Property schema) {
        String title = schema.getTitle();
        if (title != null) {
            return title;
        }
        String description = schema.getDescription();
        if (description != null) {
            return description;
        }
        String reference = JsonSchemaHelper.determineSchemaReference(schema);
        if (reference != null) {
            return reference.replaceAll("^.*/", "");
        }
        return name;
    }

    private static DataShape unifiedJsonSchema(String name, String description, ObjectNode bodySchema, ObjectNode parametersSchema) {
        if (bodySchema == null && parametersSchema == null) {
            return DATA_SHAPE_NONE;
        }
        ObjectNode unifiedSchema = JsonSchemaHelper.newJsonObjectSchema();
        unifiedSchema.put("$id", "io:syndesis:wrapped");
        ObjectNode properties = unifiedSchema.putObject("properties");
        if (parametersSchema != null) {
            properties.remove(PROPERTIES_TO_REMOVE_ON_MERGE);
            properties.set("parameters", parametersSchema.get("properties").get("parameters"));
        }
        if (bodySchema != null) {
            bodySchema.remove(PROPERTIES_TO_REMOVE_ON_MERGE);
            properties.set("body", (JsonNode)bodySchema);
        }
        return new DataShape.Builder().name(name).description(description).kind(DataShapeKinds.JSON_SCHEMA).specification(JsonSchemaHelper.serializeJson((JsonNode)unifiedSchema)).putMetadata("unified", "true").build();
    }
}

