/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.swagger;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.Xml;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.syndesis.common.model.DataShape;
import io.syndesis.common.model.DataShapeKinds;
import io.syndesis.server.api.generator.swagger.BaseDataShapeGenerator;
import io.syndesis.server.api.generator.swagger.util.SwaggerHelper;
import io.syndesis.server.api.generator.swagger.util.XmlSchemaHelper;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class UnifiedXmlDataShapeGenerator
extends BaseDataShapeGenerator {
    private static final Class<AbstractSerializableParameter<?>> PARAM_CLASS = AbstractSerializableParameter.class;
    private static final String SCHEMA_SET_NS = "http://atlasmap.io/xml/schemaset/v2";
    private static final String SYNDESIS_PARAMETERS_NS = "http://syndesis.io/v1/swagger-connector-template/parameters";
    private static final String SYNDESIS_REQUEST_NS = "http://syndesis.io/v1/swagger-connector-template/request";

    @Override
    public DataShape createShapeFromRequest(ObjectNode json, Swagger swagger, Operation operation) {
        Document document = DocumentHelper.createDocument();
        Element schemaSet = document.addElement("d:SchemaSet", SCHEMA_SET_NS);
        schemaSet.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        Element schema = XmlSchemaHelper.addElement(schemaSet, "schema");
        schema.addAttribute("targetNamespace", SYNDESIS_REQUEST_NS);
        schema.addAttribute("elementFormDefault", "qualified");
        Element parametersSchema = UnifiedXmlDataShapeGenerator.createParametersSchema(operation);
        HashMap<String, SchemaPrefixAndElement> moreSchemas = new HashMap<String, SchemaPrefixAndElement>();
        Element bodySchema = UnifiedXmlDataShapeGenerator.createRequestBodySchema(swagger, operation, moreSchemas);
        if (bodySchema == null && parametersSchema == null) {
            return DATA_SHAPE_NONE;
        }
        Element element = XmlSchemaHelper.addElement(schema, "element");
        element.addAttribute("name", "request");
        Element sequence = XmlSchemaHelper.addElement(element, "complexType", "sequence");
        Element additionalSchemas = schemaSet.addElement("d:AdditionalSchemas");
        if (parametersSchema != null) {
            Element parameters = XmlSchemaHelper.addElement(sequence, "element");
            parameters.addNamespace("p", SYNDESIS_PARAMETERS_NS);
            parameters.addAttribute("ref", "p:parameters");
            additionalSchemas.add(parametersSchema.detach());
        }
        if (bodySchema != null) {
            Element bodyElement = XmlSchemaHelper.addElement(sequence, "element");
            bodyElement.addAttribute("name", "body");
            Element body = XmlSchemaHelper.addElement(bodyElement, "complexType", "sequence", "element");
            String bodyTargetNamespace = bodySchema.attributeValue("targetNamespace");
            String bodyElementName = bodySchema.element("element").attributeValue("name");
            if (bodyTargetNamespace != null) {
                body.addNamespace("b", bodyTargetNamespace);
                body.addAttribute("ref", "b:" + bodyElementName);
            } else {
                body.addAttribute("ref", bodyElementName);
            }
            additionalSchemas.add(bodySchema.detach());
        }
        moreSchemas.values().forEach(e -> additionalSchemas.add(((SchemaPrefixAndElement)e).schema.detach()));
        String xmlSchemaSet = XmlSchemaHelper.serialize(document);
        return new DataShape.Builder().kind(DataShapeKinds.XML_SCHEMA).name("Request").description("API request payload").specification(xmlSchemaSet).putMetadata("unified", "true").build();
    }

    @Override
    public DataShape createShapeFromResponse(ObjectNode json, Swagger swagger, Operation operation) {
        Optional<Response> maybeResponse = UnifiedXmlDataShapeGenerator.findResponse(operation);
        if (!maybeResponse.isPresent()) {
            return DATA_SHAPE_NONE;
        }
        Document document = DocumentHelper.createDocument();
        Element schemaSet = document.addElement("d:SchemaSet", SCHEMA_SET_NS);
        schemaSet.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        HashMap<String, SchemaPrefixAndElement> moreSchemas = new HashMap<String, SchemaPrefixAndElement>();
        Element bodySchema = UnifiedXmlDataShapeGenerator.createResponseBodySchema(swagger, operation, moreSchemas);
        if (bodySchema == null) {
            return DATA_SHAPE_NONE;
        }
        schemaSet.add(bodySchema.detach());
        if (!moreSchemas.isEmpty()) {
            Element additionalSchemas = schemaSet.addElement("d:AdditionalSchemas");
            moreSchemas.values().forEach(e -> additionalSchemas.add(((SchemaPrefixAndElement)e).schema.detach()));
        }
        String xmlSchemaSet = XmlSchemaHelper.serialize(document);
        return new DataShape.Builder().name("Response").description("API response payload").kind(DataShapeKinds.XML_SCHEMA).specification(xmlSchemaSet).putMetadata("unified", "true").build();
    }

    static void defineArrayElement(Property property, String propertyName, Element parent, Swagger swagger, Map<String, SchemaPrefixAndElement> moreSchemas) {
        Element itemsElement;
        Element sequence;
        ArrayProperty array = (ArrayProperty)property;
        Xml arrayXml = array.getXml();
        if (arrayXml != null && Boolean.TRUE.equals(arrayXml.getWrapped())) {
            String arrayElementName = UnifiedXmlDataShapeGenerator.determineArrayElementName(propertyName, array);
            Element arrayElement = XmlSchemaHelper.addElement(parent, "element");
            arrayElement.addAttribute("name", Objects.requireNonNull(arrayElementName, "missing array property name"));
            Element arrayComplex = XmlSchemaHelper.addElement(arrayElement, "complexType");
            sequence = XmlSchemaHelper.addElement(arrayComplex, "sequence");
        } else {
            sequence = parent;
        }
        Property items = array.getItems();
        String arrayItemsType = items.getType();
        if ("ref".equals(arrayItemsType)) {
            itemsElement = UnifiedXmlDataShapeGenerator.defineComplexElement((RefProperty)items, sequence, swagger, moreSchemas);
        } else {
            itemsElement = XmlSchemaHelper.addElement(sequence, "element");
            itemsElement.addAttribute("name", UnifiedXmlDataShapeGenerator.determineArrayItemName(propertyName, array));
            itemsElement.addAttribute("type", XmlSchemaHelper.toXsdType(arrayItemsType));
        }
        if (array.getMaxItems() == null) {
            itemsElement.addAttribute("maxOccurs", "unbounded");
        } else {
            itemsElement.addAttribute("maxOccurs", String.valueOf(array.getMaxItems()));
        }
        if (array.getMinItems() == null) {
            itemsElement.addAttribute("minOccurs", "0");
        } else {
            itemsElement.addAttribute("minOccurs", String.valueOf(array.getMinItems()));
        }
    }

    static String determineArrayElementName(String propertyName, ArrayProperty array) {
        Xml xml = array.getXml();
        if (xml == null || xml.getWrapped() == null || Boolean.FALSE.equals(xml.getWrapped())) {
            return null;
        }
        String xmlName = xml.getName();
        if (xmlName != null) {
            return xmlName;
        }
        return propertyName;
    }

    static String determineArrayItemName(String propertyName, ArrayProperty array) {
        Property items = array.getItems();
        Xml itemXml = items.getXml();
        if (itemXml != null && itemXml.getName() != null) {
            return itemXml.getName();
        }
        Xml xml = array.getXml();
        if (xml != null && xml.getName() != null) {
            return xml.getName();
        }
        return propertyName;
    }

    private static void addEnumerationsTo(Element element, List<?> enums) {
        Element simpleType = XmlSchemaHelper.addElement(element, "simpleType");
        Element restriction = XmlSchemaHelper.addElement(simpleType, "restriction");
        restriction.addAttribute("base", element.attributeValue("type"));
        for (Object enumValue : enums) {
            Element enumeration = XmlSchemaHelper.addElement(restriction, "enumeration");
            enumeration.addAttribute("value", String.valueOf(enumValue));
        }
    }

    private static void addEnumsTo(Element element, AbstractSerializableParameter<?> serializableParameter) {
        if (serializableParameter.getItems() != null) {
            List enums;
            Property items = serializableParameter.getItems();
            try {
                List tmp;
                Method method = ClassUtils.getPublicMethod(items.getClass(), (String)"getEnum", (Class[])new Class[0]);
                enums = tmp = (List)method.invoke((Object)items, new Object[0]);
            }
            catch (ReflectiveOperationException ignored) {
                enums = Collections.emptyList();
            }
            if (enums != null && !enums.isEmpty()) {
                UnifiedXmlDataShapeGenerator.addEnumerationsTo(element, enums);
            }
        } else {
            List enums = serializableParameter.getEnum();
            if (enums != null && !enums.isEmpty()) {
                UnifiedXmlDataShapeGenerator.addEnumerationsTo(element, enums);
            }
        }
    }

    private static Element createParametersSchema(Operation operation) {
        List operationParameters = operation.getParameters();
        List serializableParameters = operationParameters.stream().filter(PARAM_CLASS::isInstance).map(PARAM_CLASS::cast).collect(Collectors.toList());
        if (serializableParameters.isEmpty()) {
            return null;
        }
        Element schema = XmlSchemaHelper.newXmlSchema(SYNDESIS_PARAMETERS_NS);
        Element parameters = XmlSchemaHelper.addElement(schema, "element");
        parameters.addAttribute("name", "parameters");
        Element complex = XmlSchemaHelper.addElement(parameters, "complexType");
        Element sequence = XmlSchemaHelper.addElement(complex, "sequence");
        for (AbstractSerializableParameter serializableParameter : serializableParameters) {
            Object defaultValue;
            String type = XmlSchemaHelper.toXsdType(serializableParameter.getType());
            String name = StringUtils.trimToNull((String)serializableParameter.getName());
            if ("file".equals(type)) continue;
            Element element = XmlSchemaHelper.addElement(sequence, "element");
            element.addAttribute("name", name);
            if (type != null) {
                element.addAttribute("type", type);
            }
            if ((defaultValue = serializableParameter.getDefault()) != null) {
                element.addAttribute("default", String.valueOf(defaultValue));
            }
            UnifiedXmlDataShapeGenerator.addEnumsTo(element, serializableParameter);
        }
        return schema;
    }

    private static Element createRequestBodySchema(Swagger swagger, Operation operation, Map<String, SchemaPrefixAndElement> moreSchemas) {
        ModelImpl bodySchemaToUse;
        Optional<BodyParameter> bodyParameter = UnifiedXmlDataShapeGenerator.findBodyParameter(operation);
        if (!bodyParameter.isPresent()) {
            return null;
        }
        BodyParameter body = bodyParameter.get();
        Model bodySchema = body.getSchema();
        if (bodySchema instanceof RefModel) {
            bodySchemaToUse = SwaggerHelper.dereference((RefModel)bodySchema, swagger);
        } else if (bodySchema instanceof ArrayModel) {
            Property items = ((ArrayModel)bodySchema).getItems();
            if (items instanceof RefProperty) {
                bodySchemaToUse = SwaggerHelper.dereference((RefProperty)items, swagger);
            } else {
                bodySchemaToUse = new ModelImpl();
                String name = XmlSchemaHelper.nameOrDefault(items, "array");
                bodySchemaToUse.name(name);
                bodySchemaToUse.addProperty(name, items);
            }
        } else {
            bodySchemaToUse = (ModelImpl)bodySchema;
        }
        String targetNamespace = XmlSchemaHelper.xmlTargetNamespaceOrNull(bodySchemaToUse);
        Element schema = XmlSchemaHelper.newXmlSchema(targetNamespace);
        Element bodyElement = XmlSchemaHelper.addElement(schema, "element");
        bodyElement.addAttribute("name", XmlSchemaHelper.nameOf(bodySchemaToUse));
        Element complexBody = XmlSchemaHelper.addElement(bodyElement, "complexType");
        Element bodySequence = XmlSchemaHelper.addElement(complexBody, "sequence");
        UnifiedXmlDataShapeGenerator.defineElementPropertiesOf(bodySequence, (Model)bodySchemaToUse, swagger, moreSchemas);
        UnifiedXmlDataShapeGenerator.defineAttributePropertiesOf(complexBody, bodySchemaToUse);
        return schema;
    }

    private static Element createResponseBodySchema(Swagger swagger, Operation operation, Map<String, SchemaPrefixAndElement> moreSchemas) {
        Optional<Response> maybeResponse = UnifiedXmlDataShapeGenerator.findResponse(operation);
        if (!maybeResponse.isPresent()) {
            return null;
        }
        Response body = maybeResponse.get();
        Property bodySchema = body.getSchema();
        if (bodySchema instanceof RefProperty) {
            return UnifiedXmlDataShapeGenerator.defineComplexElement((RefProperty)bodySchema, null, swagger, moreSchemas);
        }
        if (bodySchema instanceof ArrayProperty) {
            ArrayProperty array = (ArrayProperty)bodySchema;
            String targetNamespace = XmlSchemaHelper.xmlTargetNamespaceOrNull((Property)array);
            Element schema = XmlSchemaHelper.newXmlSchema(targetNamespace);
            UnifiedXmlDataShapeGenerator.defineElementProperty(Optional.ofNullable(array.getName()).orElse("array"), (Property)array, schema, swagger, moreSchemas);
            return schema;
        }
        throw new IllegalArgumentException("Unsupported response schema type: " + bodySchema);
    }

    private static void defineAttributePropertiesOf(Element parent, ModelImpl model) {
        Map properties = model.getProperties();
        for (Map.Entry propertyEntry : properties.entrySet()) {
            String propertyName = (String)propertyEntry.getKey();
            Property property = (Property)propertyEntry.getValue();
            if (!XmlSchemaHelper.isAttribute(property)) continue;
            UnifiedXmlDataShapeGenerator.defineAttributeProperty(propertyName, property, parent);
        }
    }

    private static void defineAttributeProperty(String propertyName, Property property, Element parent) {
        String type = property.getType();
        Element propertyElement = XmlSchemaHelper.addElement(parent, "attribute");
        propertyElement.addAttribute("name", Objects.requireNonNull(propertyName, "missing property name"));
        propertyElement.addAttribute("type", XmlSchemaHelper.toXsdType(type));
    }

    private static Element defineComplexElement(RefProperty property, Element parent, Swagger swagger, Map<String, SchemaPrefixAndElement> moreSchemas) {
        Element ret;
        Element elementToDeclareIn;
        ModelImpl model = SwaggerHelper.dereference(property, swagger);
        String namespace = XmlSchemaHelper.xmlTargetNamespaceOrNull(model);
        String name = XmlSchemaHelper.nameOf(model);
        if (namespace != null && parent != null) {
            SchemaPrefixAndElement schemaPrefixAndElement = moreSchemas.computeIfAbsent(namespace, n -> new SchemaPrefixAndElement("p" + moreSchemas.size(), XmlSchemaHelper.newXmlSchema(n)));
            elementToDeclareIn = XmlSchemaHelper.addElement(schemaPrefixAndElement.schema, "element");
            elementToDeclareIn.addAttribute("name", name);
            ret = XmlSchemaHelper.addElement(parent, "element");
            ret.addAttribute("ref", schemaPrefixAndElement.prefix + ":" + name);
            ret.addNamespace(schemaPrefixAndElement.prefix, namespace);
        } else if (parent == null) {
            ret = XmlSchemaHelper.newXmlSchema(namespace);
            elementToDeclareIn = XmlSchemaHelper.addElement(ret, "element");
            elementToDeclareIn.addAttribute("name", name);
        } else {
            ret = XmlSchemaHelper.addElement(parent, "element");
            ret.addAttribute("name", name);
            elementToDeclareIn = ret;
        }
        Element complex = XmlSchemaHelper.addElement(elementToDeclareIn, "complexType");
        Element sequence = XmlSchemaHelper.addElement(complex, "sequence");
        UnifiedXmlDataShapeGenerator.defineElementPropertiesOf(sequence, (Model)model, swagger, moreSchemas);
        UnifiedXmlDataShapeGenerator.defineAttributePropertiesOf(complex, model);
        return ret;
    }

    private static void defineElementPropertiesOf(Element parent, Model model, Swagger swagger, Map<String, SchemaPrefixAndElement> moreSchemas) {
        Map properties = model.getProperties();
        for (Map.Entry propertyEntry : properties.entrySet()) {
            String propertyName = (String)propertyEntry.getKey();
            Property property = (Property)propertyEntry.getValue();
            if (!XmlSchemaHelper.isElement(property)) continue;
            UnifiedXmlDataShapeGenerator.defineElementProperty(propertyName, property, parent, swagger, moreSchemas);
        }
    }

    private static void defineElementProperty(String propertyName, Property property, Element parent, Swagger swagger, Map<String, SchemaPrefixAndElement> moreSchemas) {
        String type;
        switch (type = property.getType()) {
            case "ref": {
                UnifiedXmlDataShapeGenerator.defineComplexElement((RefProperty)property, parent, swagger, moreSchemas);
                break;
            }
            case "array": {
                UnifiedXmlDataShapeGenerator.defineArrayElement(property, propertyName, parent, swagger, moreSchemas);
                break;
            }
            default: {
                Element propertyElement = XmlSchemaHelper.addElement(parent, "element");
                propertyElement.addAttribute("name", Objects.requireNonNull(propertyName, "missing property name"));
                propertyElement.addAttribute("type", XmlSchemaHelper.toXsdType(type));
            }
        }
    }

    static class SchemaPrefixAndElement {
        private final String prefix;
        private final Element schema;

        SchemaPrefixAndElement(String prefix, Element schema) {
            this.prefix = prefix;
            this.schema = schema;
        }
    }
}

