/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.swagger.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.load.configuration.LoadingConfiguration;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.google.common.base.Joiner;
import io.swagger.models.HttpMethod;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Swagger;
import io.swagger.models.properties.RefProperty;
import io.swagger.parser.util.RemoteUrl;
import io.swagger.parser.util.SwaggerDeserializationResult;
import io.syndesis.common.model.Violation;
import io.syndesis.common.util.Json;
import io.syndesis.common.util.Resources;
import io.syndesis.common.util.openapi.OpenApiHelper;
import io.syndesis.server.api.generator.APIValidationContext;
import io.syndesis.server.api.generator.swagger.SwaggerModelInfo;
import io.syndesis.server.api.generator.swagger.SyndesisSwaggerValidationRules;
import io.syndesis.server.api.generator.swagger.util.OperationDescription;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public final class SwaggerHelper {
    private static final String SWAGGER_IO_V2_SCHEMA_URI = "http://swagger.io/v2/schema.json#";
    private static final Logger LOG = LoggerFactory.getLogger(SwaggerHelper.class);
    private static final JsonSchema SWAGGER_2_0_SCHEMA;
    private static final String SWAGGER_2_0_SCHEMA_FILE = "schema/swagger-2.0-schema.json";
    private static final Yaml YAML_PARSER;
    private static final Pattern JSON_TEST;
    private static final Pattern JSONDB_DISALLOWED_KEY_CHARS;

    private SwaggerHelper() {
    }

    public static ModelImpl dereference(RefModel reference, Swagger swagger) {
        return (ModelImpl)swagger.getDefinitions().get(reference.getSimpleRef());
    }

    public static ModelImpl dereference(RefProperty property, Swagger swagger) {
        return (ModelImpl)swagger.getDefinitions().get(property.getSimpleRef());
    }

    public static String sanitizeTag(String tag) {
        if (StringUtils.isEmpty((CharSequence)tag)) {
            return null;
        }
        String sanitized = JSONDB_DISALLOWED_KEY_CHARS.matcher(tag).replaceAll("").trim();
        if (sanitized.length() > 768) {
            return sanitized.substring(0, Math.min(tag.length(), 768));
        }
        return sanitized;
    }

    public static Stream<String> sanitizeTags(List<String> list) {
        if (list == null || list.isEmpty()) {
            return Stream.empty();
        }
        return list.stream().map(SwaggerHelper::sanitizeTag).filter(Objects::nonNull).distinct();
    }

    public static String minimalSwaggerUsedByComponent(Swagger swagger) {
        ObjectNode json = (ObjectNode)Json.convertValue((Object)swagger, ObjectNode.class);
        json.remove(Arrays.asList("info", "tags", "definitions", "externalDocs"));
        json.remove("securityDefinitions");
        json.get("paths").forEach(path -> path.forEach(operation -> {
            ObjectNode operationNode = (ObjectNode)operation;
            operationNode.remove(Arrays.asList("tags", "summary", "description", "security"));
            ArrayNode parameters = (ArrayNode)operation.get("parameters");
            if (parameters != null) {
                ArrayList parametersList = new ArrayList(StreamSupport.stream(parameters.spliterator(), false).collect(Collectors.toList()));
                ListIterator i = parametersList.listIterator();
                while (i.hasNext()) {
                    ObjectNode param = (ObjectNode)i.next();
                    param.remove(Arrays.asList("description", "type", "required", "format"));
                    if ("path".equals(param.get("in").textValue()) || "query".equals(param.get("in").textValue())) continue;
                    i.remove();
                }
                if (parameters.size() == 0) {
                    operationNode.remove("parameters");
                }
                if (parametersList.isEmpty()) {
                    operationNode.remove("parameters");
                } else {
                    parameters.removeAll();
                    parameters.addAll(parametersList);
                }
            }
            operationNode.remove("responses");
        }));
        try {
            return Json.writer().writeValueAsString((Object)json);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Unable to serialize minified OpenAPI document", e);
        }
    }

    public static OperationDescription operationDescriptionOf(Swagger swagger, Operation operation, BiFunction<String, String, String> consumer) {
        Map.Entry pathEntry = swagger.getPaths().entrySet().stream().filter(e -> ((Path)e.getValue()).getOperations().contains(operation)).findFirst().get();
        String path = (String)pathEntry.getKey();
        Map.Entry operationEntry = ((Path)pathEntry.getValue()).getOperationMap().entrySet().stream().filter(e -> ((Operation)e.getValue()).equals((Object)operation)).findFirst().get();
        HttpMethod method = (HttpMethod)operationEntry.getKey();
        String specifiedSummary = StringUtils.trimToNull((String)operation.getSummary());
        String specifiedDescription = StringUtils.trimToNull((String)operation.getDescription());
        String name = Optional.ofNullable(SwaggerHelper.toLiteralNull(specifiedSummary)).orElseGet(() -> method + " " + path);
        String description = Optional.ofNullable(SwaggerHelper.toLiteralNull(specifiedDescription)).orElseGet(() -> (String)consumer.apply(method.name(), path));
        return new OperationDescription(name, description);
    }

    public static SwaggerModelInfo parse(String specification, APIValidationContext validationContext) {
        String resolvedSpecification;
        SwaggerModelInfo.Builder resultBuilder = new SwaggerModelInfo.Builder();
        try {
            resolvedSpecification = SwaggerHelper.resolve(specification);
            resultBuilder.resolvedSpecification(resolvedSpecification);
        }
        catch (Exception e) {
            LOG.debug("Unable to resolve OpenAPI document\n{}\n", (Object)specification, (Object)e);
            return resultBuilder.addError(new Violation.Builder().error("error").property("").message("Unable to resolve OpenAPI document from: " + Optional.ofNullable(specification).map(s -> StringUtils.abbreviate((String)s, (int)100)).orElse("")).build()).build();
        }
        SwaggerDeserializationResult parsed = OpenApiHelper.parseWithResult((String)resolvedSpecification);
        Swagger swagger = parsed.getSwagger();
        if (swagger == null) {
            LOG.debug("Unable to read OpenAPI document\n{}\n", (Object)specification);
            return resultBuilder.addError(new Violation.Builder().error("error").property("").message("Unable to read OpenAPI document from: '" + Optional.ofNullable(specification).map(s -> StringUtils.abbreviate((String)s, (int)100)).orElse("") + "': " + Joiner.on((char)',').join((Iterable)parsed.getMessages())).build()).build();
        }
        if (validationContext != APIValidationContext.NONE) {
            SwaggerModelInfo swaggerModelInfo = SwaggerHelper.validateJSonSchema(resolvedSpecification, swagger);
            return SyndesisSwaggerValidationRules.get(validationContext).apply(swaggerModelInfo);
        }
        return resultBuilder.model(swagger).build();
    }

    static JsonNode convertToJson(String specification) throws IOException, JsonProcessingException {
        JsonNode specRoot = JSON_TEST.matcher(specification).matches() ? Json.reader().readTree(specification) : (JsonNode)Json.convertValue((Object)YAML_PARSER.load(specification), JsonNode.class);
        return specRoot;
    }

    static String resolve(String specification) throws Exception {
        String specificationToUse = specification.toLowerCase(Locale.US).startsWith("http") ? RemoteUrl.urlToString((String)specification, null) : specification;
        JsonNode node = SwaggerHelper.convertToJson(specificationToUse);
        return Json.writer().writeValueAsString((Object)node);
    }

    private static boolean append(List<Violation> violations, ProcessingMessage message, Optional<String> requiredLevel) {
        Optional level;
        if (requiredLevel.isPresent() && !(level = Optional.ofNullable(message.asJson()).flatMap(node -> Optional.ofNullable(node.get("level"))).flatMap(node -> Optional.ofNullable(node.textValue()))).equals(requiredLevel)) {
            return false;
        }
        Optional property = Optional.ofNullable(message.asJson()).flatMap(node -> Optional.ofNullable(node.get("instance"))).flatMap(node -> Optional.ofNullable(node.get("pointer"))).flatMap(node -> Optional.ofNullable(node.textValue()));
        Optional error = Optional.ofNullable(message.asJson()).flatMap(node -> Optional.ofNullable(node.get("domain"))).flatMap(node -> Optional.ofNullable(node.textValue()));
        violations.add(new Violation.Builder().error(error.orElse("")).message(message.getMessage()).property(property.orElse("")).build());
        return true;
    }

    private static String toLiteralNull(String given) {
        if (given == null) {
            return null;
        }
        if ("null".equals(given)) {
            return null;
        }
        return given;
    }

    private static SwaggerModelInfo validateJSonSchema(String specification, Swagger model) {
        try {
            JsonNode specRoot = SwaggerHelper.convertToJson(specification);
            ProcessingReport report = SWAGGER_2_0_SCHEMA.validate(specRoot);
            ArrayList<Violation> errors = new ArrayList<Violation>();
            ArrayList<Violation> warnings = new ArrayList<Violation>();
            for (ProcessingMessage message : report) {
                boolean added = SwaggerHelper.append(errors, message, Optional.of("error"));
                if (added) continue;
                SwaggerHelper.append(warnings, message, Optional.empty());
            }
            return new SwaggerModelInfo.Builder().errors(errors).warnings(warnings).model(model).resolvedSpecification(specification).build();
        }
        catch (ProcessingException | IOException ex) {
            LOG.error("Unable to load the schema file embedded in the artifact", ex);
            return new SwaggerModelInfo.Builder().addError(new Violation.Builder().error("error").property("").message("Unable to load the OpenAPI schema file embedded in the artifact").build()).build();
        }
    }

    static {
        YAML_PARSER = new Yaml();
        JSON_TEST = Pattern.compile("^\\s*\\{.*");
        JSONDB_DISALLOWED_KEY_CHARS = Pattern.compile("[^ -\"&-\\-0-Z\\^-~\u0080-\u10ffFF]");
        try {
            JsonNode swagger20Schema = Json.reader().readTree(Resources.getResourceAsText((String)SWAGGER_2_0_SCHEMA_FILE));
            LoadingConfiguration loadingConfiguration = LoadingConfiguration.newBuilder().preloadSchema(SWAGGER_IO_V2_SCHEMA_URI, swagger20Schema).freeze();
            SWAGGER_2_0_SCHEMA = JsonSchemaFactory.newBuilder().setLoadingConfiguration(loadingConfiguration).freeze().getJsonSchema(SWAGGER_IO_V2_SCHEMA_URI);
        }
        catch (ProcessingException | IOException ex) {
            throw new IllegalStateException("Unable to load the schema file embedded in the artifact", ex);
        }
    }
}

