/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.swagger.util;

import io.swagger.models.ModelImpl;
import io.swagger.models.Xml;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public final class XmlSchemaHelper {
    public static final String XML_SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    public static final String XML_SCHEMA_PREFIX = "xsd";

    private XmlSchemaHelper() {
    }

    public static Element addElement(Element parent, String name) {
        return parent.addElement("xsd:" + name, XML_SCHEMA_NS);
    }

    public static Element addElement(Element parent, String ... names) {
        Element current = parent;
        for (String name : names) {
            current = current.addElement("xsd:" + name, XML_SCHEMA_NS);
        }
        return current;
    }

    public static boolean isAttribute(Property property) {
        Xml xml = property.getXml();
        if (xml == null) {
            return false;
        }
        Boolean attribute = xml.getAttribute();
        return Boolean.TRUE.equals(attribute);
    }

    public static boolean isElement(Property property) {
        Xml xml = property.getXml();
        if (xml == null) {
            return true;
        }
        Boolean attribute = xml.getAttribute();
        return attribute == null || Boolean.FALSE.equals(attribute);
    }

    public static String nameOf(ModelImpl model) {
        return XmlSchemaHelper.xmlNameOrDefault(model.getXml(), model.getName());
    }

    public static String nameOf(Property property) {
        if (property instanceof RefProperty) {
            throw new IllegalArgumentException("Make sure that you dereference property, given: " + property);
        }
        return XmlSchemaHelper.xmlNameOrDefault(property.getXml(), property.getName());
    }

    public static String nameOrDefault(Property property, String name) {
        String determined = XmlSchemaHelper.nameOf(property);
        if (determined == null) {
            return name;
        }
        return determined;
    }

    public static Element newXmlSchema(String targetNamespace) {
        Document document = DocumentHelper.createDocument();
        Element schema = document.addElement("xsd:schema", XML_SCHEMA_NS);
        if (!StringUtils.isEmpty((CharSequence)targetNamespace)) {
            schema.addAttribute("targetNamespace", targetNamespace);
        }
        return schema;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String serialize(Document document) {
        try (StringWriter out = new StringWriter();){
            OutputFormat format = new OutputFormat(null, false, "UTF-8");
            format.setExpandEmptyElements(false);
            format.setIndent(false);
            XMLWriter writer = new XMLWriter((Writer)out, format);
            writer.write(document);
            writer.flush();
            String string = out.toString();
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to serialize given document to XML", e);
        }
    }

    public static String toXsdType(String type) {
        switch (type) {
            case "boolean": {
                return "xsd:boolean";
            }
            case "number": {
                return "xsd:decimal";
            }
            case "string": {
                return "xsd:string";
            }
            case "integer": {
                return "xsd:integer";
            }
        }
        throw new IllegalArgumentException("Unexpected type `" + type + "` given to convert to XSD type");
    }

    public static boolean xmlIsWrapped(ArrayProperty array) {
        if (array == null || array.getXml() == null) {
            return false;
        }
        return Boolean.TRUE.equals(array.getXml().getWrapped());
    }

    public static String xmlNameOrDefault(Xml xml, String defaultName) {
        if (xml == null || xml.getName() == null) {
            return defaultName;
        }
        return xml.getName();
    }

    public static String xmlTargetNamespaceOrNull(ModelImpl model) {
        if (model == null || model.getXml() == null) {
            return null;
        }
        return model.getXml().getNamespace();
    }

    public static String xmlTargetNamespaceOrNull(Property property) {
        if (property == null || property.getXml() == null) {
            return null;
        }
        return property.getXml().getNamespace();
    }
}

