/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.util;

import io.syndesis.common.model.action.ConnectorAction;
import java.util.Comparator;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class ActionComparator
implements Comparator<ConnectorAction> {
    public static final Comparator<ConnectorAction> INSTANCE = new ActionComparator();
    private static final Comparator<String> BASE_COMPARATOR = Comparator.nullsLast(String::compareTo);

    private ActionComparator() {
    }

    @Override
    public int compare(ConnectorAction left, ConnectorAction right) {
        String rightTags;
        String leftTags = ActionComparator.allTags(left);
        int base = BASE_COMPARATOR.compare(leftTags, rightTags = ActionComparator.allTags(right));
        if (base != 0) {
            return base;
        }
        String leftName = ActionComparator.name(left);
        String rightName = ActionComparator.name(right);
        return BASE_COMPARATOR.compare(leftName, rightName);
    }

    private static String allTags(ConnectorAction left) {
        return StringUtils.trimToNull((String)left.getTags().stream().collect(Collectors.joining()));
    }

    private static String name(ConnectorAction action) {
        return StringUtils.trimToNull((String)action.getName());
    }
}

