/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.util;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import com.github.mustachejava.MustacheNotFoundException;
import com.google.common.escape.Escaper;
import com.google.common.io.CharStreams;
import com.google.common.net.PercentEscaper;
import io.syndesis.common.util.SyndesisServerException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IconGenerator {
    private static final String[] COLORS = new String[]{"#cc0000", "#a30000", "#8b0000", "#470000", "#2c0000", "#ec7a08", "#b35c00", "#773d00", "#3b1f00", "#b58100", "#795600", "#3d2c00", "#6ca100", "#486b00", "#253600", "#3f9c35", "#2d7623", "#1e4f18", "#0f280d", "#007a87", "#005c66", "#003d44", "#001f22", "#00b9e4", "#008bad", "#005c73", "#002d39", "#8461f7", "#703fec", "#582fc0", "#40199a", "#1f0066"};
    private static final Escaper ESCAPER = new PercentEscaper("", false);
    private static final Map<Character, String> LETTERS = IconGenerator.loadLetters();
    private static final Logger LOG = LoggerFactory.getLogger(IconGenerator.class);
    private static final MustacheFactory MUSTACHE_FACTORY = new DefaultMustacheFactory(resourceName -> {
        InputStream resourceStream = IconGenerator.class.getResourceAsStream(resourceName);
        if (resourceStream == null) {
            return null;
        }
        return new InputStreamReader(resourceStream, StandardCharsets.UTF_8);
    });

    private IconGenerator() {
    }

    public static String generate(String template, String name) {
        String string;
        Mustache mustache;
        try {
            mustache = MUSTACHE_FACTORY.compile("/icon-generator/" + template + ".svg.mustache");
        }
        catch (MustacheNotFoundException e) {
            LOG.warn("Unable to load icon template for: `{}`, will use default template", (Object)template);
            LOG.debug("Unable to load icon template for: {}", (Object)template, (Object)e);
            mustache = MUSTACHE_FACTORY.compile("/icon-generator/default.svg.mustache");
        }
        HashMap<String, String> data = new HashMap<String, String>();
        String color = COLORS[(int)(Math.random() * (double)COLORS.length)];
        data.put("color", color);
        data.put("letter", LETTERS.get(Character.valueOf(Character.toUpperCase(name.charAt(0)))));
        StringWriter icon = new StringWriter();
        Throwable throwable = null;
        try {
            mustache.execute((Writer)icon, data).flush();
            String trimmed = IconGenerator.trimXml(icon.toString());
            string = "data:image/svg+xml," + ESCAPER.escape(trimmed);
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    IconGenerator.$closeResource(throwable, icon);
                    throw throwable3;
                }
            }
            catch (IOException e) {
                throw new SyndesisServerException("Unable to generate icon from template `" + template + "`, for name: " + name, (Throwable)e);
            }
        }
        IconGenerator.$closeResource(throwable, icon);
        return string;
    }

    static String trimXml(String xml) {
        return xml.trim().replaceAll(">\\s*<", "><").replaceAll("\\s\\s+", " ").replaceAll(" />", "/>");
    }

    private static Map<Character, String> loadLetters() {
        HashMap<Character, String> letters = new HashMap<Character, String>();
        for (char ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
            try (InputStream letterStream = IconGenerator.class.getResourceAsStream("/icon-generator/" + ch + ".svg");
                 InputStreamReader letterReader = new InputStreamReader(letterStream, StandardCharsets.UTF_8);){
                String path = CharStreams.toString((Readable)letterReader);
                letters.put(Character.valueOf(ch), path);
                continue;
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to load SVG path for letter: " + ch, e);
            }
        }
        return Collections.unmodifiableMap(letters);
    }
}

