/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator;

import io.syndesis.common.model.api.APISummary;
import io.syndesis.common.model.connection.ConfigurationProperty;
import io.syndesis.common.model.connection.Connector;
import io.syndesis.common.model.connection.ConnectorGroup;
import io.syndesis.common.model.connection.ConnectorSettings;
import io.syndesis.common.model.connection.ConnectorTemplate;
import io.syndesis.server.api.generator.ConnectorGenerator;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ConnectorGeneratorTest {
    private final ConnectorGenerator generator = new ConnectorGenerator(new Connector.Builder().addTags(new String[]{"from-connector"}).build()){

        public Connector generate(ConnectorTemplate connectorTemplate, ConnectorSettings connectorSettings) {
            return null;
        }

        public APISummary info(ConnectorTemplate connectorTemplate, ConnectorSettings connectorSettings) {
            return null;
        }

        protected String determineConnectorDescription(ConnectorTemplate connectorTemplate, ConnectorSettings connectorSettings) {
            return "test-description";
        }

        protected String determineConnectorName(ConnectorTemplate connectorTemplate, ConnectorSettings connectorSettings) {
            return "test-name";
        }
    };
    private final ConnectorTemplate template = new ConnectorTemplate.Builder().id("template-id").connectorGroup(new ConnectorGroup.Builder().id("template-group").build()).putProperty("property1", new ConfigurationProperty.Builder().build()).putProperty("property2", new ConfigurationProperty.Builder().build()).build();

    @Test
    public void shouldCreateBaseConnectors() {
        ConnectorSettings settings = new ConnectorSettings.Builder().putConfiguredProperty("property2", "value2").build();
        Connector connector = this.generator.baseConnectorFrom(this.template, settings);
        Assertions.assertThat((Object)connector).isEqualToIgnoringGivenFields((Object)new Connector.Builder().name("test-name").description("test-description").addTags(new String[]{"from-connector"}).connectorGroup(this.template.getConnectorGroup()).connectorGroupId("template-group").properties(this.template.getConnectorProperties()).putConfiguredProperty("property2", "value2").build(), new String[]{"id", "icon"});
        Assertions.assertThat((String)connector.getIcon()).isEqualTo((Object)"data:image/svg+xml,dummy");
    }

    @Test
    public void shouldCreateBaseConnectorsWithGivenNameAndDescription() {
        ConnectorSettings settings = new ConnectorSettings.Builder().name("given-name").description("given-description").putConfiguredProperty("property2", "value2").build();
        Connector connector = this.generator.baseConnectorFrom(this.template, settings);
        Assertions.assertThat((Object)connector).isEqualToIgnoringGivenFields((Object)new Connector.Builder().name("given-name").description("given-description").addTags(new String[]{"from-connector"}).connectorGroup(this.template.getConnectorGroup()).connectorGroupId("template-group").properties(this.template.getConnectorProperties()).putConfiguredProperty("property2", "value2").build(), new String[]{"id", "icon"});
        Assertions.assertThat((String)connector.getIcon()).isEqualTo((Object)"data:image/svg+xml,dummy");
    }
}

