/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.swagger;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.models.Info;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.Parameter;
import io.syndesis.common.model.Dependency;
import io.syndesis.common.model.action.ActionsSummary;
import io.syndesis.common.model.action.ConnectorAction;
import io.syndesis.common.model.action.ConnectorDescriptor;
import io.syndesis.common.model.api.APISummary;
import io.syndesis.common.model.connection.ConfigurationProperty;
import io.syndesis.common.model.connection.Connector;
import io.syndesis.common.model.connection.ConnectorSettings;
import io.syndesis.common.util.Json;
import io.syndesis.common.util.openapi.OpenApiHelper;
import io.syndesis.server.api.generator.APIValidationContext;
import io.syndesis.server.api.generator.swagger.AbstractSwaggerConnectorTest;
import io.syndesis.server.api.generator.swagger.BaseSwaggerConnectorGenerator;
import io.syndesis.server.api.generator.swagger.SwaggerModelInfo;
import io.syndesis.server.api.generator.swagger.SwaggerUnifiedShapeGeneratorExampleTests;
import io.syndesis.server.api.generator.swagger.TestHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.json.JSONException;
import org.junit.Test;
import org.skyscreamer.jsonassert.JSONAssert;
import org.skyscreamer.jsonassert.JSONCompareMode;

public class BaseSwaggerConnectorGeneratorTest
extends AbstractSwaggerConnectorTest {
    private final BaseSwaggerConnectorGenerator generator;

    public BaseSwaggerConnectorGeneratorTest() {
        try (InputStream stream = SwaggerUnifiedShapeGeneratorExampleTests.class.getResourceAsStream("/META-INF/syndesis/connector/rest-swagger.json");){
            Connector restSwagger = (Connector)Json.readFromStream((InputStream)stream, Connector.class);
            this.generator = new BaseSwaggerConnectorGenerator(restSwagger){

                ConnectorDescriptor.Builder createDescriptor(ObjectNode json, Swagger swagger, Operation operation) {
                    return new ConnectorDescriptor.Builder();
                }
            };
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Test
    public void includesRestSwaggerConnectorCustomizers() throws IOException {
        ConnectorSettings connectorSettings = BaseSwaggerConnectorGeneratorTest.createReverbSettings();
        Connector connector = this.generator.generate(SWAGGER_TEMPLATE, connectorSettings);
        Assertions.assertThat((List)connector.getConnectorCustomizers()).isNotEmpty();
        Assertions.assertThat((List)connector.getConnectorCustomizers()).contains((Object[])new String[]{"io.syndesis.connector.rest.swagger.SpecificationResourceCustomizer", "io.syndesis.connector.rest.swagger.AuthenticationCustomizer", "io.syndesis.connector.rest.swagger.RequestCustomizer", "io.syndesis.connector.rest.swagger.ResponseCustomizer"});
    }

    @Test
    public void includesRestSwaggerConnectorDependency() throws IOException {
        ConnectorSettings connectorSettings = BaseSwaggerConnectorGeneratorTest.createReverbSettings();
        Connector connector = this.generator.generate(SWAGGER_TEMPLATE, connectorSettings);
        Assertions.assertThat((List)connector.getDependencies()).isNotEmpty();
        Assertions.assertThat((List)connector.getDependencies()).anyMatch(d -> d.getType() == Dependency.Type.MAVEN && d.getId().startsWith("io.syndesis.connector:connector-rest-swagger"));
    }

    @Test
    public void includesRestSwaggerConnectorFactory() throws IOException {
        ConnectorSettings connectorSettings = BaseSwaggerConnectorGeneratorTest.createReverbSettings();
        Connector connector = this.generator.generate(SWAGGER_TEMPLATE, connectorSettings);
        Assertions.assertThat((Optional)connector.getConnectorFactory()).isPresent();
        Assertions.assertThat((Optional)connector.getConnectorFactory()).hasValue((Object)"io.syndesis.connector.rest.swagger.ConnectorFactory");
    }

    @Test
    public void shouldCreatePropertyParametersFromPetstoreSwagger() throws IOException {
        String specification = TestHelper.resource("/swagger/petstore.swagger.json");
        Swagger swagger = OpenApiHelper.parse((String)specification);
        Parameter petIdPathParameter = (Parameter)swagger.getPath("/pet/{petId}").getGet().getParameters().get(0);
        Optional maybeConfigurationProperty = BaseSwaggerConnectorGenerator.createPropertyFromParameter((Parameter)petIdPathParameter);
        ConfigurationProperty expected = new ConfigurationProperty.Builder().componentProperty(Boolean.valueOf(false)).deprecated(Boolean.valueOf(false)).description("ID of pet to return").displayName("petId").group("producer").javaType(Long.class.getName()).kind("property").required(Boolean.valueOf(true)).secret(Boolean.valueOf(false)).type("integer").build();
        Assertions.assertThat((Optional)maybeConfigurationProperty).hasValue((Object)expected);
    }

    @Test
    public void shouldCreateSecurityConfigurationFromConcurSwagger() throws IOException {
        String specification = TestHelper.resource("/swagger/concur.swagger.json");
        ConnectorSettings connectorSettings = new ConnectorSettings.Builder().name("Concur List API").description("Invokes Concur List API").icon("fa-globe").putConfiguredProperty("specification", specification).build();
        Connector generated = this.generator.generate(SWAGGER_TEMPLATE, connectorSettings);
        Assertions.assertThat(generated.getProperties().keySet()).contains((Object[])new String[]{"accessToken", "authorizationEndpoint", "tokenEndpoint", "clientId", "clientSecret", "tokenStrategy", "authorizeUsingParameters"});
        Assertions.assertThat((String)((ConfigurationProperty)generated.getProperties().get("tokenStrategy")).getDefaultValue()).isEqualTo((Object)"AUTHORIZATION_HEADER");
        Assertions.assertThat((String)((ConfigurationProperty)generated.getProperties().get("authorizeUsingParameters")).getDefaultValue()).isEqualTo((Object)"true");
    }

    @Test
    public void shouldCreateSecurityConfigurationFromReverbSwagger() throws IOException {
        String specification = TestHelper.resource("/swagger/reverb.swagger.yaml");
        ConnectorSettings connectorSettings = new ConnectorSettings.Builder().name("Reverb API").description("Invokes Reverb API").icon("fa-music").putConfiguredProperty("specification", specification).build();
        Connector generated = this.generator.generate(SWAGGER_TEMPLATE, connectorSettings);
        Assertions.assertThat(generated.getProperties().keySet()).contains((Object[])new String[]{"accessToken", "authorizationEndpoint", "tokenEndpoint", "clientId", "clientSecret"});
        Assertions.assertThat((List)((ConfigurationProperty)generated.getProperties().get("authenticationType")).getEnum()).containsExactly((Object[])new ConfigurationProperty.PropertyValue[]{new ConfigurationProperty.PropertyValue.Builder().value("oauth2:oauth2").label("OAuth 2.0 - oauth2").build()});
    }

    @Test
    public void shouldDetermineConnectorDescription() {
        Swagger swagger = new Swagger();
        Assertions.assertThat((String)this.generator.determineConnectorDescription(SWAGGER_TEMPLATE, BaseSwaggerConnectorGeneratorTest.createSettingsFrom(swagger))).isEqualTo((Object)"unspecified");
        Info info = new Info();
        swagger.info(info);
        Assertions.assertThat((String)this.generator.determineConnectorDescription(SWAGGER_TEMPLATE, BaseSwaggerConnectorGeneratorTest.createSettingsFrom(swagger))).isEqualTo((Object)"unspecified");
        info.description("description");
        Assertions.assertThat((String)this.generator.determineConnectorDescription(SWAGGER_TEMPLATE, BaseSwaggerConnectorGeneratorTest.createSettingsFrom(swagger))).isEqualTo((Object)"description");
    }

    @Test
    public void shouldDetermineConnectorName() {
        Swagger swagger = new Swagger();
        Assertions.assertThat((String)this.generator.determineConnectorName(SWAGGER_TEMPLATE, BaseSwaggerConnectorGeneratorTest.createSettingsFrom(swagger))).isEqualTo((Object)"unspecified");
        Info info = new Info();
        swagger.info(info);
        Assertions.assertThat((String)this.generator.determineConnectorName(SWAGGER_TEMPLATE, BaseSwaggerConnectorGeneratorTest.createSettingsFrom(swagger))).isEqualTo((Object)"unspecified");
        info.title("title");
        Assertions.assertThat((String)this.generator.determineConnectorName(SWAGGER_TEMPLATE, BaseSwaggerConnectorGeneratorTest.createSettingsFrom(swagger))).isEqualTo((Object)"title");
    }

    @Test
    public void shouldIncorporateGivenConfiguredProperties() throws IOException {
        String specification = TestHelper.resource("/swagger/reverb.swagger.yaml");
        ConnectorSettings connectorSettings = new ConnectorSettings.Builder().name("Reverb API").description("Invokes Reverb API").icon("fa-music").putConfiguredProperty("specification", specification).putConfiguredProperty("tokenEndpoint", "http://some.token.url").build();
        Connector connector = this.generator.generate(SWAGGER_TEMPLATE, connectorSettings);
        Assertions.assertThat((Map)connector.getConfiguredProperties()).containsEntry((Object)"tokenEndpoint", (Object)"http://some.token.url");
    }

    @Test
    public void shouldMakeNonUniqueOperationIdsUnique() {
        Swagger swagger = new Swagger().path("/path", new Path().get(new Operation().operationId("foo")).post(new Operation().operationId("foo")).put(new Operation().operationId("bar")));
        Connector generated = this.generator.configureConnector(SWAGGER_TEMPLATE, new Connector.Builder().id("connector1").build(), BaseSwaggerConnectorGeneratorTest.createSettingsFrom(swagger));
        List actions = generated.getActions();
        Assertions.assertThat((List)actions).hasSize(3);
        Assertions.assertThat((Optional)((ConnectorAction)actions.get(0)).getId()).hasValueSatisfying(id -> {
            AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)Assertions.assertThat((String)id).endsWith((CharSequence)"foo");
        });
        Assertions.assertThat((Optional)((ConnectorAction)actions.get(1)).getId()).hasValueSatisfying(id -> {
            AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)Assertions.assertThat((String)id).endsWith((CharSequence)"foo1");
        });
        Assertions.assertThat((Optional)((ConnectorAction)actions.get(2)).getId()).hasValueSatisfying(id -> {
            AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)Assertions.assertThat((String)id).endsWith((CharSequence)"bar");
        });
    }

    @Test
    public void shouldNotFailOnEmptySwagger() {
        ConnectorSettings connectorSettings = new ConnectorSettings.Builder().putConfiguredProperty("specification", "{}").build();
        APISummary summary = this.generator.info(SWAGGER_TEMPLATE, connectorSettings);
        Assertions.assertThat((Object)summary).isNotNull();
    }

    @Test
    public void shouldNotFailOnTrivialyEmptyOperations() {
        ConnectorSettings connectorSettings = new ConnectorSettings.Builder().putConfiguredProperty("specification", "{\"swagger\": \"2.0\",\"info\": {\"version\": \"0.0.0\",\"title\": \"title\",\"description\": \"description\"},\"paths\": {\"/operation\": {\"get\": {\"responses\": {\"200\": {\"description\": \"OK\"}}}}}}").build();
        APISummary summary = this.generator.info(SWAGGER_TEMPLATE, connectorSettings);
        Assertions.assertThat((Object)summary).isNotNull();
    }

    @Test
    public void shouldParseSpecificationWithSecurityRequirements() throws JSONException {
        SwaggerModelInfo info = BaseSwaggerConnectorGenerator.parseSpecification((ConnectorSettings)new ConnectorSettings.Builder().putConfiguredProperty("specification", "{\"swagger\":\"2.0\",\"paths\":{\"/api\":{\"get\":{\"security\":[{\"secured\":[]}]}}}}").build(), (APIValidationContext)APIValidationContext.CONSUMED_API);
        Swagger model = info.getModel();
        Assertions.assertThat((List)model.getPath("/api").getGet().getSecurity()).containsOnly((Object[])new Map[]{Collections.singletonMap("secured", Collections.emptyList())});
        String resolvedSpecification = info.getResolvedSpecification();
        JSONAssert.assertEquals((String)"{\"swagger\":\"2.0\",\"paths\":{\"/api\":{\"get\":{\"security\":[{\"secured\":[]}]}}}}", (String)resolvedSpecification, (JSONCompareMode)JSONCompareMode.STRICT);
        ObjectNode resolvedJsonGraph = info.getResolvedJsonGraph();
        JsonNode securityRequirement = resolvedJsonGraph.get("paths").get("/api").get("get").get("security");
        Assertions.assertThat((Iterable)securityRequirement).hasSize(1);
        Assertions.assertThat((Iterable)securityRequirement.get(0).get("secured")).isEmpty();
    }

    @Test
    public void shouldProvideInfoFromPetstoreSwagger() throws IOException {
        String specification = TestHelper.resource("/swagger/petstore.swagger.json");
        ConnectorSettings connectorSettings = new ConnectorSettings.Builder().putConfiguredProperty("specification", specification).build();
        APISummary summary = this.generator.info(SWAGGER_TEMPLATE, connectorSettings);
        ActionsSummary actionsSummary = new ActionsSummary.Builder().totalActions(20).putActionCountByTag("store", 4).putActionCountByTag("user", 8).putActionCountByTag("pet", 8).build();
        APISummary expected = new APISummary.Builder().name("Swagger Petstore").actionsSummary(actionsSummary).build();
        Assertions.assertThat((Object)summary).isEqualToIgnoringGivenFields((Object)expected, new String[]{"icon", "description", "properties", "warnings", "configuredProperties"});
        Assertions.assertThat((Optional)summary.getIcon()).matches(s -> s.isPresent() && ((String)s.get()).startsWith("data:image"));
        Assertions.assertThat((String)summary.getDescription()).startsWith((CharSequence)"This is a sample server Petstore server");
        Assertions.assertThat(summary.getProperties().keySet()).contains((Object[])new String[]{"host", "basePath", "authenticationType", "specification"});
        Assertions.assertThat(summary.getConfiguredProperties().keySet()).containsOnly((Object[])new String[]{"specification"});
        Assertions.assertThat((String)TestHelper.reformatJson((String)summary.getConfiguredProperties().get("specification"))).isEqualTo((Object)TestHelper.reformatJson(specification));
    }

    @Test
    public void shouldReportErrorsFromInvalidPetstoreSwagger() throws IOException {
        String specification = TestHelper.resource("/swagger/invalid/invalid-scheme.petstore.swagger.json");
        ConnectorSettings connectorSettings = new ConnectorSettings.Builder().putConfiguredProperty("specification", specification).build();
        APISummary summary = this.generator.info(SWAGGER_TEMPLATE, connectorSettings);
        Assertions.assertThat((List)summary.getErrors()).hasSize(1);
        Assertions.assertThat((List)summary.getWarnings()).hasSize(1);
    }

    private static ConnectorSettings createReverbSettings() throws IOException {
        return new ConnectorSettings.Builder().name("Reverb API").description("Invokes Reverb API").icon("fa-music").putConfiguredProperty("specification", TestHelper.resource("/swagger/reverb.swagger.yaml")).build();
    }

    private static ConnectorSettings createSettingsFrom(Swagger swagger) {
        return new ConnectorSettings.Builder().putConfiguredProperty("specification", OpenApiHelper.serialize((Swagger)swagger)).build();
    }
}

