/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.swagger;

import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.RefParameter;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.syndesis.common.util.Resources;
import io.syndesis.common.util.openapi.OpenApiHelper;
import io.syndesis.server.api.generator.swagger.CyclicValidationCheck;
import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class CyclicValidationCheckTest {
    @Test
    public void shouldFindCyclicReferenceInOpenHabSwagger() throws IOException {
        Swagger swagger = OpenApiHelper.parse((String)Resources.getResourceAsText((String)"swagger/openhab.swagger.json"));
        Assertions.assertThat((boolean)CyclicValidationCheck.hasCyclicReferences((Swagger)swagger)).isTrue();
    }

    @Test
    public void shouldFindCyclicSelfReferencesInParameters() {
        Swagger swagger = new Swagger().path("/api", new Path().post(new Operation().parameter((Parameter)new RefParameter("#/definitions/A"))));
        swagger.addDefinition("A", (Model)new ModelImpl().type("object").property("cyclic", (Property)new RefProperty("#/definitions/A")));
        Assertions.assertThat((boolean)CyclicValidationCheck.hasCyclicReferences((Swagger)swagger)).isTrue();
    }

    @Test
    public void shouldFindCyclicSelfReferencesInResponses() {
        Swagger swagger = new Swagger().path("/api", new Path().post(new Operation().response(200, new Response().responseSchema((Model)new RefModel("#/definitions/A")))));
        swagger.addDefinition("A", (Model)new ModelImpl().type("object").property("cyclic", (Property)new RefProperty("#/definitions/A")));
        Assertions.assertThat((boolean)CyclicValidationCheck.hasCyclicReferences((Swagger)swagger)).isTrue();
    }

    @Test
    public void shouldFindMultipleStepCyclicReferencesInParameters() {
        Swagger swagger = new Swagger().path("/api", new Path().post(new Operation().parameter((Parameter)new RefParameter("#/definitions/A"))));
        for (int c = 65; c < 90; ++c) {
            String current = String.valueOf((char)c);
            String next = String.valueOf((char)(c + 1));
            swagger.addDefinition(current, (Model)new ModelImpl().type("object").property(next, (Property)new RefProperty("#/definitions/" + next)));
        }
        swagger.addDefinition("Z", (Model)new ModelImpl().type("object").property("a", (Property)new RefProperty("#/definitions/A")));
        Assertions.assertThat((boolean)CyclicValidationCheck.hasCyclicReferences((Swagger)swagger)).isTrue();
    }

    @Test
    public void shouldFindMultipleStepCyclicReferencesInResponses() {
        Swagger swagger = new Swagger().path("/api", new Path().post(new Operation().response(200, new Response().responseSchema((Model)new RefModel("#/definitions/A")))));
        for (int c = 65; c < 90; ++c) {
            String current = String.valueOf((char)c);
            String next = String.valueOf((char)(c + 1));
            swagger.addDefinition(current, (Model)new ModelImpl().type("object").property(next, (Property)new RefProperty("#/definitions/" + next)));
        }
        swagger.addDefinition("Z", (Model)new ModelImpl().type("object").property("a", (Property)new RefProperty("#/definitions/A")));
        Assertions.assertThat((boolean)CyclicValidationCheck.hasCyclicReferences((Swagger)swagger)).isTrue();
    }

    @Test
    public void shouldFindNoCyclicReferencesWhenThereAreNone() {
        Swagger swagger = new Swagger().path("/api", new Path().post(new Operation().parameter((Parameter)new RefParameter("#/definitions/Request")).response(200, new Response().responseSchema((Model)new RefModel("#/definitions/Response")))));
        swagger.addDefinition("Request", (Model)new ModelImpl().type("object").property("reqval", (Property)new IntegerProperty()));
        swagger.addDefinition("Response", (Model)new ModelImpl().type("object").property("reqval", (Property)new IntegerProperty()));
        Assertions.assertThat((boolean)CyclicValidationCheck.hasCyclicReferences((Swagger)swagger)).isFalse();
    }

    @Test
    public void shouldFindThreeStepCyclicReferencesInParameters() {
        Swagger swagger = new Swagger().path("/api", new Path().post(new Operation().parameter((Parameter)new RefParameter("#/definitions/A"))));
        swagger.addDefinition("A", (Model)new ModelImpl().type("object").property("b", (Property)new RefProperty("#/definitions/B")));
        swagger.addDefinition("B", (Model)new ModelImpl().type("object").property("c", (Property)new RefProperty("#/definitions/C")));
        swagger.addDefinition("C", (Model)new ModelImpl().type("object").property("a", (Property)new RefProperty("#/definitions/A")));
        Assertions.assertThat((boolean)CyclicValidationCheck.hasCyclicReferences((Swagger)swagger)).isTrue();
    }

    @Test
    public void shouldFindTwoStepCyclicReferencesInParameters() {
        Swagger swagger = new Swagger().path("/api", new Path().post(new Operation().parameter((Parameter)new RefParameter("#/definitions/A"))));
        swagger.addDefinition("A", (Model)new ModelImpl().type("object").property("b", (Property)new RefProperty("#/definitions/B")));
        swagger.addDefinition("B", (Model)new ModelImpl().type("object").property("a", (Property)new RefProperty("#/definitions/A")));
        Assertions.assertThat((boolean)CyclicValidationCheck.hasCyclicReferences((Swagger)swagger)).isTrue();
    }

    @Test
    public void shouldFindTwoStepCyclicReferencesInResponses() {
        Swagger swagger = new Swagger().path("/api", new Path().post(new Operation().response(200, new Response().responseSchema((Model)new RefModel("#/definitions/A")))));
        swagger.addDefinition("A", (Model)new ModelImpl().type("object").property("b", (Property)new RefProperty("#/definitions/B")));
        swagger.addDefinition("B", (Model)new ModelImpl().type("object").property("a", (Property)new RefProperty("#/definitions/A")));
        Assertions.assertThat((boolean)CyclicValidationCheck.hasCyclicReferences((Swagger)swagger)).isTrue();
    }

    @Test
    public void shouldTolerateNullValue() {
        Assertions.assertThat((boolean)CyclicValidationCheck.hasCyclicReferences(null)).isFalse();
    }

    @Test
    public void shouldTolerateTrivialValue() {
        Assertions.assertThat((boolean)CyclicValidationCheck.hasCyclicReferences((Swagger)new Swagger())).isFalse();
    }
}

