/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.swagger;

import io.syndesis.common.model.action.ConnectorAction;
import io.syndesis.common.model.action.ConnectorDescriptor;
import io.syndesis.common.model.api.APISummary;
import io.syndesis.common.model.connection.Connection;
import io.syndesis.common.model.connection.Connector;
import io.syndesis.common.model.integration.Flow;
import io.syndesis.server.api.generator.APIIntegration;
import io.syndesis.server.api.generator.APIValidationContext;
import io.syndesis.server.api.generator.ProvidedApiTemplate;
import io.syndesis.server.api.generator.swagger.SwaggerAPIGenerator;
import io.syndesis.server.api.generator.swagger.TestHelper;
import java.io.IOException;
import java.util.List;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;

public class SwaggerAPIGeneratorTest {
    @Test
    public void infoShouldHandleNullModels() {
        SwaggerAPIGenerator generator = new SwaggerAPIGenerator();
        APISummary summary = generator.info("invalid", APIValidationContext.NONE);
        Assertions.assertThat((Object)summary).isNotNull();
        ((ListAssert)Assertions.assertThat((List)summary.getErrors()).hasSize(1)).allSatisfy(v -> {
            AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)Assertions.assertThat((String)v.message()).startsWith((CharSequence)"This document cannot be uploaded. Provide an OpenAPI 2.0 document");
        });
        Assertions.assertThat((List)summary.getWarnings()).isEmpty();
    }

    @Test
    public void infoShouldHandleNullPaths() {
        SwaggerAPIGenerator generator = new SwaggerAPIGenerator();
        APISummary summary = generator.info("{\"swagger\": \"2.0\"}", APIValidationContext.NONE);
        Assertions.assertThat((Object)summary).isNotNull();
        Assertions.assertThat((List)summary.getErrors()).isEmpty();
        Assertions.assertThat((List)summary.getWarnings()).isEmpty();
    }

    @Test
    public void infoShouldHandleNullSpecifications() {
        SwaggerAPIGenerator generator = new SwaggerAPIGenerator();
        APISummary summary = generator.info(null, APIValidationContext.NONE);
        Assertions.assertThat((Object)summary).isNotNull();
        ((ListAssert)Assertions.assertThat((List)summary.getErrors()).hasSize(1)).allSatisfy(v -> {
            AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)Assertions.assertThat((String)v.message()).startsWith((CharSequence)"Unable to resolve OpenAPI document from");
        });
        Assertions.assertThat((List)summary.getWarnings()).isEmpty();
    }

    @Test
    public void testEmptyOperationSummary() throws IOException {
        ProvidedApiTemplate template = new ProvidedApiTemplate(SwaggerAPIGeneratorTest.dummyConnection(), "fromAction", "toAction");
        String specification = TestHelper.resource("/swagger/empty-summary.json");
        SwaggerAPIGenerator generator = new SwaggerAPIGenerator();
        APIIntegration apiIntegration = generator.generateIntegration(specification, template);
        Assertions.assertThat((Object)apiIntegration).isNotNull();
        Assertions.assertThat((List)apiIntegration.getIntegration().getFlows()).hasSize(3);
        List flows = apiIntegration.getIntegration().getFlows();
        ((ObjectAssert)((ListAssert)Assertions.assertThat((List)flows).filteredOn(SwaggerAPIGeneratorTest.idEndsWith("-1"))).first()).hasFieldOrPropertyWithValue("name", (Object)"Receiving GET request on /hi");
        ((ObjectAssert)((ListAssert)Assertions.assertThat((List)flows).filteredOn(SwaggerAPIGeneratorTest.idEndsWith("-2"))).first()).hasFieldOrPropertyWithValue("name", (Object)"post operation");
        ((ObjectAssert)((ListAssert)Assertions.assertThat((List)flows).filteredOn(SwaggerAPIGeneratorTest.idEndsWith("-3"))).first()).hasFieldOrPropertyWithValue("name", (Object)"Receiving PUT request on /hi");
    }

    private static Connection dummyConnection() {
        Connector connector = new Connector.Builder().addAction(new ConnectorAction.Builder().id("fromAction").descriptor(new ConnectorDescriptor.Builder().build()).build()).addAction(new ConnectorAction.Builder().id("toAction").descriptor(new ConnectorDescriptor.Builder().build()).build()).build();
        return new Connection.Builder().connector(connector).build();
    }

    private static Predicate<Flow> idEndsWith(String end) {
        return f -> f.getId().map(id -> id.endsWith(end)).orElse(false);
    }
}

