/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.swagger;

import com.fasterxml.jackson.databind.SerializationFeature;
import io.syndesis.common.util.Json;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class TestHelper {
    private TestHelper() {
    }

    public static String resource(String path) throws IOException {
        String resource;
        try (InputStream in = Objects.requireNonNull(TestHelper.class.getResourceAsStream(path), path);
             BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            resource = reader.lines().collect(Collectors.joining("\n"));
        }
        return resource;
    }

    static String reformatJson(String json) throws IOException {
        if (json == null) {
            return null;
        }
        Map tree = (Map)Json.reader().forType(Map.class).readValue(json);
        return Json.copyObjectMapperConfiguration().configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true).writerWithDefaultPrettyPrinter().writeValueAsString((Object)tree);
    }

    static String resource(String path, String alternative) throws IOException {
        if (TestHelper.class.getResource(path) != null) {
            return TestHelper.resource(path);
        }
        return TestHelper.resource(alternative);
    }
}

