/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.swagger.util;

import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.syndesis.server.api.generator.swagger.util.OperationDescription;
import io.syndesis.server.api.generator.swagger.util.SwaggerHelper;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SwaggerHelperOperationDescriptionGenerationTest {
    private final OperationDescription expected;
    private final Operation operation;
    private final Swagger swagger;

    public SwaggerHelperOperationDescriptionGenerationTest(String operationSummary, String operationDescription, String expectedName, String expectedDescription) {
        this.operation = new Operation().description(operationDescription).summary(operationSummary);
        this.swagger = new Swagger().path("/test", new Path().get(this.operation));
        this.expected = new OperationDescription(expectedName, expectedDescription);
    }

    @Test
    public void shouldDetermineOperationDescriptions() {
        Assertions.assertThat((Object)SwaggerHelper.operationDescriptionOf((Swagger)this.swagger, (Operation)this.operation, (m, p) -> "Send " + m + " request to " + p)).isEqualTo((Object)this.expected);
    }

    @Parameterized.Parameters
    public static Iterable<Object[]> parameters() {
        return Arrays.asList({null, null, "GET /test", "Send GET request to /test"}, {"null", "null", "GET /test", "Send GET request to /test"}, {null, "", "GET /test", "Send GET request to /test"}, {"null", "", "GET /test", "Send GET request to /test"}, {"", null, "GET /test", "Send GET request to /test"}, {"", "null", "GET /test", "Send GET request to /test"}, {"", "", "GET /test", "Send GET request to /test"}, {"Test summary", "Test description", "Test summary", "Test description"}, {"", "Test description", "GET /test", "Test description"}, {null, "Test description", "GET /test", "Test description"}, {"null", "Test description", "GET /test", "Test description"}, {"Test summary", "", "Test summary", "Send GET request to /test"}, {"Test summary", null, "Test summary", "Send GET request to /test"}, {"Test summary", "null", "Test summary", "Send GET request to /test"});
    }
}

