/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.swagger.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import io.syndesis.common.model.Violation;
import io.syndesis.server.api.generator.APIValidationContext;
import io.syndesis.server.api.generator.swagger.AbstractSwaggerConnectorTest;
import io.syndesis.server.api.generator.swagger.SwaggerModelInfo;
import io.syndesis.server.api.generator.swagger.TestHelper;
import io.syndesis.server.api.generator.swagger.util.SwaggerHelper;
import io.syndesis.server.jsondb.impl.JsonRecordSupport;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Test;

public class SwaggerHelperTest
extends AbstractSwaggerConnectorTest {
    @Test
    public void convertingToJsonShouldNotLooseSecurityRequirements() throws JsonProcessingException, IOException {
        String definition = "{\"swagger\":\"2.0\",\"paths\":{\"/api\":{\"get\":{\"security\":[{\"secured\":[\"scope\"]}]}}}}";
        JsonNode node = SwaggerHelper.convertToJson((String)"{\"swagger\":\"2.0\",\"paths\":{\"/api\":{\"get\":{\"security\":[{\"secured\":[\"scope\"]}]}}}}");
        Assertions.assertThat((Iterable)node.get("paths").get("/api").get("get").get("security")).hasOnlyOneElementSatisfying(securityRequirement -> Assertions.assertThat((Iterable)securityRequirement.get("secured")).hasOnlyOneElementSatisfying(scope -> {
            AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)Assertions.assertThat((String)scope.asText()).isEqualTo((Object)"scope");
        }));
    }

    @Test
    public void shouldNotReportIssuesWithSupportedVersions() {
        SwaggerModelInfo validated = SwaggerHelper.parse((String)"{\"swagger\": \"2.0\", \"info\":{ \"title\": \"test\", \"version\": \"1\"}, \"paths\": { \"/api\": { \"get\": {\"responses\": { \"200\": { \"description\": \"OK\" }}}}}}", (APIValidationContext)APIValidationContext.CONSUMED_API);
        List errors = validated.getErrors();
        Assertions.assertThat((List)errors).isEmpty();
    }

    @Test
    public void shouldReportIssuesWithUnsupportedVersions() {
        SwaggerModelInfo validated = SwaggerHelper.parse((String)"{\"openapi\": \"3.0.0\", \"info\":{ \"title\": \"test\", \"version\": \"1\"}, \"paths\": { \"/api\": { \"get\": {\"responses\": { \"200\": { \"description\": \"OK\" }}}}}}", (APIValidationContext)APIValidationContext.CONSUMED_API);
        List errors = validated.getErrors();
        Assertions.assertThat((List)errors).containsOnly((Object[])new Violation[]{new Violation.Builder().property("").error("unsupported-version").message("This document cannot be uploaded. Provide an OpenAPI 2.0 document.").build()});
    }

    @Test
    public void shouldSanitizeListOfTags() {
        Assertions.assertThat((Stream)SwaggerHelper.sanitizeTags(Arrays.asList("tag", "wag ", " bag", ".]t%a$g#[/"))).containsExactly((Object[])new String[]{"tag", "wag", "bag"});
    }

    @Test
    public void shouldSanitizeTags() {
        Assertions.assertThat((String)SwaggerHelper.sanitizeTag((String)"tag")).isEqualTo((Object)"tag");
        Assertions.assertThat((String)SwaggerHelper.sanitizeTag((String)".]t%a$g#[/")).isEqualTo((Object)"tag");
        char[] str = new char[1024];
        String randomString = IntStream.range(0, str.length).map(x -> (int)(1114111.0 * Math.random())).mapToObj(i -> new String(Character.toChars(i))).collect(Collectors.joining(""));
        String sanitized = SwaggerHelper.sanitizeTag((String)randomString);
        Assertions.assertThatCode(() -> JsonRecordSupport.validateKey((String)sanitized)).doesNotThrowAnyException();
    }

    @Test
    public void testThatAllSwaggerFilesAreValid() throws IOException {
        String[] specifications;
        for (String specificationFile : specifications = new String[]{"/swagger/concur.swagger.json", "/swagger/petstore.swagger.json", "/swagger/todo.swagger.yaml"}) {
            String specification = TestHelper.resource(specificationFile);
            SwaggerModelInfo info = SwaggerHelper.parse((String)specification, (APIValidationContext)APIValidationContext.CONSUMED_API);
            ((ListAssert)Assertions.assertThat((List)info.getErrors()).withFailMessage("Specification " + specificationFile + " has errors: " + info.getErrors(), new Object[0])).isEmpty();
        }
    }

    @Test
    public void testThatInvalidFieldPetstoreSwaggerIsInvalid() throws IOException {
        String specification = TestHelper.resource("/swagger/invalid/invalid-field.petstore.swagger.json");
        SwaggerModelInfo info = SwaggerHelper.parse((String)specification, (APIValidationContext)APIValidationContext.CONSUMED_API);
        Assertions.assertThat((List)info.getErrors()).hasSize(1);
        Assertions.assertThat((List)info.getWarnings()).isEmpty();
        Assertions.assertThat((String)((Violation)info.getErrors().get(0)).message()).startsWith((CharSequence)"object instance has properties which are not allowed by the schema");
        Assertions.assertThat((String)((Violation)info.getErrors().get(0)).property()).contains(new CharSequence[]{"/paths/~1pet/put"});
        Assertions.assertThat((String)((Violation)info.getErrors().get(0)).error()).contains(new CharSequence[]{"validation"});
    }

    @Test
    public void testThatInvalidSchemePetstoreSwaggerIsInvalid() throws IOException {
        String specification = TestHelper.resource("/swagger/invalid/invalid-scheme.petstore.swagger.json");
        SwaggerModelInfo info = SwaggerHelper.parse((String)specification, (APIValidationContext)APIValidationContext.CONSUMED_API);
        Assertions.assertThat((List)info.getErrors()).hasSize(1);
        Assertions.assertThat((List)info.getWarnings()).hasSize(1);
        Assertions.assertThat((String)((Violation)info.getErrors().get(0)).message()).startsWith((CharSequence)"instance value (\"httpz\") not found in enum");
        Assertions.assertThat((String)((Violation)info.getErrors().get(0)).property()).contains(new CharSequence[]{"/schemes/0"});
        Assertions.assertThat((String)((Violation)info.getErrors().get(0)).error()).contains(new CharSequence[]{"validation"});
        Assertions.assertThat((String)((Violation)info.getWarnings().get(0)).message()).startsWith((CharSequence)"Unable to determine the scheme");
        Assertions.assertThat((String)((Violation)info.getWarnings().get(0)).property()).contains(new CharSequence[]{"/schemes"});
        Assertions.assertThat((String)((Violation)info.getWarnings().get(0)).error()).contains(new CharSequence[]{"missing-schemes"});
    }

    @Test
    public void testThatInvalidTypePetstoreSwaggerIsInvalid() throws IOException {
        String specification = TestHelper.resource("/swagger/invalid/invalid-type.petstore.swagger.json");
        SwaggerModelInfo info = SwaggerHelper.parse((String)specification, (APIValidationContext)APIValidationContext.CONSUMED_API);
        Assertions.assertThat((List)info.getErrors()).hasSize(1);
        Assertions.assertThat((List)info.getWarnings()).isEmpty();
        Assertions.assertThat((String)((Violation)info.getErrors().get(0)).message()).startsWith((CharSequence)"instance failed to match exactly one schema");
        Assertions.assertThat((String)((Violation)info.getErrors().get(0)).property()).contains(new CharSequence[]{"/paths/~1pet~1{petId}/post/parameters/2"});
        Assertions.assertThat((String)((Violation)info.getErrors().get(0)).error()).contains(new CharSequence[]{"validation"});
    }

    @Test
    public void testThatWarningPetstoreSwaggerContainsWarnings() throws IOException {
        String specification = TestHelper.resource("/swagger/invalid/warning-petstore.swagger.json");
        SwaggerModelInfo info = SwaggerHelper.parse((String)specification, (APIValidationContext)APIValidationContext.CONSUMED_API);
        Assertions.assertThat((List)info.getErrors()).isEmpty();
        Assertions.assertThat((List)info.getWarnings()).hasSize(2);
    }
}

