/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.util;

import io.syndesis.common.model.action.ConnectorAction;
import io.syndesis.server.api.generator.util.ActionComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ActionComparatorTest {
    @Test
    public void shouldOrderActionsBasedOnTags() {
        ConnectorAction a = new ConnectorAction.Builder().addTag("a").build();
        ConnectorAction b = new ConnectorAction.Builder().addTag("b").build();
        ConnectorAction c = new ConnectorAction.Builder().addTag("c").build();
        ConnectorAction noTags = new ConnectorAction.Builder().build();
        ArrayList<ConnectorAction> actions = new ArrayList<ConnectorAction>(Arrays.asList(c, noTags, a, b));
        Collections.shuffle(actions);
        actions.sort(ActionComparator.INSTANCE);
        Assertions.assertThat(actions).containsExactly((Object[])new ConnectorAction[]{a, b, c, noTags});
    }

    @Test
    public void shouldOrderActionsBasedOnTagsAndName() {
        ConnectorAction a = new ConnectorAction.Builder().name("a").addTag("a").build();
        ConnectorAction b = new ConnectorAction.Builder().name("b").addTag("b").build();
        ConnectorAction c = new ConnectorAction.Builder().name("c").addTag("b").build();
        ConnectorAction noTagsA = new ConnectorAction.Builder().name("a").build();
        ConnectorAction noTagsB = new ConnectorAction.Builder().name("b").build();
        ConnectorAction noTagsNoName = new ConnectorAction.Builder().build();
        ArrayList<ConnectorAction> actions = new ArrayList<ConnectorAction>(Arrays.asList(c, noTagsA, a, noTagsB, b, noTagsNoName));
        Collections.shuffle(actions);
        actions.sort(ActionComparator.INSTANCE);
        Assertions.assertThat(actions).containsExactly((Object[])new ConnectorAction[]{a, b, c, noTagsA, noTagsB, noTagsNoName});
    }
}

