/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator;

import io.syndesis.common.model.action.Action;
import io.syndesis.common.model.connection.Connection;
import io.syndesis.common.util.Optionals;
import java.util.Objects;
import java.util.Optional;

public final class ProvidedApiTemplate {
    private final Connection connection;
    private final String startActionId;
    private final String endActionId;

    public ProvidedApiTemplate(Connection connection, String startActionId, String endActionId) {
        this.connection = Objects.requireNonNull(connection, "connection cannot be null");
        this.startActionId = Objects.requireNonNull(startActionId, "startActionId cannot be null");
        this.endActionId = Objects.requireNonNull(endActionId, "endActionId cannot be null");
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getStartActionId() {
        return this.startActionId;
    }

    public Optional<? extends Action> getStartAction() {
        return this.getAction(this.startActionId);
    }

    public String getEndActionId() {
        return this.endActionId;
    }

    public Optional<? extends Action> getEndAction() {
        return this.getAction(this.endActionId);
    }

    Optional<? extends Action> getAction(String id) {
        return Optionals.asStream((Optional)this.connection.getConnector()).flatMap(c -> c.getActions().stream()).filter(a -> a.getId().equals(Optional.of(id))).findFirst();
    }
}

