/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.swagger;

import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.RefModel;
import io.swagger.models.Swagger;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

final class CyclicValidationCheck {
    private CyclicValidationCheck() {
    }

    static boolean hasCyclicReferences(Swagger swagger) {
        if (swagger == null || swagger.getDefinitions() == null || swagger.getDefinitions().isEmpty()) {
            return false;
        }
        Map<String, Set<String>> references = CyclicValidationCheck.collectReferences(swagger);
        return CyclicValidationCheck.isCyclic(references);
    }

    private static Map<String, Set<String>> collectReferences(Swagger swagger) {
        TreeMap<String, Set<String>> references = new TreeMap<String, Set<String>>();
        for (Map.Entry definition : swagger.getDefinitions().entrySet()) {
            String name = (String)definition.getKey();
            references.putIfAbsent(name, new HashSet());
            Model model = (Model)definition.getValue();
            if (model instanceof RefModel) {
                CyclicValidationCheck.referenceFrom(references, name, (RefModel)model);
                continue;
            }
            if (model instanceof ArrayModel) {
                Property property = ((ArrayModel)model).getItems();
                CyclicValidationCheck.collectReferencesFromProperty(references, name, property);
                continue;
            }
            CyclicValidationCheck.collectReferencesFromProperties(references, name, model.getProperties());
        }
        return references;
    }

    private static void collectReferencesFromProperties(Map<String, Set<String>> allReferences, String from, Map<String, Property> properties) {
        if (properties == null) {
            return;
        }
        for (Property nestedProperty : properties.values()) {
            CyclicValidationCheck.collectReferencesFromProperty(allReferences, from, nestedProperty);
        }
    }

    private static void collectReferencesFromProperty(Map<String, Set<String>> allReferences, String from, Property property) {
        if (property instanceof RefProperty) {
            CyclicValidationCheck.referenceFrom(allReferences, from, (RefProperty)property);
        } else if (property instanceof ObjectProperty) {
            CyclicValidationCheck.collectReferencesFromProperties(allReferences, from, ((ObjectProperty)property).getProperties());
        }
    }

    private static boolean isCyclic(Map<String, Set<String>> references) {
        for (Map.Entry<String, Set<String>> reference : references.entrySet()) {
            Set<String> referencing;
            String current = reference.getKey();
            if (!CyclicValidationCheck.isCyclic(current, references, referencing = reference.getValue())) continue;
            return true;
        }
        return false;
    }

    private static boolean isCyclic(String starting, Map<String, Set<String>> references, Set<String> referencing) {
        if (referencing == null) {
            return false;
        }
        if (referencing.contains(starting)) {
            return true;
        }
        for (String next : referencing) {
            if (!CyclicValidationCheck.isCyclic(starting, references, references.get(next))) continue;
            return true;
        }
        return false;
    }

    private static void referenceFrom(Map<String, Set<String>> allReferences, String from, RefModel to) {
        String simpleRef = to.getSimpleRef();
        allReferences.putIfAbsent(from, new HashSet());
        allReferences.get(from).add(simpleRef);
    }

    private static void referenceFrom(Map<String, Set<String>> allReferences, String from, RefProperty to) {
        String simpleRef = to.getSimpleRef();
        allReferences.putIfAbsent(from, new HashSet());
        allReferences.get(from).add(simpleRef);
    }
}

