/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.swagger;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.swagger.models.Swagger;
import io.syndesis.common.model.Violation;
import io.syndesis.server.api.generator.swagger.SwaggerModelInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SwaggerModelInfo", generator="Immutables")
@SuppressFBWarnings
@Immutable
final class ImmutableSwaggerModelInfo
implements SwaggerModelInfo {
    private final List<Violation> errors;
    private final Swagger model;
    private final String resolvedSpecification;
    private final List<Violation> warnings;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long RESOLVED_JSON_GRAPH_LAZY_INIT_BIT = 1L;
    private transient ObjectNode resolvedJsonGraph;
    private static final Validator validator = Validation.buildDefaultValidatorFactory().getValidator();

    private ImmutableSwaggerModelInfo(Iterable<? extends Violation> errors, Swagger model, String resolvedSpecification, Iterable<? extends Violation> warnings) {
        this.errors = ImmutableSwaggerModelInfo.createUnmodifiableList(false, ImmutableSwaggerModelInfo.createSafeList(errors, true, false));
        this.model = model;
        this.resolvedSpecification = resolvedSpecification;
        this.warnings = ImmutableSwaggerModelInfo.createUnmodifiableList(false, ImmutableSwaggerModelInfo.createSafeList(warnings, true, false));
        this.initShim = null;
    }

    private ImmutableSwaggerModelInfo(Builder builder) {
        this.model = builder.model;
        this.resolvedSpecification = builder.resolvedSpecification;
        if (builder.errorsIsSet()) {
            this.initShim.errors(ImmutableSwaggerModelInfo.createUnmodifiableList(true, builder.errors));
        }
        if (builder.warningsIsSet()) {
            this.initShim.warnings(ImmutableSwaggerModelInfo.createUnmodifiableList(true, builder.warnings));
        }
        this.errors = this.initShim.getErrors();
        this.warnings = this.initShim.getWarnings();
        this.initShim = null;
    }

    private ImmutableSwaggerModelInfo(ImmutableSwaggerModelInfo original, List<Violation> errors, Swagger model, String resolvedSpecification, List<Violation> warnings) {
        this.errors = errors;
        this.model = model;
        this.resolvedSpecification = resolvedSpecification;
        this.warnings = warnings;
        this.initShim = null;
    }

    private List<Violation> getErrorsInitialize() {
        return SwaggerModelInfo.super.getErrors();
    }

    private List<Violation> getWarningsInitialize() {
        return SwaggerModelInfo.super.getWarnings();
    }

    @Override
    @JsonProperty(value="errors")
    public List<Violation> getErrors() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getErrors() : this.errors;
    }

    @Override
    @JsonProperty(value="model")
    public Swagger getModel() {
        return this.model;
    }

    @Override
    @JsonProperty(value="resolvedSpecification")
    public String getResolvedSpecification() {
        return this.resolvedSpecification;
    }

    @Override
    @JsonProperty(value="warnings")
    public List<Violation> getWarnings() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getWarnings() : this.warnings;
    }

    public final ImmutableSwaggerModelInfo withErrors(Violation ... elements) {
        List<Violation> newValue = ImmutableSwaggerModelInfo.createUnmodifiableList(false, ImmutableSwaggerModelInfo.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableSwaggerModelInfo.validate(new ImmutableSwaggerModelInfo(this, newValue, this.model, this.resolvedSpecification, this.warnings));
    }

    public final ImmutableSwaggerModelInfo withErrors(Iterable<? extends Violation> elements) {
        if (this.errors == elements) {
            return this;
        }
        List<Violation> newValue = ImmutableSwaggerModelInfo.createUnmodifiableList(false, ImmutableSwaggerModelInfo.createSafeList(elements, true, false));
        return ImmutableSwaggerModelInfo.validate(new ImmutableSwaggerModelInfo(this, newValue, this.model, this.resolvedSpecification, this.warnings));
    }

    public final ImmutableSwaggerModelInfo withModel(Swagger value) {
        if (this.model == value) {
            return this;
        }
        return ImmutableSwaggerModelInfo.validate(new ImmutableSwaggerModelInfo(this, this.errors, value, this.resolvedSpecification, this.warnings));
    }

    public final ImmutableSwaggerModelInfo withResolvedSpecification(String value) {
        if (Objects.equals(this.resolvedSpecification, value)) {
            return this;
        }
        return ImmutableSwaggerModelInfo.validate(new ImmutableSwaggerModelInfo(this, this.errors, this.model, value, this.warnings));
    }

    public final ImmutableSwaggerModelInfo withWarnings(Violation ... elements) {
        List<Violation> newValue = ImmutableSwaggerModelInfo.createUnmodifiableList(false, ImmutableSwaggerModelInfo.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableSwaggerModelInfo.validate(new ImmutableSwaggerModelInfo(this, this.errors, this.model, this.resolvedSpecification, newValue));
    }

    public final ImmutableSwaggerModelInfo withWarnings(Iterable<? extends Violation> elements) {
        if (this.warnings == elements) {
            return this;
        }
        List<Violation> newValue = ImmutableSwaggerModelInfo.createUnmodifiableList(false, ImmutableSwaggerModelInfo.createSafeList(elements, true, false));
        return ImmutableSwaggerModelInfo.validate(new ImmutableSwaggerModelInfo(this, this.errors, this.model, this.resolvedSpecification, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSwaggerModelInfo && this.equalTo((ImmutableSwaggerModelInfo)another);
    }

    private boolean equalTo(ImmutableSwaggerModelInfo another) {
        return this.errors.equals(another.errors) && Objects.equals(this.model, another.model) && Objects.equals(this.resolvedSpecification, another.resolvedSpecification) && this.warnings.equals(another.warnings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.errors.hashCode();
        h += (h << 5) + Objects.hashCode(this.model);
        h += (h << 5) + Objects.hashCode(this.resolvedSpecification);
        h += (h << 5) + this.warnings.hashCode();
        return h;
    }

    public String toString() {
        return "SwaggerModelInfo{errors=" + this.errors + ", model=" + this.model + ", resolvedSpecification=" + this.resolvedSpecification + ", warnings=" + this.warnings + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectNode getResolvedJsonGraph() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableSwaggerModelInfo immutableSwaggerModelInfo = this;
            synchronized (immutableSwaggerModelInfo) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.resolvedJsonGraph = Objects.requireNonNull(SwaggerModelInfo.super.getResolvedJsonGraph(), "resolvedJsonGraph");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.resolvedJsonGraph;
    }

    public static SwaggerModelInfo of(List<Violation> errors, Swagger model, String resolvedSpecification, List<Violation> warnings) {
        return ImmutableSwaggerModelInfo.of(errors, model, resolvedSpecification, warnings);
    }

    public static SwaggerModelInfo of(Iterable<? extends Violation> errors, Swagger model, String resolvedSpecification, Iterable<? extends Violation> warnings) {
        return ImmutableSwaggerModelInfo.validate(new ImmutableSwaggerModelInfo(errors, model, resolvedSpecification, warnings));
    }

    private static ImmutableSwaggerModelInfo validate(ImmutableSwaggerModelInfo instance) {
        Set constraintViolations = validator.validate((Object)instance, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            throw new ConstraintViolationException(constraintViolations);
        }
        return instance;
    }

    public static SwaggerModelInfo copyOf(SwaggerModelInfo instance) {
        if (instance instanceof ImmutableSwaggerModelInfo) {
            return (ImmutableSwaggerModelInfo)instance;
        }
        return new SwaggerModelInfo.Builder().createFrom(instance).build();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="SwaggerModelInfo", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long OPT_BIT_ERRORS = 1L;
        private static final long OPT_BIT_WARNINGS = 2L;
        private long optBits;
        private List<Violation> errors = new ArrayList<Violation>();
        @Nullable
        private Swagger model;
        @Nullable
        private String resolvedSpecification;
        private List<Violation> warnings = new ArrayList<Violation>();

        public Builder() {
            if (!(this instanceof SwaggerModelInfo.Builder)) {
                throw new UnsupportedOperationException("Use: new SwaggerModelInfo.Builder()");
            }
        }

        public final SwaggerModelInfo.Builder createFrom(SwaggerModelInfo instance) {
            String resolvedSpecificationValue;
            Objects.requireNonNull(instance, "instance");
            this.addAllErrors(instance.getErrors());
            Swagger modelValue = instance.getModel();
            if (modelValue != null) {
                this.model(modelValue);
            }
            if ((resolvedSpecificationValue = instance.getResolvedSpecification()) != null) {
                this.resolvedSpecification(resolvedSpecificationValue);
            }
            this.addAllWarnings(instance.getWarnings());
            return (SwaggerModelInfo.Builder)this;
        }

        public final SwaggerModelInfo.Builder addError(Violation element) {
            this.errors.add(Objects.requireNonNull(element, "errors element"));
            this.optBits |= 1L;
            return (SwaggerModelInfo.Builder)this;
        }

        public final SwaggerModelInfo.Builder addErrors(Violation ... elements) {
            for (Violation element : elements) {
                this.errors.add(Objects.requireNonNull(element, "errors element"));
            }
            this.optBits |= 1L;
            return (SwaggerModelInfo.Builder)this;
        }

        @JsonProperty(value="errors")
        public final SwaggerModelInfo.Builder errors(Iterable<? extends Violation> elements) {
            this.errors.clear();
            return this.addAllErrors(elements);
        }

        public final SwaggerModelInfo.Builder addAllErrors(Iterable<? extends Violation> elements) {
            for (Violation violation : elements) {
                this.errors.add(Objects.requireNonNull(violation, "errors element"));
            }
            this.optBits |= 1L;
            return (SwaggerModelInfo.Builder)this;
        }

        @JsonProperty(value="model")
        public final SwaggerModelInfo.Builder model(Swagger model) {
            this.model = model;
            return (SwaggerModelInfo.Builder)this;
        }

        @JsonProperty(value="resolvedSpecification")
        public final SwaggerModelInfo.Builder resolvedSpecification(String resolvedSpecification) {
            this.resolvedSpecification = resolvedSpecification;
            return (SwaggerModelInfo.Builder)this;
        }

        public final SwaggerModelInfo.Builder addWarning(Violation element) {
            this.warnings.add(Objects.requireNonNull(element, "warnings element"));
            this.optBits |= 2L;
            return (SwaggerModelInfo.Builder)this;
        }

        public final SwaggerModelInfo.Builder addWarnings(Violation ... elements) {
            for (Violation element : elements) {
                this.warnings.add(Objects.requireNonNull(element, "warnings element"));
            }
            this.optBits |= 2L;
            return (SwaggerModelInfo.Builder)this;
        }

        @JsonProperty(value="warnings")
        public final SwaggerModelInfo.Builder warnings(Iterable<? extends Violation> elements) {
            this.warnings.clear();
            return this.addAllWarnings(elements);
        }

        public final SwaggerModelInfo.Builder addAllWarnings(Iterable<? extends Violation> elements) {
            for (Violation violation : elements) {
                this.warnings.add(Objects.requireNonNull(violation, "warnings element"));
            }
            this.optBits |= 2L;
            return (SwaggerModelInfo.Builder)this;
        }

        public SwaggerModelInfo build() {
            return ImmutableSwaggerModelInfo.validate(new ImmutableSwaggerModelInfo(this));
        }

        private boolean errorsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean warningsIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    @Generated(from="SwaggerModelInfo", generator="Immutables")
    private final class InitShim {
        private byte errorsBuildStage = 0;
        private List<Violation> errors;
        private byte warningsBuildStage = 0;
        private List<Violation> warnings;

        private InitShim() {
        }

        List<Violation> getErrors() {
            if (this.errorsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.errorsBuildStage == 0) {
                this.errorsBuildStage = (byte)-1;
                this.errors = ImmutableSwaggerModelInfo.createUnmodifiableList(false, ImmutableSwaggerModelInfo.createSafeList(ImmutableSwaggerModelInfo.this.getErrorsInitialize(), true, false));
                this.errorsBuildStage = 1;
            }
            return this.errors;
        }

        void errors(List<Violation> errors) {
            this.errors = errors;
            this.errorsBuildStage = 1;
        }

        List<Violation> getWarnings() {
            if (this.warningsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.warningsBuildStage == 0) {
                this.warningsBuildStage = (byte)-1;
                this.warnings = ImmutableSwaggerModelInfo.createUnmodifiableList(false, ImmutableSwaggerModelInfo.createSafeList(ImmutableSwaggerModelInfo.this.getWarningsInitialize(), true, false));
                this.warningsBuildStage = 1;
            }
            return this.warnings;
        }

        void warnings(List<Violation> warnings) {
            this.warnings = warnings;
            this.warningsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.errorsBuildStage == -1) {
                attributes.add("errors");
            }
            if (this.warningsBuildStage == -1) {
                attributes.add("warnings");
            }
            return "Cannot build SwaggerModelInfo, attribute initializers form cycle " + attributes;
        }
    }
}

