/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.swagger;

import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.auth.AbstractSecuritySchemeDefinition;
import io.swagger.models.auth.ApiKeyAuthDefinition;
import io.swagger.models.auth.BasicAuthDefinition;
import io.swagger.models.auth.OAuth2Definition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.syndesis.common.model.connection.ConfigurationProperty;
import io.syndesis.common.model.connection.ConnectorSettings;
import io.syndesis.server.api.generator.swagger.SupportedAuthenticationTypes;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

enum PropertyGenerators {
    accessToken{

        @Override
        protected PropertyGenerator propertyGenerator() {
            return (x$0, x$1, x$2) -> PropertyGenerators.ifHasOAuthSecurityDefinition(x$0, x$1, x$2);
        }
    }
    ,
    accessTokenExpiresAt{

        @Override
        protected PropertyGenerator propertyGenerator() {
            return (x$0, x$1, x$2) -> PropertyGenerators.ifHasOAuthSecurityDefinition(x$0, x$1, x$2);
        }
    }
    ,
    authenticationParameterName{

        @Override
        protected PropertyGenerator propertyGenerator() {
            return (swagger, template, settings) -> PropertyGenerators.apiKeyProperty(swagger, template, settings, ApiKeyAuthDefinition::getName);
        }
    }
    ,
    authenticationParameterPlacement{

        @Override
        protected PropertyGenerator propertyGenerator() {
            return (swagger, template, settings) -> 4.securityDefinition(swagger, settings, ApiKeyAuthDefinition.class).map(definition -> new ConfigurationProperty.Builder().createFrom(template).getEnum(Collections.emptyList()).defaultValue(definition.getIn().toValue()).build());
        }
    }
    ,
    authenticationParameterValue{

        @Override
        protected PropertyGenerator propertyGenerator() {
            return (x$0, x$1, x$2) -> PropertyGenerators.ifHasApiKeysSecurityDefinition(x$0, x$1, x$2);
        }
    }
    ,
    authenticationType{

        @Override
        protected PropertyGenerator propertyGenerator() {
            return (swagger, template, settings) -> {
                Map securityDefinitions = swagger.getSecurityDefinitions();
                if (securityDefinitions == null || securityDefinitions.isEmpty()) {
                    return Optional.of(new ConfigurationProperty.Builder().createFrom(template).defaultValue("none").addEnum(NO_SECURITY).build());
                }
                ConfigurationProperty.PropertyValue[] enums = (ConfigurationProperty.PropertyValue[])securityDefinitions.entrySet().stream().filter(e -> SupportedAuthenticationTypes.supports((SecuritySchemeDefinition)e.getValue())).map(e -> SupportedAuthenticationTypes.asPropertyValue((String)e.getKey(), (SecuritySchemeDefinition)e.getValue())).toArray(ConfigurationProperty.PropertyValue[]::new);
                ConfigurationProperty.Builder authenticationType = new ConfigurationProperty.Builder().createFrom(template).addEnum(enums);
                if (enums.length == 1) {
                    authenticationType.defaultValue(enums[0].getValue());
                }
                return Optional.of(authenticationType.build());
            };
        }
    }
    ,
    authorizationEndpoint{

        @Override
        protected PropertyGenerator propertyGenerator() {
            return (swagger, template, settings) -> PropertyGenerators.oauthProperty(swagger, template, settings, OAuth2Definition::getAuthorizationUrl);
        }
    }
    ,
    authorizeUsingParameters{

        @Override
        protected PropertyGenerator propertyGenerator() {
            return (swagger, template, settings) -> PropertyGenerators.oauthVendorProperty(swagger, template, settings, "x-authorize-using-parameters");
        }
    }
    ,
    basePath{

        @Override
        protected PropertyGenerator propertyGenerator() {
            return PropertyGenerators.withDefaultValue(Swagger::getBasePath);
        }
    }
    ,
    clientId{

        @Override
        protected PropertyGenerator propertyGenerator() {
            return (x$0, x$1, x$2) -> PropertyGenerators.ifHasOAuthSecurityDefinition(x$0, x$1, x$2);
        }
    }
    ,
    clientSecret{

        @Override
        protected PropertyGenerator propertyGenerator() {
            return (x$0, x$1, x$2) -> PropertyGenerators.ifHasOAuthSecurityDefinition(x$0, x$1, x$2);
        }
    }
    ,
    host{

        @Override
        protected PropertyGenerator propertyGenerator() {
            return PropertyGenerators.withDefaultValue(PropertyGenerators::determineHost);
        }
    }
    ,
    oauthScopes{

        @Override
        protected PropertyGenerator propertyGenerator() {
            return (swagger, template, settings) -> PropertyGenerators.oauthProperty(swagger, template, settings, d -> Optional.ofNullable(d.getScopes()).map(scopes -> scopes.keySet().stream().sorted().collect(Collectors.joining(" "))).orElse(null));
        }
    }
    ,
    password{

        @Override
        protected PropertyGenerator propertyGenerator() {
            return (x$0, x$1, x$2) -> PropertyGenerators.ifHasBasicSecurityDefinition(x$0, x$1, x$2);
        }
    }
    ,
    refreshToken{

        @Override
        protected PropertyGenerator propertyGenerator() {
            return (x$0, x$1, x$2) -> PropertyGenerators.ifHasOAuthSecurityDefinition(x$0, x$1, x$2);
        }
    }
    ,
    refreshTokenRetryStatuses{

        @Override
        protected PropertyGenerator propertyGenerator() {
            return (swagger, template, settings) -> PropertyGenerators.oauthVendorProperty(swagger, template, settings, "x-refresh-token-retry-statuses");
        }
    }
    ,
    specification{

        @Override
        protected PropertyGenerator propertyGenerator() {
            return (x$0, x$1, x$2) -> PropertyGenerators.fromTemplate(x$0, x$1, x$2);
        }
    }
    ,
    tokenEndpoint{

        @Override
        protected PropertyGenerator propertyGenerator() {
            return (swagger, template, settings) -> PropertyGenerators.oauthProperty(swagger, template, settings, OAuth2Definition::getTokenUrl);
        }
    }
    ,
    tokenStrategy{

        @Override
        protected PropertyGenerator propertyGenerator() {
            return (swagger, template, settings) -> PropertyGenerators.oauthVendorProperty(swagger, template, settings, "x-token-strategy");
        }
    }
    ,
    username{

        @Override
        protected PropertyGenerator propertyGenerator() {
            return (x$0, x$1, x$2) -> PropertyGenerators.ifHasBasicSecurityDefinition(x$0, x$1, x$2);
        }
    };

    private static final ConfigurationProperty.PropertyValue NO_SECURITY;

    protected abstract PropertyGenerator propertyGenerator();

    static String createHostUri(String scheme, String host, int port) {
        try {
            if (port == -1) {
                return new URI(scheme, host, null, null).toString();
            }
            return new URI(scheme, null, host, port, null, null, null).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static Optional<ConfigurationProperty> createProperty(String propertyName, Swagger swagger, ConfigurationProperty template, ConnectorSettings connectorSettings) {
        PropertyGenerators propertyGenerator = PropertyGenerators.valueOf(propertyName);
        return propertyGenerator.propertyGenerator().generate(swagger, template, connectorSettings);
    }

    static String determineHost(Swagger swagger) {
        int portToUse;
        Map vendorExtensions = Optional.ofNullable(swagger.getVendorExtensions()).orElse(Collections.emptyMap());
        URI specificationUrl = (URI)vendorExtensions.get("x-syndesis-swagger-url");
        String schemeToUse = PropertyGenerators.determineSchemeToUse(swagger, specificationUrl);
        if (schemeToUse == null) {
            return null;
        }
        String specificationHost = swagger.getHost();
        boolean specificationWithoutHost = StringUtils.isEmpty((CharSequence)specificationHost);
        if (specificationWithoutHost && specificationUrl == null) {
            return null;
        }
        String hostToUse = specificationWithoutHost && specificationUrl != null ? specificationUrl.getHost() : swagger.getHost();
        int colonIdx = hostToUse.indexOf(58);
        if (colonIdx == -1) {
            portToUse = -1;
        } else {
            portToUse = Integer.parseUnsignedInt(hostToUse.substring(colonIdx + 1));
            hostToUse = hostToUse.substring(0, colonIdx);
        }
        return PropertyGenerators.createHostUri(schemeToUse, hostToUse, portToUse);
    }

    static <T extends AbstractSecuritySchemeDefinition> Optional<T> securityDefinition(Swagger swagger, ConnectorSettings connectorSettings, Class<T> type) {
        Map securityDefinitions = swagger.getSecurityDefinitions();
        if (securityDefinitions == null || securityDefinitions.isEmpty()) {
            return Optional.empty();
        }
        Map<String, SecuritySchemeDefinition> supportedSecurityDefinitions = securityDefinitions.entrySet().stream().filter(e -> type.isInstance(e.getValue())).filter(e -> SupportedAuthenticationTypes.supports((SecuritySchemeDefinition)e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (supportedSecurityDefinitions.isEmpty()) {
            return Optional.empty();
        }
        Map configuredProperties = connectorSettings.getConfiguredProperties();
        String configuredAuthenticationType = (String)configuredProperties.get(authenticationType.name());
        if (supportedSecurityDefinitions.size() == 1 && configuredAuthenticationType == null) {
            AbstractSecuritySchemeDefinition onlySecurityDefinitionPresent = (AbstractSecuritySchemeDefinition)supportedSecurityDefinitions.values().iterator().next();
            return Optional.of(onlySecurityDefinitionPresent);
        }
        if (configuredAuthenticationType == null) {
            return Optional.empty();
        }
        for (Map.Entry<String, SecuritySchemeDefinition> securityDefinition : supportedSecurityDefinitions.entrySet()) {
            int idx = configuredAuthenticationType.indexOf(58);
            if (idx <= 0 || !securityDefinition.getKey().equals(configuredAuthenticationType.substring(idx + 1))) continue;
            AbstractSecuritySchemeDefinition choosenSecurityDefinition = (AbstractSecuritySchemeDefinition)securityDefinition.getValue();
            return Optional.of(choosenSecurityDefinition);
        }
        return Optional.empty();
    }

    private static Optional<ConfigurationProperty> apiKeyProperty(Swagger swagger, ConfigurationProperty template, ConnectorSettings connectorSettings, Function<ApiKeyAuthDefinition, String> defaultValueExtractor) {
        return PropertyGenerators.securityDefinition(swagger, connectorSettings, ApiKeyAuthDefinition.class).map(definition -> new ConfigurationProperty.Builder().createFrom(template).defaultValue((String)defaultValueExtractor.apply((ApiKeyAuthDefinition)definition)).build());
    }

    private static String determineSchemeToUse(Swagger swagger, URI specificationUrl) {
        boolean noSchemes;
        List schemes = swagger.getSchemes();
        boolean bl = noSchemes = schemes == null || schemes.isEmpty();
        if (noSchemes && specificationUrl == null) {
            return null;
        }
        String schemeToUse = noSchemes && specificationUrl != null ? specificationUrl.getScheme() : (schemes.contains(Scheme.HTTPS) ? "https" : (String)schemes.stream().filter(s -> s.toValue().startsWith("http")).map(s -> s.toValue()).findFirst().orElse(null));
        return schemeToUse;
    }

    private static Optional<ConfigurationProperty> fromTemplate(Swagger swagger, ConfigurationProperty template, ConnectorSettings connectorSettings) {
        return Optional.of(template);
    }

    private static Optional<ConfigurationProperty> ifHasApiKeysSecurityDefinition(Swagger swagger, ConfigurationProperty template, ConnectorSettings connectorSettings) {
        return PropertyGenerators.ifHasSecurityDefinition(swagger, template, connectorSettings, ApiKeyAuthDefinition.class);
    }

    private static Optional<ConfigurationProperty> ifHasBasicSecurityDefinition(Swagger swagger, ConfigurationProperty template, ConnectorSettings connectorSettings) {
        return PropertyGenerators.ifHasSecurityDefinition(swagger, template, connectorSettings, BasicAuthDefinition.class);
    }

    private static Optional<ConfigurationProperty> ifHasOAuthSecurityDefinition(Swagger swagger, ConfigurationProperty template, ConnectorSettings connectorSettings) {
        return PropertyGenerators.ifHasSecurityDefinition(swagger, template, connectorSettings, OAuth2Definition.class);
    }

    private static Optional<ConfigurationProperty> ifHasSecurityDefinition(Swagger swagger, ConfigurationProperty template, ConnectorSettings connectorSettings, Class<? extends AbstractSecuritySchemeDefinition> type) {
        Optional<? extends AbstractSecuritySchemeDefinition> securityDefinition = PropertyGenerators.securityDefinition(swagger, connectorSettings, type);
        if (securityDefinition.isPresent()) {
            return Optional.of(template);
        }
        return Optional.empty();
    }

    private static Optional<ConfigurationProperty> oauthProperty(Swagger swagger, ConfigurationProperty template, ConnectorSettings connectorSettings, Function<OAuth2Definition, String> defaultValueExtractor) {
        return PropertyGenerators.securityDefinition(swagger, connectorSettings, OAuth2Definition.class).map(definition -> new ConfigurationProperty.Builder().createFrom(template).defaultValue((String)defaultValueExtractor.apply((OAuth2Definition)definition)).build());
    }

    private static Optional<ConfigurationProperty> oauthVendorProperty(Swagger swagger, ConfigurationProperty template, ConnectorSettings connectorSettings, String name) {
        return PropertyGenerators.securityDefinition(swagger, connectorSettings, OAuth2Definition.class).map(definition -> PropertyGenerators.vendorExtension((SecuritySchemeDefinition)definition, template, name)).orElse(Optional.empty());
    }

    private static Optional<ConfigurationProperty> vendorExtension(SecuritySchemeDefinition definition, ConfigurationProperty template, String name) {
        Map vendorExtensions = definition.getVendorExtensions();
        if (vendorExtensions == null) {
            return Optional.empty();
        }
        Object value = vendorExtensions.get(name);
        if (value == null) {
            return Optional.empty();
        }
        ConfigurationProperty property = new ConfigurationProperty.Builder().createFrom(template).defaultValue(String.valueOf(value)).build();
        return Optional.of(property);
    }

    private static PropertyGenerator withDefaultValue(Function<Swagger, String> defaultValueExtractor) {
        return (swagger, template, settings) -> Optional.of(new ConfigurationProperty.Builder().createFrom(template).defaultValue((String)defaultValueExtractor.apply(swagger)).build());
    }

    static {
        NO_SECURITY = new ConfigurationProperty.PropertyValue.Builder().value("none").label("No Security").build();
    }

    @FunctionalInterface
    static interface PropertyGenerator {
        public Optional<ConfigurationProperty> generate(Swagger var1, ConfigurationProperty var2, ConnectorSettings var3);
    }
}

