/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.swagger;

import io.swagger.models.auth.OAuth2Definition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.syndesis.common.model.connection.ConfigurationProperty;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

enum SupportedAuthenticationTypes {
    apiKey("API Key"),
    basic("HTTP Basic Authentication"),
    oauth2("OAuth 2.0", SupportedAuthenticationTypes::authorizationFlow);

    private static final Set<String> SUPPORTED;
    final String label;
    final transient ConfigurationProperty.PropertyValue propertyValue;
    private final Predicate<SecuritySchemeDefinition> filter;

    private SupportedAuthenticationTypes(String label) {
        this(label, SupportedAuthenticationTypes::any);
    }

    private SupportedAuthenticationTypes(String label, Predicate<SecuritySchemeDefinition> filter) {
        this.label = label;
        this.filter = filter;
        this.propertyValue = new ConfigurationProperty.PropertyValue.Builder().value(this.name()).label(label).build();
    }

    public static SupportedAuthenticationTypes fromConfiguredPropertyValue(String value) {
        int idx = Objects.requireNonNull(value, "value").indexOf(58);
        return SupportedAuthenticationTypes.valueOf(idx > 0 ? value.substring(0, idx) : value);
    }

    public static SupportedAuthenticationTypes fromSecurityDefinition(String value) {
        return SupportedAuthenticationTypes.valueOf(value);
    }

    static ConfigurationProperty.PropertyValue asPropertyValue(String name, SecuritySchemeDefinition def) {
        ConfigurationProperty.PropertyValue template = SupportedAuthenticationTypes.valueOf((String)def.getType()).propertyValue;
        ConfigurationProperty.PropertyValue propertyValue = new ConfigurationProperty.PropertyValue.Builder().createFrom(template).label(template.getLabel() + " - " + name).value(template.getValue() + ":" + name).build();
        String description = def.getDescription();
        if (StringUtils.isEmpty((CharSequence)description)) {
            return propertyValue;
        }
        String labelWithDescription = propertyValue.getLabel() + " (" + description + ")";
        return new ConfigurationProperty.PropertyValue.Builder().createFrom(propertyValue).label(labelWithDescription).build();
    }

    static boolean supports(SecuritySchemeDefinition def) {
        String type = def.getType();
        return SUPPORTED.contains(type) && SupportedAuthenticationTypes.valueOf((String)type).filter.test(def);
    }

    private static boolean any(SecuritySchemeDefinition def) {
        return true;
    }

    private static boolean authorizationFlow(SecuritySchemeDefinition def) {
        if (!(def instanceof OAuth2Definition)) {
            return false;
        }
        OAuth2Definition oauth = (OAuth2Definition)def;
        return "accessCode".equals(oauth.getFlow());
    }

    static {
        SUPPORTED = Arrays.stream(SupportedAuthenticationTypes.values()).map(Enum::name).collect(Collectors.toSet());
    }
}

