/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.swagger;

import com.google.common.base.Strings;
import io.swagger.models.Info;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.syndesis.common.model.DataShape;
import io.syndesis.common.model.Kind;
import io.syndesis.common.model.ResourceIdentifier;
import io.syndesis.common.model.action.Action;
import io.syndesis.common.model.action.ActionsSummary;
import io.syndesis.common.model.action.ConnectorAction;
import io.syndesis.common.model.action.ConnectorDescriptor;
import io.syndesis.common.model.api.APISummary;
import io.syndesis.common.model.connection.ConfigurationProperty;
import io.syndesis.common.model.integration.Flow;
import io.syndesis.common.model.integration.Integration;
import io.syndesis.common.model.integration.Step;
import io.syndesis.common.model.integration.StepKind;
import io.syndesis.common.model.openapi.OpenApi;
import io.syndesis.common.util.KeyGenerator;
import io.syndesis.common.util.openapi.OpenApiHelper;
import io.syndesis.server.api.generator.APIGenerator;
import io.syndesis.server.api.generator.APIIntegration;
import io.syndesis.server.api.generator.APIValidationContext;
import io.syndesis.server.api.generator.ProvidedApiTemplate;
import io.syndesis.server.api.generator.swagger.BaseDataShapeGenerator;
import io.syndesis.server.api.generator.swagger.DataShapeGenerator;
import io.syndesis.server.api.generator.swagger.SwaggerModelInfo;
import io.syndesis.server.api.generator.swagger.UnifiedDataShapeGenerator;
import io.syndesis.server.api.generator.swagger.util.SwaggerHelper;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;

public class SwaggerAPIGenerator
implements APIGenerator {
    private static final String DEFAULT_RETURN_CODE_METADATA_KEY = "default-return-code";
    private static final String EXCERPT_METADATA_KEY = "excerpt";
    private static final String HTTP_RESPONSE_CODE_METADATA_KEY = "httpResponseCode";
    private final DataShapeGenerator dataShapeGenerator = new UnifiedDataShapeGenerator();

    @Override
    public APIIntegration generateIntegration(String specification, ProvidedApiTemplate template) {
        SwaggerModelInfo info = SwaggerHelper.parse(specification, APIValidationContext.NONE);
        Swagger swagger = info.getModel();
        String name = Optional.ofNullable(swagger.getInfo()).flatMap(i -> Optional.ofNullable(i.getTitle())).orElse(null);
        Integration.Builder integration = new Integration.Builder().addTag("api-provider").createdAt(System.currentTimeMillis()).name(name);
        HashSet<String> alreadyUsedOperationIds = new HashSet<String>();
        Map paths = swagger.getPaths();
        for (Map.Entry pathEntry : paths.entrySet()) {
            Path path = (Path)pathEntry.getValue();
            for (Map.Entry operationEntry : path.getOperationMap().entrySet()) {
                Operation operation = (Operation)operationEntry.getValue();
                String operationName = operation.getSummary();
                String operationDescription = operationEntry.getKey() + " " + (String)pathEntry.getKey();
                String operationId = this.requireUniqueOperationId(operation.getOperationId(), alreadyUsedOperationIds);
                alreadyUsedOperationIds.add(operationId);
                operation.setOperationId(operationId);
                DataShape startDataShape = this.dataShapeGenerator.createShapeFromRequest(info.getResolvedJsonGraph(), swagger, operation);
                Action startAction = template.getStartAction().orElseThrow(() -> new IllegalStateException("cannot find start action"));
                ConnectorAction.Builder modifiedStartActionBuilder = new ConnectorAction.Builder().createFrom(startAction).addTag("locked-action").descriptor(new ConnectorDescriptor.Builder().createFrom(startAction.getDescriptor()).outputDataShape(startDataShape).build());
                String basePath = swagger.getBasePath();
                if (!Strings.isNullOrEmpty((String)basePath)) {
                    modifiedStartActionBuilder.putMetadata("serverBasePath", basePath);
                }
                ConnectorAction modifiedStartAction = modifiedStartActionBuilder.build();
                Step startStep = new Step.Builder().id(KeyGenerator.createKey()).action((Action)modifiedStartAction).connection(template.getConnection()).stepKind(StepKind.endpoint).putConfiguredProperty("name", operationId).putMetadata("configured", "true").build();
                DataShape endDataShape = this.dataShapeGenerator.createShapeFromResponse(info.getResolvedJsonGraph(), swagger, operation);
                Action endAction = template.getEndAction().orElseThrow(() -> new IllegalStateException("cannot find end action"));
                ConnectorAction modifiedEndAction = new ConnectorAction.Builder().createFrom(endAction).addTag("locked-action").descriptor(new ConnectorDescriptor.Builder().createFrom(endAction.getDescriptor()).inputDataShape(endDataShape).build()).build();
                Step endStep = new Step.Builder().id(KeyGenerator.createKey()).action((Action)modifiedEndAction).connection(template.getConnection()).stepKind(StepKind.endpoint).putConfiguredProperty(HTTP_RESPONSE_CODE_METADATA_KEY, "501").putMetadata("configured", "true").build();
                if (Strings.isNullOrEmpty((String)operationName)) {
                    operationName = SwaggerHelper.operationDescriptionOf((Swagger)swagger, (Operation)operation, (BiFunction<String, String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$generateIntegration$3(java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;)()).description;
                }
                String defaultCode = "200";
                Optional<Pair<String, Response>> defaultResponse = BaseDataShapeGenerator.findResponseCodeValue(operation);
                if (defaultResponse.isPresent() && NumberUtils.isDigits((String)((String)defaultResponse.get().getKey()))) {
                    defaultCode = (String)defaultResponse.get().getKey();
                }
                String flowId = KeyGenerator.createKey();
                Flow flow = new Flow.Builder().id(flowId).type(Flow.FlowType.API_PROVIDER).putMetadata("openapi-operationid", operationId).putMetadata(EXCERPT_METADATA_KEY, "501 Not Implemented").putMetadata(DEFAULT_RETURN_CODE_METADATA_KEY, defaultCode).addStep(startStep).addStep(endStep).name(operationName).description(operationDescription).build();
                integration.addFlow(flow);
            }
        }
        byte[] updatedSwagger = OpenApiHelper.serialize((Swagger)swagger).getBytes(StandardCharsets.UTF_8);
        String specificationContentType = specification.trim().startsWith("{") ? "application/vnd.oai.openapi+json" : "application/vnd.oai.openapi";
        String apiId = KeyGenerator.createKey();
        OpenApi api = new OpenApi.Builder().id(apiId).name(name).document(updatedSwagger).putMetadata("Content-Type", specificationContentType).build();
        integration.addResource(new ResourceIdentifier.Builder().id(apiId).kind(Kind.OpenApi).build());
        return new APIIntegration(integration.build(), api);
    }

    @Override
    public APISummary info(String specification, APIValidationContext validation) {
        SwaggerModelInfo swaggerInfo = SwaggerHelper.parse(specification, validation);
        Swagger model = swaggerInfo.getModel();
        if (model == null) {
            return new APISummary.Builder().errors(swaggerInfo.getErrors()).warnings(swaggerInfo.getWarnings()).build();
        }
        Map paths = model.getPaths();
        ActionsSummary actionsSummary = SwaggerAPIGenerator.determineSummaryFrom(paths);
        Info info = model.getInfo();
        String title = Optional.ofNullable(info).map(Info::getTitle).orElse("unspecified");
        String description = Optional.ofNullable(info).map(Info::getDescription).orElse("unspecified");
        return new APISummary.Builder().name(title).description(description).actionsSummary(actionsSummary).errors(swaggerInfo.getErrors()).warnings(swaggerInfo.getWarnings()).putConfiguredProperty("specification", swaggerInfo.getResolvedSpecification()).build();
    }

    @Override
    public Integration updateFlowExcerpts(Integration integration) {
        if (integration == null || !integration.getTags().contains("api-provider")) {
            return integration;
        }
        return new Integration.Builder().createFrom(integration).flows((Iterable)integration.getFlows().stream().map(this::flowWithExcerpts).collect(Collectors.toList())).build();
    }

    protected String decodeHttpReturnCode(List<Step> steps, String code) {
        if (code == null || steps.isEmpty()) {
            return code;
        }
        Step lastStep = steps.get(steps.size() - 1);
        Optional lastAction = lastStep.getAction();
        if (!lastAction.isPresent()) {
            return code;
        }
        Optional httpCodeDescription = lastAction.flatMap(a -> Optional.ofNullable((ConfigurationProperty)a.getProperties().get(HTTP_RESPONSE_CODE_METADATA_KEY))).flatMap(prop -> prop.getEnum().stream().filter(e -> code.equals(e.getValue())).map(ConfigurationProperty.PropertyValue::getLabel).findFirst());
        return httpCodeDescription.orElse(code);
    }

    protected Flow flowWithExcerpts(Flow flow) {
        List steps = flow.getSteps();
        if (steps == null || steps.isEmpty()) {
            return flow;
        }
        Step last = (Step)steps.get(steps.size() - 1);
        if (last.getConfiguredProperties().containsKey(HTTP_RESPONSE_CODE_METADATA_KEY)) {
            String responseCode = (String)last.getConfiguredProperties().get(HTTP_RESPONSE_CODE_METADATA_KEY);
            String responseDesc = this.decodeHttpReturnCode(steps, responseCode);
            return new Flow.Builder().createFrom(flow).putMetadata(EXCERPT_METADATA_KEY, responseDesc).build();
        }
        if (flow.getMetadata(EXCERPT_METADATA_KEY).isPresent()) {
            HashMap newMetadata = new HashMap(flow.getMetadata());
            newMetadata.remove(EXCERPT_METADATA_KEY);
            return new Flow.Builder().createFrom(flow).metadata(newMetadata).build();
        }
        return flow;
    }

    protected String requireUniqueOperationId(String preferredOperationId, Set<String> alreadyUsedOperationIds) {
        String baseId = preferredOperationId;
        if (baseId == null) {
            baseId = UUID.randomUUID().toString();
        }
        baseId = baseId.replaceAll("[^A-Za-z0-9-_]", "");
        int counter = 0;
        String newId = baseId;
        while (alreadyUsedOperationIds.contains(newId)) {
            newId = baseId + "-" + ++counter;
        }
        return newId;
    }

    static ActionsSummary determineSummaryFrom(Map<String, Path> paths) {
        if (paths == null || paths.isEmpty()) {
            return new ActionsSummary.Builder().build();
        }
        AtomicInteger total = new AtomicInteger(0);
        Map tagCounts = paths.entrySet().stream().flatMap(p -> ((Path)p.getValue()).getOperations().stream()).peek(o -> total.incrementAndGet()).flatMap(o -> SwaggerHelper.sanitizeTags(o.getTags())).collect(Collectors.groupingBy(Function.identity(), Collectors.reducing(0, e -> 1, Integer::sum)));
        return new ActionsSummary.Builder().totalActions(total.intValue()).actionCountByTags(tagCounts).build();
    }

    private static /* synthetic */ String lambda$generateIntegration$3(String m, String p) {
        return "Receiving " + m + " request on " + p;
    }
}

