/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.swagger.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.models.parameters.SerializableParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.syndesis.common.util.Json;
import io.syndesis.server.api.generator.swagger.util.DummyStreamHandler;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import me.andrz.jackson.JsonContext;
import me.andrz.jackson.JsonReferenceException;
import me.andrz.jackson.JsonReferenceProcessor;
import org.apache.commons.lang3.StringUtils;

public final class JsonSchemaHelper {
    private static final String JSON_SCHEMA_URI = "http://json-schema.org/schema#";

    private JsonSchemaHelper() {
    }

    public static ObjectNode createJsonSchema(String title, ObjectNode schema) {
        ObjectNode schemaNode = JsonSchemaHelper.newJsonObjectSchema();
        if (title != null) {
            schemaNode.put("title", title);
        }
        schemaNode.setAll(schema);
        return schemaNode;
    }

    public static String determineSchemaReference(Property schema) {
        if (schema instanceof RefProperty) {
            return ((RefProperty)schema).get$ref();
        }
        if (schema instanceof ArrayProperty) {
            Property property = ((ArrayProperty)schema).getItems();
            return JsonSchemaHelper.determineSchemaReference(property);
        }
        throw new IllegalArgumentException("Only references to schemas are supported");
    }

    public static String javaTypeFor(SerializableParameter parameter) {
        String type = parameter.getType();
        if ("array".equals(type)) {
            Property items = parameter.getItems();
            String elementType = items.getType();
            String elementFormat = items.getFormat();
            return JsonSchemaHelper.javaTypeFor(elementType, elementFormat) + "[]";
        }
        String format = parameter.getFormat();
        return JsonSchemaHelper.javaTypeFor(type, format);
    }

    public static ObjectNode newJsonObjectSchema() {
        ObjectNode schema = JsonNodeFactory.instance.objectNode();
        schema.put("$schema", JSON_SCHEMA_URI);
        schema.put("type", "object");
        return schema;
    }

    public static ObjectNode parseJsonSchema(String schema) {
        try {
            return (ObjectNode)Json.reader().readTree(schema);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to parse given JSON schema: " + StringUtils.abbreviate((String)schema, (int)100), e);
        }
    }

    public static ObjectNode resolvableNodeForSpecification(final ObjectNode json) {
        ObjectNode resolved;
        try {
            JsonReferenceProcessor referenceProcessor = new JsonReferenceProcessor();
            resolved = (ObjectNode)referenceProcessor.process(new JsonContext(DummyStreamHandler.DUMMY_URL){

                public JsonNode getDocument() throws IOException {
                    return json;
                }
            }, (JsonNode)json);
            JsonSchemaHelper.sanitize((JsonNode)resolved);
        }
        catch (IOException | JsonReferenceException e) {
            throw new IllegalStateException("Unable to process JSON references", e);
        }
        return resolved;
    }

    public static ObjectNode resolveSchemaForReference(ObjectNode json, String title, String reference) {
        ObjectNode dereferenced = (ObjectNode)json.at(reference.substring(1));
        return JsonSchemaHelper.createJsonSchema(title, dereferenced);
    }

    public static String serializeJson(JsonNode schemaNode) {
        try {
            return Json.writer().writeValueAsString((Object)schemaNode);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Unable to serialize JSON schema", e);
        }
    }

    public static JsonNode sanitize(JsonNode node) {
        if (node == null) {
            return null;
        }
        if (node.isArray()) {
            ArrayNode arrayNode = (ArrayNode)node;
            Iterator elements = arrayNode.elements();
            elements.forEachRemaining(JsonSchemaHelper::sanitize);
        } else if (node.isObject()) {
            ObjectNode objectNode = (ObjectNode)node;
            JsonNode formatNode = node.get("format");
            if (formatNode != null && formatNode.isTextual() && !JsonSchemaHelper.isKnownFormat(formatNode.asText())) {
                objectNode.remove("format");
            }
            Iterator fields = objectNode.fields();
            fields.forEachRemaining(field -> JsonSchemaHelper.sanitize((JsonNode)field.getValue()));
        }
        return node;
    }

    public static boolean isKnownFormat(String format) {
        return format != null && Stream.of(JsonValueFormat.values()).map(Objects::toString).anyMatch(jsonSchemaFormat -> jsonSchemaFormat.equals(format));
    }

    static String javaTypeFor(String type, String format) {
        switch (type) {
            case "string": {
                return String.class.getName();
            }
            case "number": {
                if ("float".equals(format)) {
                    return Float.class.getName();
                }
                return Double.class.getName();
            }
            case "integer": {
                if ("int64".equals(format)) {
                    return Long.class.getName();
                }
                return Integer.class.getName();
            }
            case "boolean": {
                return Boolean.class.getName();
            }
            case "file": {
                return File.class.getName();
            }
        }
        throw new IllegalArgumentException("Given parameter is of unknown type/format: " + type + "/" + format);
    }
}

