/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.swagger;

import io.syndesis.common.model.DataShape;
import io.syndesis.common.model.DataShapeKinds;
import io.syndesis.common.model.action.ConnectorAction;
import io.syndesis.common.model.connection.Connector;
import io.syndesis.common.model.connection.ConnectorSettings;
import io.syndesis.common.util.Json;
import io.syndesis.server.api.generator.ConnectorGenerator;
import io.syndesis.server.api.generator.swagger.AbstractSwaggerConnectorTest;
import io.syndesis.server.api.generator.swagger.TestHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.OptionalAssert;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

abstract class BaseSwaggerGeneratorExampleTest
extends AbstractSwaggerConnectorTest {
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    final Connector expected;
    final String specification;

    public BaseSwaggerGeneratorExampleTest(String connectorQualifier, String name) throws IOException {
        this.specification = TestHelper.resource("/swagger/" + name + ".swagger.json", "/swagger/" + name + ".swagger.yaml");
        this.expected = (Connector)Json.reader().forType(Connector.class).readValue(TestHelper.resource("/swagger/" + name + "." + connectorQualifier + "_connector.json"));
    }

    public void shouldGenerateAsExpected() throws IOException {
        ConnectorSettings connectorSettings = new ConnectorSettings.Builder().putConfiguredProperty("specification", this.specification).build();
        Connector generated = this.generator().generate(SWAGGER_TEMPLATE, connectorSettings);
        Map generatedConfiguredProperties = generated.getConfiguredProperties();
        String generatedSpecification = (String)generatedConfiguredProperties.get("specification");
        Map expectedConfiguredProperties = this.expected.getConfiguredProperties();
        String expectedSpecification = (String)expectedConfiguredProperties.get("specification");
        Assertions.assertThat((String)TestHelper.reformatJson(generatedSpecification)).isEqualTo((Object)TestHelper.reformatJson(expectedSpecification));
        Assertions.assertThat(BaseSwaggerGeneratorExampleTest.without(generatedConfiguredProperties, "specification")).containsAllEntriesOf(BaseSwaggerGeneratorExampleTest.without(expectedConfiguredProperties, "specification"));
        ((IterableAssert)Assertions.assertThat(generated.getProperties().keySet()).as("Expecting the same properties to be generated", new Object[0])).containsOnlyElementsOf(this.expected.getProperties().keySet());
        Assertions.assertThat((Map)generated.getProperties()).containsAllEntriesOf(this.expected.getProperties());
        Assertions.assertThat((Object)generated).isEqualToIgnoringGivenFields((Object)this.expected, new String[]{"id", "icon", "properties", "configuredProperties", "actions"});
        Assertions.assertThat((String)generated.getIcon()).startsWith((CharSequence)"data:image");
        Assertions.assertThat((List)generated.getActions()).hasSameSizeAs((Iterable)this.expected.getActions());
        for (ConnectorAction expectedAction : this.expected.getActions()) {
            String actionId = ((String)expectedAction.getId().get()).replace("_id_", (CharSequence)generated.getId().get());
            Optional maybeGeneratedAction = generated.findActionById(actionId);
            ((OptionalAssert)Assertions.assertThat((Optional)maybeGeneratedAction).as("No action with id: " + actionId + " was generated", new Object[0])).isPresent();
            ConnectorAction generatedAction = (ConnectorAction)maybeGeneratedAction.get();
            ((ObjectAssert)Assertions.assertThat((Object)generatedAction).as("Difference found for action: " + actionId, new Object[0])).isEqualToIgnoringGivenFields((Object)expectedAction, new String[]{"id", "descriptor"});
            ((ListAssert)Assertions.assertThat((List)generatedAction.getDescriptor().getPropertyDefinitionSteps()).as("Generated and expected action definition property definition steps for action with id: " + actionId + " differs", new Object[0])).isEqualTo((Object)expectedAction.getDescriptor().getPropertyDefinitionSteps());
            if (expectedAction.getDescriptor().getInputDataShape().isPresent()) {
                DataShape generatedInputDataShape = (DataShape)generatedAction.getDescriptor().getInputDataShape().get();
                DataShape expectedInputDataShape = (DataShape)expectedAction.getDescriptor().getInputDataShape().get();
                ((ObjectAssert)Assertions.assertThat((Object)generatedInputDataShape).as("Generated and expected input data shape for action with id: " + actionId + " differs", new Object[0])).isEqualToIgnoringGivenFields((Object)expectedInputDataShape, new String[]{"specification"});
                if (generatedInputDataShape.getKind() == DataShapeKinds.JSON_SCHEMA) {
                    ((AbstractStringAssert)Assertions.assertThat((String)TestHelper.reformatJson(generatedInputDataShape.getSpecification())).as("Input data shape specification for action with id: " + actionId + " differ", new Object[0])).isEqualTo((Object)TestHelper.reformatJson(expectedInputDataShape.getSpecification()));
                } else {
                    ((AbstractStringAssert)Assertions.assertThat((String)BaseSwaggerGeneratorExampleTest.c14Xml(generatedInputDataShape.getSpecification())).as("Input data shape specification for action with id: " + actionId + " differ", new Object[0])).isEqualTo((Object)BaseSwaggerGeneratorExampleTest.c14Xml(expectedInputDataShape.getSpecification()));
                }
            }
            if (!expectedAction.getDescriptor().getOutputDataShape().isPresent()) continue;
            DataShape generatedOutputDataShape = (DataShape)generatedAction.getDescriptor().getOutputDataShape().get();
            DataShape expectedOutputDataShape = (DataShape)expectedAction.getDescriptor().getOutputDataShape().get();
            ((ObjectAssert)Assertions.assertThat((Object)generatedOutputDataShape).as("Generated and expected output data shape for action with id: " + actionId + " differs", new Object[0])).isEqualToIgnoringGivenFields((Object)expectedOutputDataShape, new String[]{"specification"});
            if (generatedOutputDataShape.getKind() == DataShapeKinds.JSON_SCHEMA) {
                ((AbstractStringAssert)Assertions.assertThat((String)TestHelper.reformatJson(generatedOutputDataShape.getSpecification())).as("Output data shape specification for action with id: " + actionId + " differ", new Object[0])).isEqualTo((Object)TestHelper.reformatJson(expectedOutputDataShape.getSpecification()));
                continue;
            }
            ((AbstractStringAssert)Assertions.assertThat((String)BaseSwaggerGeneratorExampleTest.c14Xml(generatedOutputDataShape.getSpecification())).as("Output data shape specification for action with id: " + actionId + " differ", new Object[0])).isEqualTo((Object)BaseSwaggerGeneratorExampleTest.c14Xml(expectedOutputDataShape.getSpecification()));
        }
    }

    abstract ConnectorGenerator generator();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String c14Xml(String xml) {
        if (xml == null) {
            return null;
        }
        try {
            DocumentBuilder documentBuilder = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
            TransformService transformation = TransformService.getInstance("http://www.w3.org/2001/10/xml-exc-c14n#WithComments", "DOM");
            transformation.init(null);
            NodeList allElements = document.getElementsByTagName("*");
            ArrayList<Node> elements = new ArrayList<Node>();
            for (int i = 0; i < allElements.getLength(); ++i) {
                elements.add(allElements.item(i));
            }
            OctetStreamData data = (OctetStreamData)transformation.transform(elements::iterator, null);
            try (InputStream stream = data.getOctetStream();){
                byte[] buffy = new byte[stream.available()];
                stream.read(buffy);
                String string = new String(buffy, StandardCharsets.UTF_8);
                return string;
            }
        }
        catch (IOException | GeneralSecurityException | TransformException | ParserConfigurationException | SAXException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Map<String, String> without(Map<String, String> map, String key) {
        HashMap<String, String> ret = new HashMap<String, String>(map);
        ret.remove(key);
        return ret;
    }
}

