/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.swagger;

import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.auth.ApiKeyAuthDefinition;
import io.swagger.models.auth.BasicAuthDefinition;
import io.swagger.models.auth.OAuth2Definition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.syndesis.common.model.connection.ConfigurationProperty;
import io.syndesis.common.model.connection.ConnectorSettings;
import io.syndesis.server.api.generator.swagger.PropertyGenerators;
import java.net.URI;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class PropertyGeneratorsTest {
    @Test
    public void shouldConsiderOnlyAuthorizationCodeOAuthFlows() {
        Swagger swagger = new Swagger().securityDefinition("oauth-username-password", (SecuritySchemeDefinition)new OAuth2Definition().password("https://api.example.com/token")).securityDefinition("oauth-implicit", (SecuritySchemeDefinition)new OAuth2Definition().implicit("https://api.example.com/authz")).securityDefinition("oauth-authorization-code", (SecuritySchemeDefinition)new OAuth2Definition().accessCode("https://api.example.com/token", "https://api.example.com/authz")).securityDefinition("basic-auth", (SecuritySchemeDefinition)new BasicAuthDefinition()).securityDefinition("api-key", (SecuritySchemeDefinition)new ApiKeyAuthDefinition());
        ConfigurationProperty template = new ConfigurationProperty.Builder().build();
        ConnectorSettings settings = new ConnectorSettings.Builder().build();
        Optional authenticationTypes = PropertyGenerators.authenticationType.propertyGenerator().generate(swagger, template, settings);
        Assertions.assertThat((Optional)authenticationTypes).contains((Object)new ConfigurationProperty.Builder().addEnum(ConfigurationProperty.PropertyValue.Builder.of((String)"oauth2:oauth-authorization-code", (String)"OAuth 2.0 - oauth-authorization-code")).addEnum(ConfigurationProperty.PropertyValue.Builder.of((String)"basic:basic-auth", (String)"HTTP Basic Authentication - basic-auth")).addEnum(ConfigurationProperty.PropertyValue.Builder.of((String)"apiKey:api-key", (String)"API Key - api-key")).build());
    }

    @Test
    public void shouldCreateHostUri() {
        Assertions.assertThat((String)PropertyGenerators.createHostUri((String)"scheme", (String)"host", (int)-1)).isEqualTo((Object)"scheme://host");
        Assertions.assertThat((String)PropertyGenerators.createHostUri((String)"scheme", (String)"host", (int)8080)).isEqualTo((Object)"scheme://host:8080");
    }

    @Test
    public void shouldDefaultToNoSecurityIfNoSupportedSecurityDefinitionsFound() {
        Swagger swagger = new Swagger().securityDefinition("oauth-username-password", (SecuritySchemeDefinition)new OAuth2Definition().password("https://api.example.com/token")).securityDefinition("oauth-implicit", (SecuritySchemeDefinition)new OAuth2Definition().implicit("https://api.example.com/authz"));
        ConfigurationProperty template = new ConfigurationProperty.Builder().build();
        ConnectorSettings settings = new ConnectorSettings.Builder().build();
        Optional authenticationTypes = PropertyGenerators.authenticationType.propertyGenerator().generate(swagger, template, settings);
        Assertions.assertThat((Optional)authenticationTypes).contains((Object)new ConfigurationProperty.Builder().defaultValue("none").addEnum(ConfigurationProperty.PropertyValue.Builder.of((String)"none", (String)"No Security")).build());
    }

    @Test
    public void shouldDetermineFromHostsContainingPorts() {
        Assertions.assertThat((String)PropertyGenerators.determineHost((Swagger)new Swagger().host("54.152.43.92:8080").scheme(Scheme.HTTPS))).isEqualTo((Object)"https://54.152.43.92:8080");
    }

    @Test
    public void shouldDetermineHostFromSpecification() {
        Assertions.assertThat((String)PropertyGenerators.determineHost((Swagger)new Swagger().host("api.example.com").scheme(Scheme.HTTPS))).isEqualTo((Object)"https://api.example.com");
        Assertions.assertThat((String)PropertyGenerators.determineHost((Swagger)new Swagger().host("api.example.com").scheme(Scheme.HTTP).scheme(Scheme.HTTPS))).isEqualTo((Object)"https://api.example.com");
        Assertions.assertThat((String)PropertyGenerators.determineHost((Swagger)new Swagger().host("api.example.com").scheme(Scheme.HTTP))).isEqualTo((Object)"http://api.example.com");
    }

    @Test
    public void shouldDetermineHostFromSpecificationUrl() {
        URI specificationUrl = URI.create("https://api.example.com/swagger.json");
        Assertions.assertThat((String)PropertyGenerators.determineHost((Swagger)new Swagger().vendorExtension("x-syndesis-swagger-url", (Object)specificationUrl))).isEqualTo((Object)"https://api.example.com");
        Assertions.assertThat((String)PropertyGenerators.determineHost((Swagger)new Swagger().vendorExtension("x-syndesis-swagger-url", (Object)specificationUrl).scheme(Scheme.HTTP))).isEqualTo((Object)"http://api.example.com");
        Assertions.assertThat((String)PropertyGenerators.determineHost((Swagger)new Swagger().vendorExtension("x-syndesis-swagger-url", (Object)specificationUrl).host("api2.example.com").scheme(Scheme.HTTP))).isEqualTo((Object)"http://api2.example.com");
    }

    @Test
    public void shouldDetermineSecurityDefinitionToUseFromTheConfiguredAuthenticationType() {
        BasicAuthDefinition securityDefinition = new BasicAuthDefinition();
        Swagger swagger = new Swagger().securityDefinition("username-password", (SecuritySchemeDefinition)securityDefinition);
        ConnectorSettings settings = new ConnectorSettings.Builder().putConfiguredProperty(PropertyGenerators.authenticationType.name(), "basic:username-password").build();
        Optional got = PropertyGenerators.securityDefinition((Swagger)swagger, (ConnectorSettings)settings, BasicAuthDefinition.class);
        Assertions.assertThat((Optional)got).containsSame((Object)securityDefinition);
    }

    @Test
    public void shouldDetermineSecurityDefinitionToUseFromTheConfiguredAuthenticationTypeWithName() {
        BasicAuthDefinition securityDefinition = new BasicAuthDefinition();
        Swagger swagger = new Swagger().securityDefinition("username-password", (SecuritySchemeDefinition)securityDefinition);
        ConnectorSettings settings = new ConnectorSettings.Builder().putConfiguredProperty(PropertyGenerators.authenticationType.name(), "basic:username-password").build();
        Optional got = PropertyGenerators.securityDefinition((Swagger)swagger, (ConnectorSettings)settings, BasicAuthDefinition.class);
        Assertions.assertThat((Optional)got).containsSame((Object)securityDefinition);
    }

    @Test
    public void shouldReturnNullIfNoHostGivenAnywhere() {
        Assertions.assertThat((String)PropertyGenerators.determineHost((Swagger)new Swagger())).isNull();
        Assertions.assertThat((String)PropertyGenerators.determineHost((Swagger)new Swagger().scheme(Scheme.HTTP))).isNull();
        Assertions.assertThat((String)PropertyGenerators.determineHost((Swagger)new Swagger().host("host"))).isNull();
    }

    @Test
    public void shouldReturnNullIfNoHttpSchemesFound() {
        Assertions.assertThat((String)PropertyGenerators.determineHost((Swagger)new Swagger().scheme(Scheme.WS).scheme(Scheme.WSS))).isNull();
    }

    @Test
    public void shouldTakeOnlyAuthorizationCodeOAuthFlowUrls() {
        Swagger swagger = new Swagger().securityDefinition("oauth-username-password", (SecuritySchemeDefinition)new OAuth2Definition().password("https://wrong.example.com/token")).securityDefinition("oauth-implicit", (SecuritySchemeDefinition)new OAuth2Definition().implicit("https://wrong.example.com/authz")).securityDefinition("oauth-authorization-code", (SecuritySchemeDefinition)new OAuth2Definition().accessCode("https://api.example.com/token", "https://api.example.com/authz"));
        ConfigurationProperty template = new ConfigurationProperty.Builder().build();
        ConnectorSettings settings = new ConnectorSettings.Builder().putConfiguredProperty(PropertyGenerators.authenticationType.name(), "oauth2:oauth-authorization-code").build();
        Optional authorizationEndpoint = PropertyGenerators.authorizationEndpoint.propertyGenerator().generate(swagger, template, settings);
        Assertions.assertThat((Optional)authorizationEndpoint).contains((Object)new ConfigurationProperty.Builder().defaultValue("https://api.example.com/token").build());
        Optional tokenEndpoint = PropertyGenerators.tokenEndpoint.propertyGenerator().generate(swagger, template, settings);
        Assertions.assertThat((Optional)tokenEndpoint).contains((Object)new ConfigurationProperty.Builder().defaultValue("https://api.example.com/authz").build());
    }
}

