/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.swagger;

import io.swagger.models.auth.BasicAuthDefinition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.syndesis.common.model.connection.ConfigurationProperty;
import io.syndesis.server.api.generator.swagger.SupportedAuthenticationTypes;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class SupportedAuthenticationTypesTest {
    @Test
    public void shouldDetermineValueFromConfiguredPropertyValue() {
        Assertions.assertThat((Comparable)SupportedAuthenticationTypes.fromConfiguredPropertyValue((String)"basic")).isEqualTo((Object)SupportedAuthenticationTypes.basic);
        Assertions.assertThat((Comparable)SupportedAuthenticationTypes.fromConfiguredPropertyValue((String)"basic:name")).isEqualTo((Object)SupportedAuthenticationTypes.basic);
        Assertions.assertThat((Comparable)SupportedAuthenticationTypes.fromConfiguredPropertyValue((String)"basic:")).isEqualTo((Object)SupportedAuthenticationTypes.basic);
    }

    @Test
    public void shouldDetermineValueFromSecurityDefinitionValue() {
        Assertions.assertThat((Comparable)SupportedAuthenticationTypes.fromConfiguredPropertyValue((String)"basic")).isEqualTo((Object)SupportedAuthenticationTypes.basic);
    }

    @Test
    public void shouldGenerateLabelsWithDescription() {
        BasicAuthDefinition withDescription = new BasicAuthDefinition();
        withDescription.setDescription("description");
        Assertions.assertThat((Object)SupportedAuthenticationTypes.asPropertyValue((String)"basic_auth", (SecuritySchemeDefinition)withDescription)).isEqualTo((Object)new ConfigurationProperty.PropertyValue.Builder().createFrom(SupportedAuthenticationTypes.basic.propertyValue).label("HTTP Basic Authentication - basic_auth (description)").value("basic:basic_auth").build());
    }

    @Test
    public void shouldGenerateLabelsWithoutDescription() {
        Assertions.assertThat((Object)SupportedAuthenticationTypes.asPropertyValue((String)"basic_auth", (SecuritySchemeDefinition)new BasicAuthDefinition())).isEqualTo((Object)new ConfigurationProperty.PropertyValue.Builder().createFrom(SupportedAuthenticationTypes.basic.propertyValue).label("HTTP Basic Authentication - basic_auth").value("basic:basic_auth").build());
    }
}

