/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.swagger;

import io.syndesis.common.model.connection.Connector;
import io.syndesis.common.util.Json;
import io.syndesis.server.api.generator.APIValidationContext;
import io.syndesis.server.api.generator.ConnectorGenerator;
import io.syndesis.server.api.generator.swagger.BaseSwaggerGeneratorExampleTest;
import io.syndesis.server.api.generator.swagger.SwaggerModelInfo;
import io.syndesis.server.api.generator.swagger.SwaggerUnifiedShapeConnectorGenerator;
import io.syndesis.server.api.generator.swagger.util.SwaggerHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SwaggerUnifiedShapeGeneratorExampleTests
extends BaseSwaggerGeneratorExampleTest {
    public SwaggerUnifiedShapeGeneratorExampleTests(String name) throws IOException {
        super("unified", name);
    }

    @Override
    @Test
    public void shouldGenerateAsExpected() throws IOException {
        super.shouldGenerateAsExpected();
    }

    @Test
    public void specificationsShouldNotContainErrors() {
        SwaggerModelInfo info = SwaggerHelper.parse((String)this.specification, (APIValidationContext)APIValidationContext.CONSUMED_API);
        Assertions.assertThat((List)info.getErrors()).isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    ConnectorGenerator generator() {
        try (InputStream stream = SwaggerUnifiedShapeGeneratorExampleTests.class.getResourceAsStream("/META-INF/syndesis/connector/rest-swagger.json");){
            Connector restSwagger = (Connector)Json.readFromStream((InputStream)stream, Connector.class);
            AtomicInteger cnt = new AtomicInteger();
            SwaggerUnifiedShapeConnectorGenerator swaggerUnifiedShapeConnectorGenerator = new SwaggerUnifiedShapeConnectorGenerator(restSwagger, () -> "operation-" + cnt.getAndIncrement());
            return swaggerUnifiedShapeConnectorGenerator;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Parameterized.Parameters(name="{0}")
    public static Iterable<String> parameters() {
        return Arrays.asList("reverb", "petstore", "petstore_xml", "basic_auth", "todo", "complex_xml", "kie-server", "machine_history", "damage_service");
    }
}

