/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.swagger;

import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.RefParameter;
import io.syndesis.common.model.Violation;
import io.syndesis.server.api.generator.swagger.SwaggerModelInfo;
import io.syndesis.server.api.generator.swagger.SyndesisSwaggerValidationRules;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class SyndesisSwaggerValidationRulesTest {
    @Test
    public void cyclicSchemaReferencesValidationShouldOperateOnParsedModel() {
        SwaggerModelInfo info = new SwaggerModelInfo.Builder().build();
        SwaggerModelInfo validated = SyndesisSwaggerValidationRules.validateCyclicReferences((SwaggerModelInfo)info);
        Assertions.assertThat((Object)validated).isSameAs((Object)info);
    }

    @Test
    public void shouldNotGenerateErrorWhenOperationsArePresent() {
        Swagger swagger = new Swagger().path("/test", new Path().get(new Operation()));
        SwaggerModelInfo info = new SwaggerModelInfo.Builder().model(swagger).build();
        SwaggerModelInfo validated = SyndesisSwaggerValidationRules.validateOperationsGiven((SwaggerModelInfo)info);
        List errors = validated.getErrors();
        Assertions.assertThat((List)errors).isEmpty();
    }

    @Test
    public void shouldNotReportIssuesForNonCyclicSchemaReferences() {
        Swagger swagger = new Swagger();
        swagger.path("/api", new Path().post(new Operation().parameter((Parameter)new RefParameter("#/definitions/Request")).response(200, new Response().responseSchema((Model)new RefModel("#/definitions/Response")))));
        SwaggerModelInfo info = new SwaggerModelInfo.Builder().model(swagger).build();
        SwaggerModelInfo validated = SyndesisSwaggerValidationRules.validateCyclicReferences((SwaggerModelInfo)info);
        Assertions.assertThat((Object)validated).isEqualTo((Object)info);
    }

    @Test
    public void shouldNotReportIssuesForTrivialSwagger() {
        Swagger swagger = new Swagger();
        SwaggerModelInfo info = new SwaggerModelInfo.Builder().model(swagger).build();
        SwaggerModelInfo validated = SyndesisSwaggerValidationRules.validateCyclicReferences((SwaggerModelInfo)info);
        Assertions.assertThat((Object)validated).isEqualTo((Object)info);
    }

    @Test
    public void shouldReportIssuesForCyclicSchemaReferences() {
        Swagger swagger = new Swagger().path("/api", new Path().post(new Operation().parameter((Parameter)new RefParameter("#/definitions/Request"))));
        swagger.addDefinition("Request", (Model)new RefModel("#definitions/Request"));
        SwaggerModelInfo info = new SwaggerModelInfo.Builder().model(swagger).build();
        SwaggerModelInfo validated = SyndesisSwaggerValidationRules.validateCyclicReferences((SwaggerModelInfo)info);
        Assertions.assertThat((List)validated.getErrors()).containsOnly((Object[])new Violation[]{new Violation.Builder().error("cyclic-schema").message("Cyclic references are not suported").build()});
    }

    @Test
    public void shouldValidateOperationsArePresent() {
        Swagger swagger = new Swagger().path("/test", new Path());
        SwaggerModelInfo info = new SwaggerModelInfo.Builder().model(swagger).build();
        SwaggerModelInfo validated = SyndesisSwaggerValidationRules.validateOperationsGiven((SwaggerModelInfo)info);
        List errors = validated.getErrors();
        Assertions.assertThat((List)errors).containsExactly((Object[])new Violation[]{new Violation.Builder().property("").error("missing-operations").message("No operations defined").build()});
    }

    @Test
    public void shouldValidateOperationUniqueness() {
        Swagger swagger = new Swagger().path("/path", new Path().get(new Operation().operationId("o1")).post(new Operation().operationId("o2"))).path("/other", new Path().patch(new Operation().operationId("o2")).put(new Operation().operationId("o3"))).path("/more", new Path().options(new Operation().operationId("o4")).delete(new Operation().operationId("o3")));
        SwaggerModelInfo info = new SwaggerModelInfo.Builder().model(swagger).build();
        SwaggerModelInfo validated = SyndesisSwaggerValidationRules.validateUniqueOperationIds((SwaggerModelInfo)info);
        List warnings = validated.getWarnings();
        Assertions.assertThat((List)warnings).hasSize(1);
        Violation nonUniqueWarning = (Violation)warnings.get(0);
        Assertions.assertThat((String)nonUniqueWarning.error()).isEqualTo((Object)"non-unique-operation-ids");
        Assertions.assertThat((String)nonUniqueWarning.property()).isNull();
        Assertions.assertThat((String)nonUniqueWarning.message()).isEqualTo((Object)"Found operations with non unique operationIds: o2, o3");
    }

    @Test
    public void shouldValidatePathsArePresent() {
        Swagger swagger = new Swagger();
        SwaggerModelInfo info = new SwaggerModelInfo.Builder().model(swagger).build();
        SwaggerModelInfo validated = SyndesisSwaggerValidationRules.validateOperationsGiven((SwaggerModelInfo)info);
        List errors = validated.getErrors();
        Assertions.assertThat((List)errors).containsExactly((Object[])new Violation[]{new Violation.Builder().property("paths").error("missing-paths").message("No paths defined").build()});
    }
}

