/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.swagger;

import io.syndesis.server.api.generator.swagger.UnifiedDataShapeGenerator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class UnifiedDataShapeGeneratorTest {
    private static final String APPLICATION_JSON = "application/json";
    private static final String APPLICATION_XML = "application/xml";
    @Parameterized.Parameter(value=1)
    public List<String> defaultMimes;
    @Parameterized.Parameter(value=0)
    public String mime;
    @Parameterized.Parameter(value=2)
    public List<String> mimes;
    @Parameterized.Parameter(value=3)
    public boolean outcome;

    @Test
    public void shouldDetermineSupportedMimes() {
        Assertions.assertThat((boolean)UnifiedDataShapeGenerator.supports((String)this.mime, this.defaultMimes, this.mimes)).isEqualTo(this.outcome);
    }

    @Parameterized.Parameters
    public static Iterable<Object[]> parameters() {
        return Arrays.asList({APPLICATION_XML, null, null, false}, {APPLICATION_JSON, null, null, false}, {APPLICATION_XML, Collections.emptyList(), null, false}, {APPLICATION_JSON, Collections.emptyList(), null, false}, {APPLICATION_XML, null, Collections.emptyList(), false}, {APPLICATION_JSON, null, Collections.emptyList(), false}, {APPLICATION_XML, Collections.emptyList(), Collections.emptyList(), false}, {APPLICATION_XML, Collections.emptyList(), Collections.emptyList(), false}, {APPLICATION_JSON, Collections.emptyList(), Collections.emptyList(), false}, {APPLICATION_XML, Collections.emptyList(), Collections.singletonList(APPLICATION_JSON), false}, {APPLICATION_JSON, Collections.emptyList(), Collections.singletonList(APPLICATION_JSON), true}, {APPLICATION_XML, Collections.emptyList(), Collections.singletonList(APPLICATION_XML), true}, {APPLICATION_JSON, Collections.emptyList(), Collections.singletonList(APPLICATION_XML), false}, {APPLICATION_XML, Collections.singletonList(APPLICATION_JSON), Collections.emptyList(), false}, {APPLICATION_JSON, Collections.singletonList(APPLICATION_JSON), Collections.emptyList(), true}, {APPLICATION_XML, Collections.singletonList(APPLICATION_XML), Collections.emptyList(), true}, {APPLICATION_JSON, Collections.singletonList(APPLICATION_XML), Collections.emptyList(), false}, {APPLICATION_XML, Collections.emptyList(), Arrays.asList(APPLICATION_JSON, APPLICATION_XML), true}, {APPLICATION_JSON, Collections.emptyList(), Arrays.asList(APPLICATION_JSON, APPLICATION_XML), true}, {APPLICATION_JSON, Collections.emptyList(), Arrays.asList(APPLICATION_JSON, APPLICATION_XML), true});
    }
}

