/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.swagger;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.syndesis.common.model.DataShape;
import io.syndesis.common.model.DataShapeKinds;
import io.syndesis.common.util.Json;
import io.syndesis.common.util.openapi.OpenApiHelper;
import io.syndesis.server.api.generator.swagger.UnifiedXmlDataShapeGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class UnifiedXmlDataShapeGeneratorRequestShapeTest {
    @Parameterized.Parameter(value=0)
    public HttpMethod operation;
    @Parameterized.Parameter(value=1)
    public String path;
    @Parameterized.Parameter(value=2)
    public String schemaset;
    private final UnifiedXmlDataShapeGenerator generator = new UnifiedXmlDataShapeGenerator();
    private final ObjectNode json;
    private final Swagger swagger;

    public UnifiedXmlDataShapeGeneratorRequestShapeTest() throws IOException {
        String specification;
        try (InputStream in = UnifiedXmlDataShapeGenerator.class.getResourceAsStream("/swagger/petstore.swagger.json");){
            specification = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
        }
        this.json = (ObjectNode)Json.reader().readTree(specification);
        this.swagger = OpenApiHelper.parse((String)specification);
    }

    @Test
    public void shouldGenerateAtlasmapSchemaSetForUpdatePetRequest() throws IOException {
        String expectedSpecification;
        Operation swaggerOperation = (Operation)((Path)this.swagger.getPaths().get(this.path)).getOperationMap().get(this.operation);
        DataShape shape = this.generator.createShapeFromRequest(this.json, this.swagger, swaggerOperation);
        SoftAssertions softly = new SoftAssertions();
        softly.assertThat((Comparable)shape.getKind()).isEqualTo((Object)DataShapeKinds.XML_SCHEMA);
        softly.assertThat(shape.getName()).isEqualTo((Object)"Request");
        softly.assertThat(shape.getDescription()).isEqualTo((Object)"API request payload");
        softly.assertThat(shape.getExemplar()).isNotPresent();
        softly.assertAll();
        try (InputStream in = UnifiedXmlDataShapeGenerator.class.getResourceAsStream("/swagger/" + this.schemaset);){
            expectedSpecification = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
        }
        String specification = shape.getSpecification();
        Assertions.assertThat((String)specification).isXmlEqualTo((CharSequence)expectedSpecification);
    }

    @Parameterized.Parameters
    public static Iterable<Object[]> data() {
        return Arrays.asList({HttpMethod.PUT, "/pet", "petstore.update-pet.schemaset.xml"}, {HttpMethod.POST, "/pet/{petId}", "petstore.update-pet-with-form.schemaset.xml"});
    }
}

