/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.swagger;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.models.Operation;
import io.swagger.models.Swagger;
import io.syndesis.common.model.DataShape;
import io.syndesis.common.model.DataShapeKinds;
import io.syndesis.common.util.Json;
import io.syndesis.common.util.openapi.OpenApiHelper;
import io.syndesis.server.api.generator.swagger.BaseDataShapeGenerator;
import io.syndesis.server.api.generator.swagger.LocalResolver;
import io.syndesis.server.api.generator.swagger.UnifiedXmlDataShapeGenerator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xmlunit.validation.JAXPValidator;
import org.xmlunit.validation.ValidationProblem;
import org.xmlunit.validation.ValidationResult;
import org.xmlunit.validation.Validator;

@RunWith(value=Parameterized.class)
public class UnifiedXmlDataShapeGeneratorShapeValidityTest {
    private static final Source CACHED_SCHEMA = new Source(){

        @Override
        public String getSystemId() {
            return "cached:schema";
        }

        @Override
        public void setSystemId(String systemId) {
        }
    };
    private static final SchemaFactory SCHEMA_FACTORY = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    private static final Validator VALIDATOR;
    @Parameterized.Parameter(value=0)
    public ObjectNode json;
    @Parameterized.Parameter(value=2)
    public Operation operation;
    @Parameterized.Parameter(value=3)
    public String specification;
    @Parameterized.Parameter(value=1)
    public Swagger swagger;
    private final UnifiedXmlDataShapeGenerator generator = new UnifiedXmlDataShapeGenerator();

    @Test
    public void shouldGenerateValidInputSchemasets() {
        DataShape input = this.generator.createShapeFromRequest(this.json, this.swagger, this.operation);
        if (input.getKind() != DataShapeKinds.XML_SCHEMA) {
            return;
        }
        String inputSpecification = input.getSpecification();
        ValidationResult result = VALIDATOR.validateInstance((Source)UnifiedXmlDataShapeGeneratorShapeValidityTest.source(inputSpecification));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result.isValid()).as("Non valid input XML schemaset was generated for specification: %s, operation: %s, errors: %s", new Object[]{this.specification, this.operation.getOperationId(), StreamSupport.stream(result.getProblems().spliterator(), false).map(ValidationProblem::toString).collect(Collectors.joining("\n"))})).isTrue();
    }

    @Test
    public void shouldGenerateValidOutputSchemasets() throws IOException {
        DataShape output = this.generator.createShapeFromResponse(this.json, this.swagger, this.operation);
        if (output.getKind() != DataShapeKinds.XML_SCHEMA) {
            return;
        }
        Validator validator = UnifiedXmlDataShapeGeneratorShapeValidityTest.createValidator();
        try (InputStream in = UnifiedXmlDataShapeGenerator.class.getResourceAsStream("/swagger/atlas-xml-schemaset-model-v2.xsd");){
            validator.setSchemaSource((Source)new StreamSource(in));
            String outputSpecification = output.getSpecification();
            ValidationResult result = validator.validateInstance((Source)UnifiedXmlDataShapeGeneratorShapeValidityTest.source(outputSpecification));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)result.isValid()).as("Non valid output XML schemaset was generated for specification: %s, operation: %s, errors: %s", new Object[]{this.specification, this.operation.getOperationId(), StreamSupport.stream(result.getProblems().spliterator(), false).map(ValidationProblem::toString).collect(Collectors.joining("\n"))})).isTrue();
        }
    }

    public static Validator createValidator() {
        Schema schema;
        try {
            schema = SCHEMA_FACTORY.newSchema(UnifiedXmlDataShapeGenerator.class.getResource("/swagger/atlas-xml-schemaset-model-v2.xsd"));
        }
        catch (SAXException e) {
            throw new ExceptionInInitializerError(e);
        }
        JAXPValidator validator = new JAXPValidator("http://www.w3.org/2001/XMLSchema", (SchemaFactory)new FixedSchemaValidator(schema));
        validator.setSchemaSource(CACHED_SCHEMA);
        return validator;
    }

    @Parameterized.Parameters
    public static Iterable<Object[]> specifications() {
        List<String> specifications = Collections.singletonList("/swagger/petstore.swagger.json");
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        specifications.forEach(specification -> {
            ObjectNode json;
            String specificationContent;
            try {
                InputStream in = UnifiedXmlDataShapeGenerator.class.getResourceAsStream((String)specification);
                Throwable throwable = null;
                try {
                    specificationContent = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in != null) {
                        UnifiedXmlDataShapeGeneratorShapeValidityTest.$closeResource(throwable, in);
                    }
                }
            }
            catch (IOException e) {
                throw new AssertionError("Unable to load swagger specification in path: " + specification, e);
            }
            try {
                json = (ObjectNode)Json.reader().readTree(specificationContent);
            }
            catch (IOException e) {
                throw new AssertionError("Unable to parse swagger specification in path as JSON: " + specification, e);
            }
            Swagger swagger = OpenApiHelper.parse((String)specificationContent);
            swagger.getPaths().forEach((path, operations) -> operations.getOperationMap().forEach((method, operation) -> {
                Optional bodyParameter = BaseDataShapeGenerator.findBodyParameter((Operation)operation);
                if (!bodyParameter.isPresent()) {
                    return;
                }
                parameters.add(new Object[]{json, swagger, operation, specification});
            }));
        });
        return parameters;
    }

    private static StreamSource source(String xml) {
        return new StreamSource(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
    }

    static {
        SCHEMA_FACTORY.setResourceResolver(new LocalResolver());
        VALIDATOR = UnifiedXmlDataShapeGeneratorShapeValidityTest.createValidator();
    }

    private static final class FixedSchemaValidator
    extends SchemaFactory {
        private final Schema schema;

        public FixedSchemaValidator(Schema schema) {
            this.schema = schema;
        }

        @Override
        public ErrorHandler getErrorHandler() {
            return null;
        }

        @Override
        public LSResourceResolver getResourceResolver() {
            return new LocalResolver();
        }

        @Override
        public boolean isSchemaLanguageSupported(String schemaLanguage) {
            return false;
        }

        @Override
        public Schema newSchema() throws SAXException {
            return this.schema;
        }

        @Override
        public Schema newSchema(Source[] schemas) throws SAXException {
            return this.schema;
        }

        @Override
        public void setErrorHandler(ErrorHandler errorHandler) {
        }

        @Override
        public void setResourceResolver(LSResourceResolver resourceResolver) {
        }
    }
}

