/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.swagger;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.models.Swagger;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.Property;
import io.syndesis.common.util.openapi.OpenApiHelper;
import io.syndesis.server.api.generator.swagger.UnifiedXmlDataShapeGenerator;
import io.syndesis.server.api.generator.swagger.util.XmlSchemaHelper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class UnifiedXmlDataShapeGeneratorTest {
    private static final ObjectMapper MAPPER = OpenApiHelper.mapper();
    private static final Map<String, UnifiedXmlDataShapeGenerator.SchemaPrefixAndElement> NO_MORE_SCHEMAS = null;
    private static final Swagger NO_SWAGGER = null;
    @Parameterized.Parameter(value=3)
    public String arrayElementName;
    @Parameterized.Parameter(value=2)
    public String arrayItemName;
    @Parameterized.Parameter(value=0)
    public String jsonSchemaSnippet;
    @Parameterized.Parameter(value=1)
    public String xmlSchemaSnippet;

    @Test
    public void shouldCreateArrayFromExamples() {
        Map<String, ArrayProperty> namedPropertyMap = UnifiedXmlDataShapeGeneratorTest.propertyFrom(this.jsonSchemaSnippet);
        Map.Entry<String, ArrayProperty> namedProperty = namedPropertyMap.entrySet().iterator().next();
        String propertyName = namedProperty.getKey();
        ArrayProperty array = namedProperty.getValue();
        Document document = DocumentHelper.createDocument();
        Element parent = document.addElement("xsd:sequence", "http://www.w3.org/2001/XMLSchema");
        Assertions.assertThat((String)UnifiedXmlDataShapeGenerator.determineArrayItemName((String)propertyName, (ArrayProperty)array)).isEqualTo((Object)this.arrayItemName);
        Assertions.assertThat((String)UnifiedXmlDataShapeGenerator.determineArrayElementName((String)propertyName, (ArrayProperty)array)).isEqualTo((Object)this.arrayElementName);
        UnifiedXmlDataShapeGenerator.defineArrayElement((Property)array, (String)propertyName, (Element)parent, (Swagger)NO_SWAGGER, NO_MORE_SCHEMAS);
        Assertions.assertThat((String)XmlSchemaHelper.serialize((Document)document)).isXmlEqualTo((CharSequence)UnifiedXmlDataShapeGeneratorTest.schema(this.xmlSchemaSnippet));
    }

    @Parameterized.Parameters
    public static Iterable<Object[]> examples() {
        return Arrays.asList({"{\n\"photoUrls\": {\n          \"type\": \"array\",\n          \"xml\": {\n            \"name\": \"photoUrl\",\n            \"wrapped\": true\n          },\n          \"items\": {\n            \"type\": \"string\"\n          }\n        }}", "<xsd:element name=\"photoUrl\"><xsd:complexType><xsd:sequence><xsd:element name=\"photoUrl\" minOccurs=\"0\" maxOccurs=\"unbounded\" type=\"xsd:string\"/></xsd:sequence></xsd:complexType></xsd:element>", "photoUrl", "photoUrl"}, {"{\n  \"animals\": {\n    \"type\": \"array\",\n    \"items\": {\n      \"type\": \"string\",\n      \"xml\": {\n        \"name\": \"animal\"\n      }\n    }\n  }\n}", "<xsd:element name=\"animal\" minOccurs=\"0\" maxOccurs=\"unbounded\" type=\"xsd:string\"/>", "animal", null}, {"{\n  \"animals\": {\n    \"type\": \"array\",\n    \"items\": {\n      \"type\": \"string\",\n      \"xml\": {\n        \"name\": \"animal\"\n      }\n    },\n    \"xml\": {\n      \"name\": \"aliens\"\n    }\n  }\n}", "<xsd:element name=\"animal\" minOccurs=\"0\" maxOccurs=\"unbounded\" type=\"xsd:string\"/>", "animal", null}, {"{\n  \"animals\": {\n    \"type\": \"array\",\n    \"items\": {\n      \"type\": \"string\"\n    },\n    \"xml\": {\n      \"wrapped\": true\n    }\n  }\n}", "<xsd:element name=\"animals\"><xsd:complexType><xsd:sequence><xsd:element name=\"animals\" minOccurs=\"0\" maxOccurs=\"unbounded\" type=\"xsd:string\"/></xsd:sequence></xsd:complexType></xsd:element>", "animals", "animals"});
    }

    private static Map<String, ArrayProperty> propertyFrom(String json) {
        try {
            ObjectNode object = (ObjectNode)MAPPER.readTree(json);
            String propertyName = (String)object.fieldNames().next();
            JsonNode node = (JsonNode)object.elements().next();
            ArrayProperty array = (ArrayProperty)MAPPER.readerFor(Property.class).readValue(node);
            return Collections.singletonMap(propertyName, array);
        }
        catch (IOException e) {
            throw new AssertionError("Unable to deserialize given parameter", e);
        }
    }

    private static String schema(String xml) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xsd:sequence xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">" + xml + "</xsd:sequence>";
    }
}

