/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.api.generator.util;

import io.syndesis.server.api.generator.util.IconGenerator;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.assertj.core.api.Assertions;
import org.junit.Ignore;
import org.junit.Test;

public class IconGeneratorTest {
    private static final String PREFIX = "data:image/svg+xml,%3Csvg";

    @Test
    @Ignore(value="Generates test.html for visual inspection")
    public void generateTestHtml() throws IOException {
        try (PrintStream out = new PrintStream(new FileOutputStream("test.html"));){
            out.println("<html><body>");
            for (int letter = 65; letter <= 90; ++letter) {
                String letterString = String.valueOf((char)letter);
                String icon = IconGenerator.generate((String)"swagger-connector-template", (String)letterString);
                out.println("<br/>");
                out.println("<img src=\"" + icon + "\" /> (" + icon.length() + ")");
            }
        }
    }

    @Test
    public void shouldGenerateIcon() {
        for (int letter = 65; letter <= 90; ++letter) {
            String letterString = String.valueOf((char)letter);
            String icon = IconGenerator.generate((String)"swagger-connector-template", (String)letterString);
            Assertions.assertThat((String)icon).startsWith((CharSequence)PREFIX);
            Assertions.assertThat((String)icon).matches((CharSequence)".*circle.*%20style%3D%22fill%3A%23fff.*");
            Assertions.assertThat((String)icon).matches((CharSequence)".*path.*%20style%3D%22fill%3A%23fff.*");
        }
    }
}

