/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.logging.jsondb.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.syndesis.common.util.Json;
import io.syndesis.common.util.KeyGenerator;
import io.syndesis.server.endpoint.v1.handler.activity.Activity;
import io.syndesis.server.endpoint.v1.handler.activity.ActivityStep;
import io.syndesis.server.endpoint.v1.handler.activity.ActivityTrackingService;
import io.syndesis.server.jsondb.GetOptions;
import io.syndesis.server.jsondb.JsonDB;
import io.syndesis.server.logging.jsondb.controller.ActivityTrackingController;
import io.syndesis.server.logging.jsondb.service.JsonNodeSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"endpoints.dblogging.enabled"}, havingValue="true", matchIfMissing=true)
public class DBActivityTrackingService
implements ActivityTrackingService {
    private static final Logger LOG = LoggerFactory.getLogger(ActivityTrackingController.class);
    private static final Set<String> EVENT_FIELDS_SKIP_LIST = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("id", "at", "logts")));
    private final JsonDB jsondb;

    public DBActivityTrackingService(JsonDB jsondb) {
        this.jsondb = jsondb;
    }

    public List<Activity> getActivities(String integrationId, String from, Integer requestedLimit) throws IOException {
        GetOptions options;
        byte[] data;
        String path = "/activity/exchanges/" + integrationId;
        int limit = 10;
        if (requestedLimit != null) {
            limit = requestedLimit;
        }
        if (limit > 1000) {
            limit = 1000;
        }
        if ((data = this.jsondb.getAsByteArray(path, options = new GetOptions().order(GetOptions.Order.DESC).startAfter(from).limitToFirst(Integer.valueOf(limit)))) == null) {
            return new ArrayList<Activity>();
        }
        return this.toActivityList(Json.reader().readTree((InputStream)new ByteArrayInputStream(data)));
    }

    private List<Activity> toActivityList(JsonNode from) {
        return DBActivityTrackingService.toList(from, j -> {
            Activity rc = new Activity();
            rc.setId(JsonNodeSupport.removeString(j, "id"));
            rc.setAt(JsonNodeSupport.removeLong(j, "at"));
            rc.setFailed(JsonNodeSupport.removeBoolean(j, "failed"));
            rc.setPod(JsonNodeSupport.removeString(j, "pod"));
            rc.setStatus(JsonNodeSupport.removeString(j, "status"));
            rc.setVer(JsonNodeSupport.removeString(j, "ver"));
            rc.setLogts(JsonNodeSupport.removeString(j, "logts"));
            List<ActivityStep> steps = this.toActivitySteps((ObjectNode)j);
            if (steps != null) {
                Collections.reverse(steps);
                rc.setSteps(steps);
            }
            if (j.size() > 0) {
                rc.setMetadata((JsonNode)j);
            }
            return rc;
        });
    }

    private List<ActivityStep> toActivitySteps(ObjectNode j) {
        ObjectNode fromSteps = (ObjectNode)j.remove("steps");
        return DBActivityTrackingService.toList((JsonNode)fromSteps, fromStepEvents -> {
            ActivityStep toStep = new ActivityStep();
            toStep.setId(JsonNodeSupport.removeString(fromStepEvents, "id"));
            fromStepEvents.remove("at");
            toStep.setEvents(DBActivityTrackingService.toList((JsonNode)fromStepEvents, fromStepEvent -> {
                String message;
                String failure;
                Long duration;
                Long at = JsonNodeSupport.getLong((JsonNode)fromStepEvent, "at");
                if (at != null && toStep.getAt() == null) {
                    toStep.setAt(at);
                }
                if ((duration = JsonNodeSupport.removeLong(fromStepEvent, "duration")) != null) {
                    toStep.setDuration(duration);
                }
                if ((failure = JsonNodeSupport.removeString(fromStepEvent, "failure")) != null) {
                    toStep.setFailure(failure);
                }
                if ((message = JsonNodeSupport.getString((JsonNode)fromStepEvent, "message")) != null) {
                    toStep.addMessage(message);
                }
                if (EVENT_FIELDS_SKIP_LIST.equals(JsonNodeSupport.fieldNames((JsonNode)fromStepEvent))) {
                    return null;
                }
                return fromStepEvent;
            }));
            if (toStep.getMessages() != null) {
                Collections.reverse(toStep.getMessages());
            }
            return toStep;
        });
    }

    private static <T> List<T> toList(JsonNode map, Function<ObjectNode, T> converter) {
        if (map == null) {
            return null;
        }
        ArrayList<T> rc = new ArrayList<T>();
        Iterator i = map.fields();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            try {
                T apply;
                ObjectNode to = (ObjectNode)entry.getValue();
                to.put("id", (String)entry.getKey());
                try {
                    to.put("at", KeyGenerator.getKeyTimeMillis((String)((String)entry.getKey())));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if ((apply = converter.apply(to)) == null) continue;
                rc.add(apply);
            }
            catch (RuntimeException ignored) {
                LOG.debug("Could convert entry: {}", (Object)entry, (Object)ignored);
            }
        }
        return rc;
    }
}

