/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.logging.jsondb.controller;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.internal.PodOperationsImpl;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesSupport {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesSupport.class);
    private final KubernetesClient client;
    private final OkHttpClient okHttpClient;

    public KubernetesSupport(KubernetesClient client) {
        this.client = client;
        this.okHttpClient = this.client == null ? null : HttpClientUtils.createHttpClient((Config)this.client.getConfiguration());
    }

    protected void watchLog(final String podName, final Consumer<InputStream> handler, String sinceTime, final Executor executor) throws IOException {
        try {
            PodOperationsImpl pod = (PodOperationsImpl)this.client.pods().withName(podName);
            StringBuilder url = new StringBuilder().append(pod.getResourceUrl().toString()).append("/log?pretty=false&follow=true&timestamps=true");
            if (sinceTime != null) {
                url.append("&sinceTime=");
            }
            Request request = new Request.Builder().url(new URL(url.toString())).get().build();
            OkHttpClient clone = this.okHttpClient.newBuilder().readTimeout(0L, TimeUnit.MILLISECONDS).build();
            clone.newCall(request).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    LOG.info("Failure occurred getting  controller for pod: {},", (Object)podName, (Object)e);
                    handler.accept(null);
                }

                public void onResponse(Call call, Response response) throws IOException {
                    executor.execute(() -> {
                        try {
                            if (response.code() == 200) {
                                handler.accept(response.body().byteStream());
                            } else {
                                LOG.info("Failure occurred while processing controller for pod: {}, http status: {}, details: {}", new Object[]{podName, response.code(), response.body().string()});
                                handler.accept(null);
                            }
                        }
                        catch (IOException e) {
                            LOG.error("Unexpected Error", (Throwable)e);
                        }
                    });
                }
            });
        }
        catch (RuntimeException t) {
            throw new IOException("Unexpected Error", t);
        }
    }
}

