/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.logging.jsondb.controller;

import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodListBuilder;
import io.fabric8.kubernetes.api.model.PodListFluent;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.syndesis.server.jsondb.GetOptions;
import io.syndesis.server.jsondb.JsonDB;
import io.syndesis.server.jsondb.impl.SqlJsonDB;
import io.syndesis.server.logging.jsondb.controller.ActivityTrackingController;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.h2.jdbcx.JdbcDataSource;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.skife.jdbi.v2.DBI;

public class ActivityTrackingControllerTest {
    private SqlJsonDB jsondb;
    private DBI dbi;

    @Before
    public void before() {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL("jdbc:h2:mem:t;DB_CLOSE_DELAY=-1;MODE=PostgreSQL");
        this.dbi = new DBI((DataSource)ds);
        this.jsondb = new SqlJsonDB(this.dbi, null);
        this.jsondb.createTables();
    }

    @Test
    public void testLogsController() throws IOException {
        String expectedDBState = ActivityTrackingControllerTest.resource("logs-controller-db.json").trim();
        final String podLogs = ActivityTrackingControllerTest.resource("test-pod-x23x.txt");
        KubernetesClient client = (KubernetesClient)Mockito.mock(KubernetesClient.class);
        Mockito.when((Object)client.getConfiguration()).thenReturn((Object)((ConfigBuilder)new ConfigBuilder().withMasterUrl("http://master")).build());
        try (ActivityTrackingController controller = new ActivityTrackingController((JsonDB)this.jsondb, this.dbi, client){

            protected PodList listPods() {
                return ((PodListBuilder)((PodListFluent.ItemsNested)((PodFluent.StatusNested)((PodListFluent.ItemsNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodListBuilder().addNewItem().withNewMetadata().withName("test-pod-x23x")).addToLabels("syndesis.io/component", "integration")).addToLabels("syndesis.io/deployment-version", "3")).addToLabels("syndesis.io/integration-id", "my-integration")).endMetadata()).withNewStatus().withPhase("Running")).endStatus()).endItem()).build();
            }

            protected boolean isPodRunning(String name) {
                return true;
            }

            protected void watchLog(String podName, Consumer<InputStream> handler, String sinceTime) throws IOException {
                this.execute("test", () -> handler.accept(new ByteArrayInputStream(podLogs.getBytes(StandardCharsets.UTF_8))));
            }
        };){
            controller.setStartupDelay("0 seconds");
            controller.setRetention("1000000000 days");
            controller.open();
            Awaitility.given().await().atMost(20L, TimeUnit.SECONDS).pollInterval(1L, TimeUnit.SECONDS).untilAsserted(() -> {
                String db = this.jsondb.getAsString("/", new GetOptions().prettyPrint(true));
                Assertions.assertThat((String)db).isEqualTo((Object)expectedDBState);
            });
        }
    }

    private static String resource(String file) throws IOException {
        try (InputStream is = Objects.requireNonNull(ActivityTrackingControllerTest.class.getClassLoader().getResourceAsStream(file));){
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ActivityTrackingControllerTest.copy(is, os);
            String string = new String(os.toByteArray(), StandardCharsets.UTF_8);
            return string;
        }
    }

    private static void copy(InputStream is, ByteArrayOutputStream os) throws IOException {
        int c;
        while ((c = is.read()) >= 0) {
            os.write(c);
        }
    }
}

