/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.logging.jsondb.controller;

import com.sun.net.httpserver.HttpServer;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.syndesis.server.jsondb.JsonDB;
import io.syndesis.server.logging.jsondb.controller.ActivityTrackingController;
import io.syndesis.server.logging.jsondb.controller.PodLogMonitor;
import io.syndesis.server.logging.jsondb.controller.TestPodLogMonitor;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Phaser;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.skife.jdbi.v2.DBI;

public class KubernetesSupportIT {
    final AtomicInteger count = new AtomicInteger(0);
    final AtomicBoolean running = new AtomicBoolean(false);
    HttpServer server;

    @Before
    public void setup() throws IOException {
        this.server = HttpServer.create(new InetSocketAddress("0.0.0.0", 0), 0);
        this.server.setExecutor(Executors.newCachedThreadPool());
        this.server.start();
        this.running.set(true);
        this.server.createContext("/api/v1/namespaces/syndesis/pods/pod/log", exchange -> {
            exchange.sendResponseHeaders(200, 0L);
            try {
                PrintStream body = new PrintStream(exchange.getResponseBody());
                Throwable throwable = null;
                try {
                    while (this.running.get()) {
                        int current = this.count.incrementAndGet();
                        body.println(current);
                        body.flush();
                        if (current > 5) {
                            Thread.sleep(600L);
                        }
                        Thread.sleep(1000L);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    KubernetesSupportIT.$closeResource(throwable, body);
                }
            }
            catch (InterruptedException ignored) {
                return;
            }
            finally {
                exchange.close();
            }
        });
    }

    @Test
    public void shouldTolerateNetworkTimeouts() throws IOException, InterruptedException, ExecutionException {
        String masterUrl = "http://0.0.0.0:" + this.server.getAddress().getPort();
        Config config = ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl(masterUrl)).withNamespace("syndesis")).build();
        final AtomicInteger counter = new AtomicInteger(-1);
        try (DefaultKubernetesClient client = new DefaultKubernetesClient(config);){
            final Phaser phaser = new Phaser(2);
            final Pod pod = ((PodBuilder)((PodFluent.StatusNested)((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod")).addToLabels("syndesis.io/integration-id", "id")).addToLabels("syndesis.io/deployment-version", "1")).endMetadata()).withNewStatus().withPhase("Running")).endStatus()).build();
            JsonDB jsondb = (JsonDB)Mockito.mock(JsonDB.class);
            DBI dbi = (DBI)Mockito.mock(DBI.class);
            ActivityTrackingController controller = new ActivityTrackingController(jsondb, dbi, (KubernetesClient)client){

                protected boolean isPodRunning(String name) {
                    return true;
                }

                protected PodList listPods() {
                    PodList podList = new PodList();
                    podList.setItems(Collections.singletonList(pod));
                    return podList;
                }

                protected PodLogMonitor createLogMonitor(Pod pod2) throws IOException {
                    return new TestPodLogMonitor(this, pod2, counter, phaser);
                }
            };
            controller.kubernetesSupport.setReadTimeout(Duration.ofMillis(1500L));
            controller.open();
            phaser.arriveAndAwaitAdvance();
            Assertions.assertThat((int)counter.get()).isGreaterThanOrEqualTo(5);
            phaser.arriveAndAwaitAdvance();
            Assertions.assertThat((int)counter.get()).isGreaterThan(10);
        }
    }

    @After
    public void stopServer() throws IOException {
        this.running.compareAndSet(true, false);
        this.server.stop(0);
    }
}

