/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.logging.jsondb.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.syndesis.common.util.SuppressFBWarnings;
import java.util.HashSet;
import java.util.Set;

public final class JsonNodeSupport {
    private JsonNodeSupport() {
    }

    public static String getString(JsonNode json, String field) {
        JsonNode value = json.get(field);
        if (value == null) {
            return null;
        }
        if (value.isNull()) {
            return null;
        }
        return value.asText();
    }

    public static String removeString(ObjectNode json, String field) {
        JsonNode value = json.remove(field);
        if (value == null) {
            return null;
        }
        if (value.isNull()) {
            return null;
        }
        return value.asText();
    }

    public static Long removeLong(ObjectNode json, String field) {
        JsonNode value = json.remove(field);
        if (value == null) {
            return null;
        }
        if (value.isNull()) {
            return null;
        }
        return value.asLong();
    }

    public static Long getLong(JsonNode json, String field) {
        JsonNode value = json.get(field);
        if (value == null) {
            return null;
        }
        if (value.isNull()) {
            return null;
        }
        return value.asLong();
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public static Boolean removeBoolean(ObjectNode json, String field) {
        JsonNode value = json.remove(field);
        if (value == null) {
            return null;
        }
        if (value.isNull()) {
            return null;
        }
        return value.asBoolean();
    }

    public static Set<String> fieldNames(JsonNode json) {
        HashSet<String> rc = new HashSet<String>();
        json.fieldNames().forEachRemaining(rc::add);
        return rc;
    }
}

