/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.logging.jsondb.controller;

import com.fasterxml.jackson.databind.JsonNode;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodListBuilder;
import io.fabric8.kubernetes.api.model.PodListFluent;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.syndesis.common.util.Json;
import io.syndesis.common.util.KeyGenerator;
import io.syndesis.server.jsondb.GetOptions;
import io.syndesis.server.jsondb.JsonDB;
import io.syndesis.server.jsondb.impl.SqlJsonDB;
import io.syndesis.server.logging.jsondb.controller.ActivityTrackingController;
import io.syndesis.server.logging.jsondb.controller.PodLogMonitor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.h2.jdbcx.JdbcDataSource;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.skife.jdbi.v2.DBI;

public class ActivityTrackingControllerTest {
    private SqlJsonDB jsondb;
    private DBI dbi;
    private KubernetesClient client;

    @Before
    public void before() {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL("jdbc:h2:mem:t;DB_CLOSE_DELAY=-1;MODE=PostgreSQL");
        this.dbi = new DBI((DataSource)ds);
        this.jsondb = new SqlJsonDB(this.dbi, null);
        this.jsondb.createTables();
        this.client = (KubernetesClient)Mockito.mock(KubernetesClient.class);
        Mockito.when((Object)this.client.getConfiguration()).thenReturn((Object)((ConfigBuilder)new ConfigBuilder().withMasterUrl("http://master")).build());
    }

    @After
    public void destroyEverything() {
        this.jsondb.dropTables();
    }

    @Test
    public void testLogsController() throws IOException {
        String expectedDBState = ActivityTrackingControllerTest.resource("logs-controller-db.json").trim();
        String podLogs = ActivityTrackingControllerTest.resource("test-pod-x23x.txt");
        ByteArrayInputStream podLogsStream = new ByteArrayInputStream(podLogs.getBytes(StandardCharsets.UTF_8));
        try (StubbedController controller = new StubbedController((JsonDB)this.jsondb, this.dbi, this.client, podLogsStream, ZonedDateTime.parse("2018-01-12T21:22:02.068338027Z").toInstant().toEpochMilli());){
            controller.setStartupDelay("0 seconds");
            controller.setRetention(Integer.MAX_VALUE);
            controller.open();
            Awaitility.given().await().atMost(20L, TimeUnit.SECONDS).pollInterval(1L, TimeUnit.SECONDS).untilAsserted(() -> {
                String db = this.jsondb.getAsString("/", new GetOptions().prettyPrint(true));
                Assertions.assertThat((String)db).isEqualTo((Object)expectedDBState);
            });
        }
    }

    @Test
    public void shouldRetainLastRetainActivityLogs() throws IOException {
        try (InputStream podLogsStream = ActivityTrackingControllerTest.logStream(1100);
             StubbedController controller = new StubbedController((JsonDB)this.jsondb, this.dbi, this.client, podLogsStream, System.currentTimeMillis());){
            controller.setStartupDelay("0 seconds");
            controller.setCleanUpInterval("15 minutes");
            controller.open();
            Awaitility.given().await().atMost(20L, TimeUnit.SECONDS).pollInterval(1L, TimeUnit.SECONDS).untilAsserted(() -> {
                String json = this.jsondb.getAsString("/", new GetOptions().prettyPrint(true));
                Assertions.assertThat((String)json).isNotNull();
                JsonNode tree = Json.reader().readTree(json);
                Assertions.assertThat((int)tree.get("activity").get("exchanges").get("my-integration").size()).isGreaterThan(1000);
            });
            controller.cleanupLogs();
            String json = this.jsondb.getAsString("/", new GetOptions().prettyPrint(true));
            Assertions.assertThat((String)json).isNotNull();
            JsonNode tree = Json.reader().readTree(json);
            Assertions.assertThat((int)tree.get("activity").get("exchanges").get("my-integration").size()).isLessThanOrEqualTo(controller.getRetention());
        }
    }

    private static String timestamp() {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(ZonedDateTime.now(ZoneOffset.UTC));
    }

    private static InputStream logStream(final int totalExchanges) {
        InputStream podLogsStream = new InputStream(){
            int exchanges;
            int idx;
            byte[] buffy;
            String exchange;
            final Supplier<byte[]> lineSupplier = () -> (ActivityTrackingControllerTest.timestamp() + " {\"exchange\":\"" + this.exchange + "\",\"status\":\"begin\"}\n" + ActivityTrackingControllerTest.timestamp() + " {\"exchange\":\"" + this.exchange + "\",\"step\":\"s2\",\"id\":\"i-L38cZ5Jd1L876xV4vEHz\",\"message\":\"Hello World\"}\n" + ActivityTrackingControllerTest.timestamp() + " {\"exchange\":\"" + this.exchange + "\",\"step\":\"s2\",\"id\":\"i-L38cZ5Jd1L876xV4vEGz\",\"duration\":582977}\n" + ActivityTrackingControllerTest.timestamp() + " {\"exchange\":\"" + this.exchange + "\",\"step\":\"s3\",\"id\":\"-L38cZ5Nd1L876xV4vEI\",\"duration\":18087}\n" + ActivityTrackingControllerTest.timestamp() + " {\"exchange\":\"" + this.exchange + "\",\"step\":\"s4\",\"id\":\"i-L38cZ5Od1L876xV4vEJz\",\"duration\":494949}\n" + ActivityTrackingControllerTest.timestamp() + " {\"exchange\":\"" + this.exchange + "\",\"status\":\"done\",\"failed\":false}\n").getBytes(StandardCharsets.UTF_8);

            @Override
            public int read() throws IOException {
                if (this.buffy == null || this.buffy.length == this.idx) {
                    if (this.exchanges++ > totalExchanges) {
                        return -1;
                    }
                    this.exchange = KeyGenerator.createKey();
                    this.buffy = this.lineSupplier.get();
                    this.idx = 0;
                }
                return this.buffy[this.idx++];
            }
        };
        return podLogsStream;
    }

    private static String resource(String file) throws IOException {
        try (InputStream is = Objects.requireNonNull(ActivityTrackingControllerTest.class.getClassLoader().getResourceAsStream(file));){
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ActivityTrackingControllerTest.copy(is, os);
            String string = new String(os.toByteArray(), StandardCharsets.UTF_8);
            return string;
        }
    }

    private static void copy(InputStream is, ByteArrayOutputStream os) throws IOException {
        int c;
        while ((c = is.read()) >= 0) {
            os.write(c);
        }
    }

    private static final class StubbedController
    extends ActivityTrackingController {
        private final InputStream podLogs;
        private long time;

        private StubbedController(JsonDB jsondb, DBI dbi, KubernetesClient client, InputStream podLogs, long time) {
            super(jsondb, dbi, client);
            this.podLogs = podLogs;
            this.time = time;
        }

        protected PodList listPods() {
            return ((PodListBuilder)((PodListFluent.ItemsNested)((PodFluent.StatusNested)((PodListFluent.ItemsNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodListBuilder().addNewItem().withNewMetadata().withName("test-pod-x23x")).addToLabels("syndesis.io/component", "integration")).addToLabels("syndesis.io/deployment-version", "3")).addToLabels("syndesis.io/integration-id", "my-integration")).endMetadata()).withNewStatus().withPhase("Running")).endStatus()).endItem()).build();
        }

        protected boolean isPodRunning(String name) {
            return true;
        }

        protected void watchLog(String podName, Consumer<InputStream> handler, String sinceTime) throws IOException {
            this.execute("test", () -> handler.accept(this.podLogs));
        }

        protected PodLogMonitor createLogMonitor(Pod pod) {
            return new PodLogMonitor(this, pod){

                long now() {
                    return time;
                }
            };
        }
    }
}

