/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.logging.jsondb.controller;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.internal.PodOperationsImpl;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesSupport {
    private static final Set<String> BLACKLISTED_CONTAINERS = Collections.singleton("istio-proxy");
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesSupport.class);
    private final KubernetesClient client;
    private final OkHttpClient okHttpClient;
    private Duration readTimeout = Duration.ofMinutes(35L);

    public KubernetesSupport(KubernetesClient client) {
        this.client = client;
        this.okHttpClient = HttpClientUtils.createHttpClient((Config)this.client.getConfiguration());
    }

    protected void watchLog(final String podName, final Consumer<InputStream> handler, String sinceTime, final Executor executor) throws IOException {
        try {
            PodOperationsImpl pod = (PodOperationsImpl)this.client.pods().withName(podName);
            List containers = ((Pod)pod.get()).getSpec().getContainers();
            String containerFilter = this.getSpecificUserContainer(containers).map(n -> "&container=" + n).orElse("");
            StringBuilder url = new StringBuilder().append(pod.getResourceUrl().toString()).append("/log?pretty=false&follow=true&timestamps=true").append(containerFilter);
            if (sinceTime != null) {
                url.append("&sinceTime=").append(sinceTime);
            }
            final String podLogUrl = url.toString();
            Thread.currentThread().setName("Logs Controller [running], request: " + podLogUrl);
            Request request = new Request.Builder().url(new URL(podLogUrl)).get().tag((Object)"log-watcher").build();
            OkHttpClient clone = this.okHttpClient.newBuilder().readTimeout(this.readTimeout.toMillis(), TimeUnit.MILLISECONDS).build();
            clone.newCall(request).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    LOG.info("Failure occurred getting  controller for pod: {},", (Object)podName, (Object)e);
                    handler.accept(null);
                }

                public void onResponse(Call call, Response response) throws IOException {
                    executor.execute(() -> {
                        Thread.currentThread().setName("Logs Controller [running], streaming: " + podLogUrl);
                        try {
                            if (response.code() == 200) {
                                handler.accept(response.body().byteStream());
                            } else {
                                LOG.info("Failure occurred while processing controller for pod: {}, http status: {}, details: {}", new Object[]{podName, response.code(), response.body().string()});
                                handler.accept(null);
                            }
                        }
                        catch (SocketTimeoutException timeout) {
                            LOG.warn("Timed out reading the log stream");
                            LOG.debug("Timed out reading the log stream", (Throwable)timeout);
                        }
                        catch (IOException e) {
                            LOG.error("Unexpected Error", (Throwable)e);
                        }
                        finally {
                            Thread.currentThread().setName("Logs Controller [idle]");
                        }
                    });
                }
            });
        }
        catch (RuntimeException t) {
            throw new IOException("Unexpected Error", t);
        }
        finally {
            Thread.currentThread().setName("Logs Controller [idle]");
        }
    }

    protected Optional<String> getSpecificUserContainer(List<Container> containers) {
        if (containers.size() <= 1) {
            return Optional.empty();
        }
        return containers.stream().map(Container::getName).filter(n -> !BLACKLISTED_CONTAINERS.contains(n)).findFirst();
    }

    public void setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
    }

    void cancelAllRequests() {
        Dispatcher dispatcher = this.okHttpClient.dispatcher();
        dispatcher.cancelAll();
    }
}

