/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.logging.jsondb.service;

import com.fasterxml.jackson.databind.JsonNode;
import io.syndesis.common.util.Json;
import io.syndesis.server.endpoint.v1.handler.activity.Activity;
import io.syndesis.server.endpoint.v1.handler.activity.ActivityTrackingService;
import io.syndesis.server.jsondb.GetOptions;
import io.syndesis.server.jsondb.JsonDB;
import io.syndesis.server.logging.jsondb.controller.ActivityTrackingController;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"endpoints.dblogging.enabled"}, havingValue="true", matchIfMissing=true)
public class DBActivityTrackingService
implements ActivityTrackingService {
    private static final Logger LOG = LoggerFactory.getLogger(ActivityTrackingController.class);
    private final JsonDB jsondb;

    public DBActivityTrackingService(JsonDB jsondb) {
        this.jsondb = jsondb;
    }

    public List<Activity> getActivities(String integrationId, String from, Integer requestedLimit) throws IOException {
        GetOptions options;
        byte[] data;
        String path = "/activity/exchanges/" + integrationId;
        int limit = 10;
        if (requestedLimit != null) {
            limit = requestedLimit;
        }
        if (limit > 1000) {
            limit = 1000;
        }
        if ((data = this.jsondb.getAsByteArray(path, options = new GetOptions().order(GetOptions.Order.DESC).startAfter(from).limitToFirst(Integer.valueOf(limit)))) == null) {
            return new ArrayList<Activity>();
        }
        JsonNode map = Json.reader().readTree((InputStream)new ByteArrayInputStream(data));
        ArrayList<Activity> rc = new ArrayList<Activity>();
        Iterator i = map.fields();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            try {
                String value = ((JsonNode)entry.getValue()).textValue();
                Activity activity = (Activity)Json.reader().forType(Activity.class).readValue(value);
                if (activity.getSteps() == null) {
                    activity.setSteps(new ArrayList());
                }
                rc.add(activity);
            }
            catch (RuntimeException ignored) {
                LOG.debug("Could convert entry: {}", (Object)entry, (Object)ignored);
            }
        }
        return rc;
    }
}

