/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.metrics.jsondb;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.internal.readiness.Readiness;
import io.syndesis.common.model.integration.Integration;
import io.syndesis.common.model.metrics.IntegrationMetricsSummary;
import io.syndesis.server.dao.manager.DataManager;
import io.syndesis.server.jsondb.JsonDB;
import io.syndesis.server.metrics.jsondb.IntegrationMetricsHandler;
import io.syndesis.server.metrics.jsondb.JsonDBRawMetrics;
import io.syndesis.server.metrics.jsondb.PodMetricsReader;
import io.syndesis.server.metrics.jsondb.RawMetrics;
import io.syndesis.server.metrics.jsondb.RawMetricsHandler;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"metrics.kind"}, havingValue="sql")
public class MetricsCollector
implements Runnable,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsCollector.class);
    private final KubernetesClient kubernetes;
    private final DataManager dataManager;
    private final RawMetricsHandler rmh;
    private final IntegrationMetricsHandler imh;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private final ExecutorService executor = Executors.newCachedThreadPool((ThreadFactory)new CustomizableThreadFactory("metrics-collector"));

    @Autowired
    public MetricsCollector(DataManager dataManager, JsonDB jsonDB, KubernetesClient kubernetes) {
        this.dataManager = dataManager;
        this.kubernetes = kubernetes;
        this.rmh = new JsonDBRawMetrics(jsonDB);
        this.imh = new IntegrationMetricsHandler(dataManager);
    }

    @PostConstruct
    public void open() {
        LOGGER.info("Starting metrics collector.");
        this.scheduler.scheduleAtFixedRate(this, 10L, 10L, TimeUnit.SECONDS);
    }

    @Override
    public void close() throws IOException {
        LOGGER.info("Stopping metrics collector.");
        MetricsCollector.close(this.scheduler);
        MetricsCollector.close(this.executor);
    }

    @Override
    public void run() {
        LOGGER.debug("Collecting metrics for active integration pods.");
        try {
            List integrationPodList = ((PodList)((FilterWatchListDeletable)this.kubernetes.pods().withLabel("integration")).list()).getItems();
            HashSet<String> livePods = new HashSet<String>();
            for (Pod pod : integrationPodList) {
                livePods.add(pod.getMetadata().getName());
            }
            integrationPodList.stream().filter(p -> Readiness.isReady((HasMetadata)p)).forEach(p -> this.executor.execute(new PodMetricsReader(this.kubernetes, p.getMetadata().getName(), (String)p.getMetadata().getAnnotations().get("syndesis.io/integration-name"), (String)p.getMetadata().getLabels().get("syndesis.io/integration-id"), (String)p.getMetadata().getLabels().get("syndesis.io/deployment-version"), this.rmh)));
            Set activeIntegrationIds = this.dataManager.fetchIds(Integration.class);
            for (String integrationId : activeIntegrationIds) {
                LOGGER.debug("Computing metrics for IntegrationId: {}", (Object)integrationId);
                Map<String, RawMetrics> rawMetrics = this.rmh.getRawMetrics(integrationId);
                IntegrationMetricsSummary imSummary = this.imh.compute(integrationId, rawMetrics, livePods);
                this.imh.persist(imSummary);
                this.rmh.curate(integrationId, rawMetrics, livePods);
            }
            this.rmh.curate(activeIntegrationIds);
            this.imh.curate(activeIntegrationIds);
        }
        catch (Exception ex) {
            LOGGER.error("Error while iterating integration pods.", (Throwable)ex);
        }
    }

    private static List<Runnable> close(ExecutorService service) throws IOException {
        service.shutdown();
        try {
            if (service.awaitTermination(1L, TimeUnit.MINUTES)) {
                return service.shutdownNow();
            }
            return Collections.emptyList();
        }
        catch (InterruptedException e) {
            return service.shutdownNow();
        }
    }
}

